// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/dump/bcdump.cpp,v 1.1.1.1 2001/07/23 07:25:35 xli18 Exp $
//

#include "platform.h"
#include "orp_types.h"
#include "Class.h"
#include "internal_jit_intf.h"



char *dis_bc(const Byte *bc_start,
             unsigned *bc_ip,
             char *buf,
             Method_Handle jm)
{
    Method *java_method = (Method *)jm;
    Class *java_class = java_method->get_class();
    const Byte *this_bc = bc_start + *bc_ip;
    const Byte *bc = bc_start + *bc_ip;
    //cout << *java_method;
    char *bufptr = buf + sprintf(buf, "%4d [0x%02x] ", *bc_ip, (unsigned)*bc);

//------------------------------------------------------------------


    const unsigned char *first_bc = bc_start;
	const unsigned char *last_bc = bc + 1; // last bytecode
	//const unsigned char *bc = first_bc;
    const unsigned char *prev_bc;
	const unsigned char *curr_bc = first_bc;	// ptr to current bytecode
	unsigned index; // index of constant pools or variables
	while (bc < last_bc) {
        prev_bc = curr_bc;
		curr_bc = bc;
		unsigned bc_index = curr_bc-first_bc; // offset of current bytecode
		unsigned char bytecode = *bc++;	// value of current bytecode
        char *s = NULL;

		switch (bytecode) {
		case 0x00:	break; // nop
            bufptr += sprintf(bufptr, "nop");
		//
		// constant loads
		//
		case 0x01:			// aconst_null
            bufptr += sprintf(bufptr, "aconst_null");
			break;
		case 0x02:
			// iconst -1
            bufptr += sprintf(bufptr, "iconst_m1");
			break;
        case 0x03: case 0x04: case 0x05:
		case 0x06: case 0x07: case 0x08:
			// iconst 0,...,5
            bufptr += sprintf(bufptr, "iconst_%d", (unsigned)(bytecode-0x03));
			break;
		case 0x09: case 0x0a:
			// lconst 0,1
            bufptr += sprintf(bufptr, "lconst_%d", (unsigned)(bytecode-0x09));
			break;
		case 0x0b:	// fconst 0.0F
            bufptr += sprintf(bufptr, "fconst_0");
			break;
		case 0x0c:	// fconst 1.0F
            bufptr += sprintf(bufptr, "fconst_1");
			break;
		case 0x0d:	// fconst 2.0F
            bufptr += sprintf(bufptr, "fconst_2");
			break;
		case 0x0e:	// dconst 0.0
            bufptr += sprintf(bufptr, "dconst_0");
			break;
		case 0x0f:	// dconst 1.0
            bufptr += sprintf(bufptr, "dconst_1");
			break;
		//
		// stack pushes
		//
        case 0x10: 		// bipush
            bufptr += sprintf(bufptr, "bipush %d", *(char*)bc++);
            break;
		case 0x11:		// sipush
            bufptr += sprintf(bufptr, "sipush %d", (*(char*)bc << 8) + bc[1]);
			bc += 2;
			break;
		case 0x12:						// ldc
			//
			// load constant from constant pool
			//
            {
    			index = *bc++;
                bufptr += sprintf(bufptr, "ldc #%d, ", index);
                Java_Type t = class_get_cp_const_type(java_class, index);
                switch(t) {
                case JAVA_TYPE_STRING:
                    {
                        assert(index < java_class->cp_size);
	                    Const_Pool *cp = java_class->const_pool;

	                    String *str = cp[index].string;
                        assert(cp_is_cnst(cp, index));
                        bufptr += sprintf(bufptr, "string: '");
                        for(char *s = str->bytes; *s; s++) {
                            unsigned char ch = *s;
                            if(ch >= ' ' && ch <= 'z') {
                                bufptr += sprintf(bufptr, "%c", ch);
                            } else {
                                bufptr += sprintf(bufptr, "\\x%02x", (ch & 0xff));
                            }
                        }
                        bufptr += sprintf(bufptr, "'");
                    }
                    break;
                case JAVA_TYPE_INT:
                    {
                        const int *a = (const int *)
                            class_get_addr_of_constant(java_class, index);
                        bufptr += sprintf(bufptr, "int: %d = 0x%08x", *a, *a);
                    }
                    break;
                case JAVA_TYPE_FLOAT:
                    {
                        const float *a = (const float *)
                            class_get_addr_of_constant(java_class, index);
                        bufptr += sprintf(bufptr, "float: %f", *a);
                    }
                    break;
                default:
                    assert(0);
                    break;
                }
            }
			break;
		case 0x13:			// ldc_w
            {
    			index = (*bc << 8) + bc[1];
		    	bc += 2;
                bufptr += sprintf(bufptr, "ldc_w %d ", index);
                Java_Type t = class_get_cp_const_type(java_class, index);
                switch(t) {
                case JAVA_TYPE_STRING:
                    {
                        assert(index < java_class->cp_size);
	                    Const_Pool *cp = java_class->const_pool;

	                    String *str = cp[index].string;
                        assert(cp_is_cnst(cp, index));
                        bufptr += sprintf(bufptr, "string: '%s'", str->bytes);
                    }
                    break;
                case JAVA_TYPE_INT:
                    {
                        const int *a = (const int *)
                            class_get_addr_of_constant(java_class, index);
                        bufptr += sprintf(bufptr, "int: %d = 0x%08x", *a, *a);
                    }
                    break;
                case JAVA_TYPE_FLOAT:
                    {
                        const float *a = (const float *)
                            class_get_addr_of_constant(java_class, index);
                        bufptr += sprintf(bufptr, "float: %f", *a);
                    }
                    break;
                default:
                    assert(0);
                    break;
                }
            }
			//gen_ldc(data_block,emitter,stack,mem_manager,method_patch_list,class_handle,index,method_info);
			break;
		case 0x14:			// ldc2_w
            {
    			index = (*bc << 8) + bc[1];
	    		bc += 2;
                bufptr += sprintf(bufptr, "ldc2_w #%d ", index);
                Java_Type t = class_get_cp_const_type(java_class, index);
                switch(t) {
                case JAVA_TYPE_LONG:
                    {
                        const int64 *a = (const int64 *)
                            class_get_addr_of_constant(java_class, index);
                        bufptr += sprintf(bufptr,
                                          "long: %I64d = 0x%016I64x",
                                          *a, *a);
                    }
                    break;
                case JAVA_TYPE_DOUBLE:
                    {
                        const double *a = (const double *)
                            class_get_addr_of_constant(java_class, index);
                        bufptr += sprintf(bufptr, "double: %lf", *a);
                    }
                    break;
                default:
                    assert(0);
                    break;
                }
            }
			//gen_ldc(data_block,emitter,stack,mem_manager,method_patch_list,class_handle,index,method_info);
			break;
		case 0x15:	// iload
		case 0x16:	// lload
		case 0x17:	// fload
		case 0x18:	// dload
		case 0x19:	// aload
            bufptr += sprintf(bufptr, "%cload %d", "ilfda"[bytecode - 0x15],
                *(char*)bc++);
			break;
		case 0x1a: case 0x1b: case 0x1c: case 0x1d:	// iload_{0,1,2,3}
            index = bytecode-0x1a;
            bufptr += sprintf(bufptr, "iload_%d", index);
			break;
		case 0x22: case 0x23: case 0x24: case 0x25:	// fload_{0,1,2,3}
            index = bytecode-0x22;
            bufptr += sprintf(bufptr, "fload_%d", index);
			break;
		case 0x2a: case 0x2b: case 0x2c: case 0x2d:	// aload_{0,1,2,3}
            index = (bytecode-0x2a);
            bufptr += sprintf(bufptr, "aload_%d", index);
			break;
		case 0x1e: case 0x1f: case 0x20: case 0x21:	// lload_{0,1,2,3}
            index = (bytecode-0x1e);
            bufptr += sprintf(bufptr, "lload_%d", index);
			break;
		case 0x26: case 0x27: case 0x28: case 0x29:	// dload_{0,1,2,3}
            index = (bytecode-0x26);
            bufptr += sprintf(bufptr, "dload_%d", index);
			break;
			//
			// array load
			//
		case 0x2e:	// iaload
		case 0x2f:	// laload
		case 0x30:	// faload
		case 0x31:	// daload
		case 0x32:	// aaload
		case 0x33:	// baload
  		case 0x34:	// caload
 		case 0x35:	// saload
            bufptr += sprintf(bufptr, "%caload", "ilfdabcs"[bytecode - 0x2e]);
            break;
		case 0x36:	// istore
		case 0x37:	// lstore
		case 0x38:	// fstore
		case 0x39:	// dstore
		case 0x3a:	// astore
            bufptr += sprintf(bufptr, "%cstore %d", "ilfda"[bytecode - 0x36],
                *(char*)bc++);
			break;
		case 0x4b: case 0x4c: case 0x4d: case 0x4e:	// astore_{0,1,2,3}
            index = bytecode - 0x4b;
            bufptr += sprintf(bufptr, "astore_%d", index);
			break;
		case 0x3b: case 0x3c: case 0x3d: case 0x3e:	// istore_{0,1,2,3}
            index = bytecode - 0x3b;
            bufptr += sprintf(bufptr, "istore_%d", index);
			break;
		case 0x43: case 0x44: case 0x45: case 0x46: // fstore_{0,1,2,3}
            index = bytecode - 0x43;
            bufptr += sprintf(bufptr, "fstore_%d", index);
			break;
		case 0x3f: case 0x40: case 0x41: case 0x42: // lstore_{0,1,2,3}
            index = bytecode - 0x3f;
            bufptr += sprintf(bufptr, "lstore_%d", index);
			break;
		case 0x47: case 0x48: case 0x49: case 0x4a:	// dstore_{0,1,2,3}
            index = bytecode - 0x47;
            bufptr += sprintf(bufptr, "dstore_%d", index);
			break;
		case 0x4f:	// iastore
		case 0x50:	// lastore
		case 0x51:	// fastore
		case 0x52:	// dastore
		case 0x53:	// aastore
 		case 0x54:	// bastore
		case 0x55:	// castore
 		case 0x56:	// sastore
            bufptr += sprintf(bufptr, "%castore", "ilfdabcs"[bytecode - 0x4f]);
 			//emit_array_store(mem_manager,emitter,stack,operand_pool,"IJFDLBCS"[bytecode - 0x4f],
            //			            method_patch_list,method_handle,bc_index,method_info);
            break;
		//
		// stack operations
		//
		case 0x57:	// pop
            bufptr += sprintf(bufptr, "pop");
			break;
		case 0x58:	// pop2
            bufptr += sprintf(bufptr, "pop2");
			break;
		case 0x59: // dup
			// push the stack top
            bufptr += sprintf(bufptr, "dup");
			break;
		case 0x5a:	// dup_x1
            bufptr += sprintf(bufptr, "dup_x1");
			break;
		case 0x5b: 	// dup_x2
            bufptr += sprintf(bufptr, "dup_x2");
			break;
		case 0x5c:	// dup2
            bufptr += sprintf(bufptr, "dup2");
			break;
		case 0x5d:	// dup2_x1
            bufptr += sprintf(bufptr, "dup2_x1");
			break;
		case 0x5e:	// dup2_x2
            bufptr += sprintf(bufptr, "dup2_x2");
			break;
		case 0x5f:  // swap
			// swap top two operands
            bufptr += sprintf(bufptr, "swap");
			break;
		//
		// arithmetic operations
		//
			//
			// add
			//
		case 0x60:	// iadd
		case 0x61:	// ladd
		case 0x62:	// fadd
		case 0x63:	// dadd
            bufptr += sprintf(bufptr, "%cadd", "ilfd"[bytecode - 0x60]);
			break;
			//
			// sub
			//
		case 0x64:	// isub
		case 0x65:	// lsub
		case 0x66:	// fsub
		case 0x67:	// dsub
            bufptr += sprintf(bufptr, "%csub", "ilfd"[bytecode - 0x64]);
			break;
			//
			// mul
			//
		case 0x68:	// imul
		case 0x69:	// lmul
		case 0x6a:	// fmul
		case 0x6b:	// dmul
            bufptr += sprintf(bufptr, "%cmul", "ilfd"[bytecode - 0x68]);
			break;
			//
			//  div
			//
		case 0x6c:	// idiv
		case 0x6d:	// ldiv
		case 0x6e:	// fdiv
		case 0x6f:	// ddiv
            bufptr += sprintf(bufptr, "%cdiv", "ilfd"[bytecode - 0x6c]);
			break;
			//
			// rem
			//
		case 0x70:	// irem
		case 0x71:	// lrem
		case 0x72:	// frem
		case 0x73:	// drem
            bufptr += sprintf(bufptr, "%crem", "ilfd"[bytecode - 0x70]);
			break;
			//
			// neg
			//
		case 0x74:	// ineg
		case 0x75:	// lneg
		case 0x76:	// fneg
		case 0x77:	// dneg
            bufptr += sprintf(bufptr, "%cneg", "ilfd"[bytecode - 0x74]);
			break;
		//
		// logical operations
		//
			//
			// shl
			//
		case 0x78: // ishl
            bufptr += sprintf(bufptr, "ishl");
			break;
		case 0x79: // lshl
            bufptr += sprintf(bufptr, "lshl");
			break;
		case 0x7a: // ishr
            bufptr += sprintf(bufptr, "ishr");
			break;
		case 0x7b: // lshr
            bufptr += sprintf(bufptr, "lshr");
			break;
		case 0x7c: // iushr
            bufptr += sprintf(bufptr, "iushr");
			break;
		case 0x7d:	// lushr
            bufptr += sprintf(bufptr, "lushr");
			break;
			//
			// and
			//
		case 0x7e:	// iand
            bufptr += sprintf(bufptr, "iand");
			break;
		case 0x7f:	// land
            bufptr += sprintf(bufptr, "land");
			break;
			//
			// or
			//
		case 0x80:	// ior
            bufptr += sprintf(bufptr, "ior");
			break;
		case 0x81:	// lor
            bufptr += sprintf(bufptr, "lor");
			break;
			//
			// xor
			//
		case 0x82:	// ixor
            bufptr += sprintf(bufptr, "ixor");
			break;
		case 0x83:	// lxor
            bufptr += sprintf(bufptr, "lxor");
			break;
			//
			// iinc local, constant
			//
		case 0x84:  // iinc
			index = *bc++;
			//imm.value = *(char*)bc++;
            bufptr += sprintf(bufptr, "iinc %d %d", index, *(char*)bc++);
			break;

		case 0x85:	// i2l
            bufptr += sprintf(bufptr, "i2l");
			break;
		case 0x86:	// i2f
            bufptr += sprintf(bufptr, "i2f");
            break;
		case 0x87:	// i2d
            bufptr += sprintf(bufptr, "i2d");
			break;
		case 0x88:	// l2i
			//
			// keep low 32 bit
			//
            bufptr += sprintf(bufptr, "l2i");
			break;
		case 0x89:	// l2f
            bufptr += sprintf(bufptr, "l2f");
            break;
		case 0x8a:	// l2d
            bufptr += sprintf(bufptr, "l2d");
			break;
		case 0x8b:	// f2i
            bufptr += sprintf(bufptr, "f2i");
            break;
		case 0x8c:	// f2l
            bufptr += sprintf(bufptr, "f2l");
           break;
		case 0x8d:	// f2d
            bufptr += sprintf(bufptr, "f2d");
			break;
		case 0x8e:	// d2i
            bufptr += sprintf(bufptr, "d2i");
			break;
		case 0x8f:	// d2l
            bufptr += sprintf(bufptr, "d2l");
            break;
		case 0x90:	// d2f
            bufptr += sprintf(bufptr, "d2f");
		    break;
		case 0x91:	// i2b
            bufptr += sprintf(bufptr, "i2b");
			break;
		case 0x92:	// i2c
            bufptr += sprintf(bufptr, "i2c");
			break;
		case 0x93:	// i2s
            bufptr += sprintf(bufptr, "i2s");
			break;
		case 0x94:	// lcmp
            bufptr += sprintf(bufptr, "lcmp");
			break;
		case 0x95:  // fcmpl
            bufptr += sprintf(bufptr, "fcmpl");
			break;
		case 0x96:	// fcmpg
            bufptr += sprintf(bufptr, "fcmpg");
			break;
		case 0x97:	// dcmpl
            bufptr += sprintf(bufptr, "dcmpl");
			break;
		case 0x98:  // dcmpg
            bufptr += sprintf(bufptr, "dcmpg");
			break;
            //
            // if{eq,ne,lt,ge,gt,le} int comparisons against zero
            //
		case 0x99:
            if(!s)
                s = "eq";
        case 0x9a:	
            if(!s)
                s = "ne";
		case 0x9b:
            if(!s)
                s = "lt";
        case 0x9c:
            if(!s)
                s = "ge";
		case 0x9d:
            if(!s)
                s = "gt";
        case 0x9e:
            if(!s)
                s = "le";
	    	{
		    	int branch_offset = (*(char*)bc << 8) + bc[1];
			    unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
                bufptr += sprintf(bufptr, "if%s %d", s, target_bc_index);
	    		//unsigned fall_thru_index = bc_index + 3;
		    	bc += 2;
			    break;
    		}
            //
        	// if_icmp{eq,ne,lt,ge,gt,le}
            //
		case 0x9f:
            if(!s)
                s = "eq";
        case 0xa0:
            if(!s)
                s = "ne";
		case 0xa1:
            if(!s)
                s = "lt";
        case 0xa2:
            if(!s)
                s = "ge";
		case 0xa3:
            if(!s)
                s = "gt";
        case 0xa4:
            if(!s)
                s = "le";
    		{
	    		int branch_offset = (*(char*)bc << 8) + bc[1];
		    	unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
                bufptr += sprintf(bufptr, "if_icmp%s %d", s, target_bc_index);
	    		//unsigned fall_thru_index = bc_index + 3;
		    	bc += 2;
			    break;
    		}
            //
            // if_acmp{eq,ne}
            //
		case 0xa5:
            if(!s)
                s = "eq";
        case 0xa6:
            if(!s)
                s = "ne";
    		{
	    		int branch_offset = (*(char*)bc << 8) + bc[1];
		    	unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
                bufptr += sprintf(bufptr, "if_acmp%s %d", s, target_bc_index);
	    		//unsigned fall_thru_index = bc_index + 3;
		    	bc += 2;
			    break;
    		}
		case 0xa7:	// goto
		{
			int branch_offset = (*(char*)bc << 8) + bc[1];
			unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
			bc += 2;
            bufptr += sprintf(bufptr, "goto %d", target_bc_index);
			break;
		}
		case 0xa8:	// jsr
    		{
	    		int branch_offset = (*(char*)bc << 8) + bc[1];
		    	unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
                bufptr += sprintf(bufptr, "jsr %d", target_bc_index);
			    bc += 2;
	    	}
			break;
		case 0xa9: // ret
       		index = *bc++;
            bufptr += sprintf(bufptr, "ret %d", index);
			break;
		case 0xaa: // tableswitch
		{
            // skip over padding bytes to align on 4 byte boundary
            bc = (curr_bc+1) + ((4 - (curr_bc - first_bc + 1)) & 0x03);
            // offset default label
            int default_offset = ((bc[0]<<24) + (bc[1]<<16) + (bc[2]<<8) + bc[3]);
            // low
            int low = ((bc[4]<<24) + (bc[5]<<16) + (bc[6]<<8) + bc[7]);
            // high
            int high = ((bc[8]<<24) + (bc[9]<<16) + (bc[10]<<8) + bc[11]);
            bc += 12;
            int n_entries = high - low + 1;
            bufptr += sprintf(bufptr, "tableswitch %d to %d: default=%d\n",
                low, high, bc_index + default_offset);

            for (int i = 0; i < n_entries; i++) {
                int offset = ((bc[0]<<24) + (bc[1]<<16) + (bc[2]<<8) + bc[3]);
                bufptr += sprintf(bufptr, "\t\t%4d: %d\n",
                    low + i, bc_index + offset);
                bc += 4;
            }
			break;
		}
		case 0xab:	// lookupswitch
		{
            // skip over padding bytes to align on 4 byte boundary
            bc = (curr_bc+1) + ((4 - (curr_bc - first_bc + 1)) & 0x03);
            // offset default label
            int default_offset = ((bc[0]<<24) + (bc[1]<<16) + (bc[2]<<8) + bc[3]);
            // number of match-offset pairs in lookup table
            int npairs = ((bc[4]<<24) + (bc[5]<<16) + (bc[6]<<8) + bc[7]);
            bc += 8;
            bufptr += sprintf(bufptr, "lookupswitch %d: default=%d\n",
                npairs, bc_index + default_offset);
            
            for (int i = 0; i < npairs; i++) {
                int match = ((bc[0]<<24) + (bc[1]<<16) + (bc[2]<<8) + bc[3]);
                // get the offset
                int offset = ((bc[4]<<24) + (bc[5]<<16) + (bc[6]<<8) + bc[7]);
                bufptr += sprintf(bufptr, "\t\t%4d: %d\n",
                    match, bc_index + offset);
                bc += 8;
            }
            break;
        }
		case 0xac:	// ireturn
            bufptr += sprintf(bufptr, "ireturn");
			break;
		case 0xb0:	// areturn
            bufptr += sprintf(bufptr, "areturn");
			break;
		case 0xae:	// freturn
            bufptr += sprintf(bufptr, "freturn");
			break;
		case 0xad:	// lreturn
            bufptr += sprintf(bufptr, "lreturn");
			break;
		case 0xaf:	// dreturn
			//
			// return 64-bit fp value
			//
            bufptr += sprintf(bufptr, "dreturn");
			break;
        case 0xb1:	// return
            bufptr += sprintf(bufptr, "return");
            break;
		case 0xb2:	// getstatic
            //bufptr += sprintf(bufptr, "getstatic #%d", index);
        case 0xb3:	// putstatic
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                Field *f = class_resolve_static_field(java_class, index);
                assert(f);
                bufptr += sprintf(bufptr, 
                    "%sstatic #%d <Field %s.%s: %s>",
                    bytecode == 0xb3 ? "put" : "get",
                    index,
                    f->get_class()->name->bytes,
                    f->get_name()->bytes,
                    f->get_descriptor()
                    );
            }
			break;
		case 0xb4:	// getfield
            //bufptr += sprintf(bufptr, "getfield #%d", index);
		case 0xb5:	// putfield
            //bufptr += sprintf(bufptr, "putfield #%d", index);
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                Field *f = class_resolve_nonstatic_field(java_class, index);
                assert(f);
                bufptr += sprintf(bufptr, 
                    "%sfield #%d <Field %s.%s: %s>",
                    bytecode == 0xb5 ? "put" : "get",
                    index,
                    f->get_class()->name->bytes,
                    f->get_name()->bytes,
                    f->get_descriptor()
                    );
            }
			break;
		case 0xb6:	// invokevirtual
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                //Java_Method *callee = java_class->resolve_static_method(index);
                Method *callee = class_resolve_nonstatic_method(java_class, index);
                assert(callee);
                bufptr += sprintf(bufptr, "invokevirtual #%d <Method %s.%s%s>",
                    index,
                    callee->get_class()->name->bytes,
                    callee->get_name()->bytes,
                    callee->get_descriptor()
                    );
            }
			break;
		case 0xb7:	// invokespecial
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                //Java_Method *callee = java_class->resolve_static_method(index);
                Method *callee = class_resolve_nonstatic_method(java_class, index);
                assert(callee);
                bufptr += sprintf(bufptr, "invokespecial #%d <Method %s.%s%s>",
                    index,
                    callee->get_class()->name->bytes,
                    callee->get_name()->bytes,
                    callee->get_descriptor()
                    );
            }
			break;
        case 0xb8:	// invokestatic
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                //Java_Method *callee = java_class->resolve_static_method(index);
                Method *callee = class_resolve_static_method(java_class, index);
                assert(callee);
                bufptr += sprintf(bufptr, "invokestatic #%d <Method %s.%s%s>",
                    index,
                    callee->get_class()->name->bytes,
                    callee->get_name()->bytes,
                    callee->get_descriptor()
                    );
            }
            break;
        case 0xb9: // invokeinterface
            {
                index = (bc[0] << 8) + bc[1];
    			unsigned n_args = bc[2];
                bc += 4;
                //Java_Method *callee = java_class->resolve_static_method(index);
                Method *callee = class_resolve_interface_method(java_class, index);
                assert(callee);
                bufptr += sprintf(bufptr,
                    "invokeinterface #%d <Method %s.%s%s> %d args",
                    index,
                    callee->get_class()->name->bytes,
                    callee->get_name()->bytes,
                    callee->get_descriptor(),
                    n_args
                    );
            }
            break;
		case 0xba:				// unused
			break;
		case 0xbb:	// new
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                Class *c = class_resolve_class(java_class, index);
                assert(c);
                bufptr += sprintf(bufptr, "new #%d <Class %s>",
                    index,
                    c->name->bytes
                    );
            }
			break;
        case 0xbc:	// newarray
			index = *bc++;	// type code of array
            bufptr += sprintf(bufptr, "newarray %d", index);
			break;
		case 0xbd:	// anewarray
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                Class *c = class_resolve_class(java_class, index);
                assert(c);
                bufptr += sprintf(bufptr, "anewarray #%d <Class %s>",
                    index,
                    c->name->bytes
                    );
            }
		    break;
		case 0xbe:	// arraylength
            bufptr += sprintf(bufptr, "arraylength");
			break;
		case 0xbf:	// athrow
            bufptr += sprintf(bufptr, "athrow");
			break;
		case 0xc0:	// checkcast
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                Class *c = class_resolve_class(java_class, index);
                assert(c);
                bufptr += sprintf(bufptr, "checkcast #%d <Class %s>",
                    index,
                    c->name->bytes
                    );
            }
			break;
		case 0xc1:	// instanceof
            {
                index = (bc[0] << 8) + bc[1];
                bc += 2;
                Class *c = class_resolve_class(java_class, index);
                assert(c);
                bufptr += sprintf(bufptr, "instanceof #%d <Class %s>",
                    index,
                    c->name->bytes
                    );
            }
			break;
		case 0xc2:	// monitorenter
            bufptr += sprintf(bufptr, "monitorenter");
			break;
		case 0xc3:	// monitorexit
            bufptr += sprintf(bufptr, "monitorexit");
			break;
		case 0xc4:	// wide
			bytecode = *bc++;
			index = (bc[0] << 8) + bc[1];
			if (bytecode == 0x84) {
				// iinc local, constant
				bc += 2;
				int val = (*(char*)bc << 8) + bc[1];
				bc += 2;
                bufptr += sprintf(bufptr, "iinc %d %d", index, val);
			} else {
				bc += 2;
				switch (bytecode) {
				case 0x15:	// iload
				case 0x16:	// lload
				case 0x17:	// fload
				case 0x19:	// aload
				case 0x18:	// dload
                    bufptr += sprintf(bufptr,
                        "%cload %d", "ilfda"[bytecode - 0x15],
                        *(char*)bc++);
					break;
				case 0x36:	// istore
				case 0x38:	// fstore
				case 0x3a:	// astore
					//gen_store32(emitter,stack,&M_Var_Opnd(frame,index),stack.pop());
					break;
				case 0x37:	// lstore
				case 0x39:	// dstore
					//stack.pop64(src_lo,src_hi);
					//gen_store32(emitter,stack,&M_Var_Opnd(frame,index+1),src_hi);
					//gen_store32(emitter,stack,&M_Var_Opnd(frame,index),src_lo);
					break;
				case 0xa9:
					assert(0);
					break;
				} // switch
			}
			break;
		case 0xc5: // multianewarray
            {
			    index = (bc[0] << 8) + bc[1];
                Class *c = class_resolve_class(java_class, index);
                assert(c);
			    bc += 2;
			    int dimensions = *bc++;
                bufptr += sprintf(bufptr, "multianewarray [%d] #%d <Class %s>",
                    dimensions, index, c->name->bytes);
            }
            break;
			//
			// ifnull,ifnonnull
			//
		case 0xc6:	// ifnull
            //bufptr += sprintf(bufptr, "ifnull %d", target_bc_index);
		case 0xc7:	// ifnonnull
		{
			int branch_offset = (*(char*)bc << 8) + bc[1];
			unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
            bufptr += sprintf(bufptr,
                "if%snull %d",
                bytecode == 0xc7 ? "non" : "",
                target_bc_index);
			bc += 2;
			break;
		}
		case 0xc8:						// goto_w
		{
			int branch_offset = ((bc[0]<<24) + (bc[1]<<16) + (bc[2]<<8) + bc[3]);
			unsigned target_bc_index = (curr_bc + branch_offset) - first_bc;
			bc += 4;
            bufptr += sprintf(bufptr, "goto_w %d", target_bc_index);
			break;
		}
		default:
            assert(0);
			break;
		} // switch


        //cout << "Processed " << (unsigned)(bc - this_bc) << " bytes. " << endl;
        assert(this_bc != bc);


	} // while

    *bc_ip += (bc - this_bc);
    return bufptr;
}
