# *************************
#  OF Tree for MacOS X
# *************************

#
# **************** NODE device-tree ***************
#
{
    (name device-tree )
    (full_name / )
    (type bootrom )
    (mol_phandle 0xFF83A248 )
    (property pci-OF-bus-map     <word>
        0x000000ff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff 
        0xffffffff 0xffffffff 0xffffffff 0xffffffff  )
    (property clock-frequency    <word> 	0x03F7EC51 )
    (property #size-cells        <word> 	0x00000001 )
    (property #address-cells     <word> 	0x00000001 )
    (property system-id          <str>  	"0000000000000" )
    (property device_type        <str>  	"bootrom" )
    (property copyright          <str>  	
        "Copyright 1983-1999 Apple Computer, Inc. All Rights Reserved" )
    (property name               <str>  	"device-tree" )
    (property color-code <byte> 
        0xFF 0x06  )
    (property customer-sw-config <str>  	"           " )
    (property serial-number <byte> 
        0x48 0x5A 0x53 0x4D 0x37 0x37 0x31 0x36 0x53 0x2F 0x41 0x00 
        0x00 0x55 0x56 0x30 0x30 0x37 0x34 0x50 0x41 0x00 0x00 0x00 
        0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
        0x00 0x00 0x00 0x00 0x00 0x00 0x00  )
    (property compatible         <str>  	"AAPL,MOL", "MacRISC", "Power Macintosh" )
    (property model              <str>  	"AAPL,MOL" )
    
    #
    # **************** NODE cpus ***************
    #
    {
        (name cpus )
        (full_name /cpus )
        (mol_phandle 0xFF83B2F0 )
        (property #size-cells        <word> 	0x00000000 )
        (property #address-cells     <word> 	0x00000001 )
        (property name               <str>  	"cpus" )
        
        #
        # **************** NODE PowerPC,750 ***************
        #
        {
            (name PowerPC,750 )
            (full_name /cpus/PowerPC,750@0 )
            (type cpu )
            (mol_phandle 0xFF83B520 )
            (property translations       <word>
                0x00000000 0x00003000 0x00000000 0x00000010 
                0xfff06000 0x00002000 0xfff06000 0x00000028  )
            (property available          <word>
                0x00003000 0x7fffd000 0xd0000000 0x20000000  )
            (property existing           <word>
                0x00000000 0x80000000 0x80000000 0x80000000  )
            (property l2cr               <word> 	0xAB000010 )
            (property l2-cache           <word> 	0xFF83B880 )
            (property flush-on-lock      <word>
                 )
            (property performance-monitor <word>
                 )
            (property graphics           <word>
                 )
            (property d-cache-block-size <word> 	0x00000020 )
            (property i-cache-block-size <word> 	0x00000020 )
            (property i-cache-sets       <word> 	0x00000080 )
            (property d-cache-sets       <word> 	0x00000080 )
            (property i-cache-size       <word> 	0x00008000 )
            (property d-cache-size       <word> 	0x00008000 )
            (property tlb-size           <word> 	0x00000080 )
            (property tlb-sets           <word> 	0x00000040 )
            (property reservation-granule-size <word> 	0x00000020 )
            (property timebase-frequency <word> 	0x00FDFB14 )
            (property bus-frequency      <word> 	0x03F7EC51 )
            (property clock-frequency    <word> 	0x15DAE3A7 )
            (property state              <str>  	"running" )
            (property cpu-version        <word> 	0x00088300 )
            (property reg                <word> 	0x00000000 )
            (property device_type        <str>  	"cpu" )
            (property name <byte> 
                0x50 0x6F 0x77 0x65 0x72 0x50 0x43 0x2C 0x37 0x35 0x30 0x00 
                0x00  )
            
            #
            # **************** NODE l2-cache ***************
            #
            {
                (name l2-cache )
                (full_name /cpus/PowerPC,750 )
                (type cache )
                (mol_phandle 0xFF83B880 )
                (property clock-frequency    <word> 	0x08BDF4A9 )
                (property cache-unified      <word>
                     )
                (property d-cache-line-size  <word> 	0x00000040 )
                (property i-cache-line-size  <word> 	0x00000040 )
                (property d-cache-sets       <word> 	0x00001000 )
                (property i-cache-sets       <word> 	0x00001000 )
                (property d-cache-size       <word> 	0x00080000 )
                (property i-cache-size       <word> 	0x00080000 )
                (property device_type        <str>  	"cache" )
                (property name               <str>  	"l2-cache" )
            }
        }
    }
    #
    # **************** NODE chosen ***************
    #
    {
        (name chosen )
        (full_name /chosen )
        (mol_phandle 0xFF83C3A0 )
        (property interrupt-controller <word> 	0xFF899080 )
        (property cpu                <word> 	0xFF9DD640 )
        (property bootargs           <str>  	"root=/dev/hda11 " )
        (property bootpath           <str>  	
            "/pci@f2000000/mac-io@17/ata-4@1f000/disk@0:10,yaboot" )
        (property pmu                <word> 	0xFF9CF280 )
        (property nvram              <word> 	0xFF9CF400 )
        (property mmu                <word> 	0xFF9DD640 )
        (property memory             <word> 	0xFF9DD700 )
        (property stdout             <word> 	0xFF9CE5C0 )
        (property stdin              <word> 	0xFF9CEC00 )
        (property name               <str>  	"chosen" )
    }
    #
    # **************** NODE memory ***************
    #
    {
        (name memory )
        (full_name /memory@0 )
        (type memory )
        (mol_phandle 0xFF83C530 )
        (addrs
            (0x00000000 0x00000000 0x04000000 )
            (0x00000000 0x04000000 0x08000000 )
        )
        (property dimm-speeds        <str>  	"", "PC100-322S" )
        (property dimm-types <byte> 
            0x53 0x44 0x52 0x41 0x4D 0x00 0x00  )
        (property dimm-info <byte> 
            0x80 0x00 0x04 0x0C 0x09 0x04 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x94 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x96 0x00 0x95 0x97 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x80 0x08 0x04 
            0x0C 0x0A 0x01 0x40 0x00 0x01 0xA0 0x60 0x00 0x80 0x08 0x00 
            0x01 0x8F 0x04 0x04 0x01 0x01 0x00 0x0F 0x00 0x00 0x00 0x00 
            0x14 0x14 0x14 0x32 0x20 0x20 0x10 0x20 0x10 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x12 
            0x15 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 
            0x00 0x00 0x00 0x64 0xE6  )
        (property available          <word>
            0x00003000 0x001fd000 0x00220000 0x000e0000 
            0x00400000 0x00c00000 0x01400000 0x0aa00000  )
        (property slot-names <byte> 
            0x00 0x00 0x00 0x03 0x44 0x49 0x4D 0x4D 0x30 0x2F 0x42 0x55 
            0x49 0x4C 0x54 0x2D 0x49 0x4E 0x00 0x44 0x49 0x4D 0x4D 0x31 
            0x2F 0x4A 0x31 0x32 0x00  )
        (property reg                <word>
            0x00000000 0x04000000 0x04000000 0x08000000  )
        (property device_type        <str>  	"memory" )
        (property name               <str>  	"memory" )
    }
    #
    # **************** NODE openprom ***************
    #
    {
        (name openprom )
        (full_name /openprom )
        (type BootROM )
        (mol_phandle 0xFF83C748 )
        (property boot-syntax        <word> 	0x00000001 )
        (property supports-bootinfo  <word>
             )
        (property relative-addressing <word>
             )
        (property model              <str>  	"OpenFirmware 3" )
        (property device_type        <str>  	"BootROM" )
        (property name               <str>  	"openprom" )
        
        #
        # **************** NODE client-services ***************
        #
        {
            (name client-services )
            (full_name /openprom/client-services )
            (mol_phandle 0xFF83C878 )
            (property name               <str>  	"client-services" )
        }
    }
    #
    # **************** NODE options ***************
    #
    {
        (name options )
        (full_name /options )
        (mol_phandle 0xFF83DDA0 )
        (property boot-args          <word>
             )
        (property aapl,pci           <word>
            0x2f6f6666 0x73637265 0x656e2d64 0x6973706c 0x6179ff01 
            0x67707266 0xff01ff81 0x01070101 0xff8104ff 0x012f4066 
            0x32303030 0x3030302f 0x4031372f 0x40663330 0x30ff0162 
            0x6b6c74ff 0x011f07ff 0x81010aff 0x8181ff81 0x03ff012f 
            0x40663030 0x30303030 0x302f4031 0x30ff0141 0x444d53ff 
            0x01ff8101 0x2a2aff81 0x81ff8101 0x8214ff81 0x01ff0100  )
        (property boot-script        <str>  	"" )
        (property default-router-ip  <str>  	"" )
        (property default-subnet-mask <str>  	"" )
        (property default-gateway-ip <str>  	"" )
        (property default-server-ip  <str>  	"" )
        (property default-client-ip  <str>  	"" )
        (property boot-command       <str>  	"mac-boot" )
        (property oem-logo           <str>  	"" )
        (property oem-banner         <str>  	"" )
        (property mouse-device       <str>  	"mouse" )
        (property output-device-1    <str>  	"scca" )
        (property input-device-1     <str>  	"scca" )
        (property output-device      <str>  	"screen" )
        (property input-device       <str>  	"keyboard" )
        (property diag-file          <str>  	",diags" )
        (property diag-device        <str>  	"enet" )
        (property console-screen     <str>  	"" )
        (property boot-screen        <str>  	"" )
        (property boot-file          <str>  	"" )
        (property boot-device        <str>  	
            "/pci@f2000000/mac-io@17/ata-4@1f000/@0:10,\\:tbxi" )
        (property selftest-#megs     <str>  	"0" )
        (property screen-#rows       <str>  	"40" )
        (property screen-#columns    <str>  	"100" )
        (property pci-probe-mask     <str>  	"-1" )
        (property virt-size          <str>  	"-1" )
        (property virt-base          <str>  	"-1" )
        (property load-base          <str>  	"0x800000" )
        (property real-size          <str>  	"-1" )
        (property real-base          <str>  	"-1" )
        (property default-mac-address? <str>  	"false" )
        (property use-generic?       <str>  	"false" )
        (property use-nvramrc?       <str>  	"false" )
        (property oem-logo?          <str>  	"false" )
        (property oem-banner?        <str>  	"false" )
        (property fcode-debug?       <str>  	"false" )
        (property diag-switch?       <str>  	"false" )
        (property auto-boot?         <str>  	"true" )
        (property real-mode?         <str>  	"false" )
        (property little-endian?     <str>  	"false" )
        (property name               <str>  	"options" )
    }

    #
    # **************** MOL nvram ***************
    #
    {
        (name mol-nvram )
        (full_name /mol-nvram )
        (type nvram )
        (mol_phandle 0xFF8932C0 )
        (addrs
            (0x00000000 0xFFF04000 0x00004000 )
        )
        (property #bytes             <word> 	0x00002000 )
        (property reg                <word>
            0xfff04000 0x00004000  )
        (property device_type        <str>  	"mol-nvram" )
        (property name               <str>  	"mol-nvram" )
    }

    #
    # ####################### MOL video ############################
    #
    {
	(name MacOnLinuxVideo )
	(full_name /MacOnLinuxVideo )
	(type mol-display )
	(property device_type  <str> 	"mol-display" )
	(property name <str> 	"MacOnLinuxVideo" )
	(property AAPL,boot-display <str> "" )
    }

    #
    # ####################### MOL keyboard ############################
    #
    {
	(name mol-keyboard )
	(full_name /mol-keyboard )
	(type mol-keyboard )
	(property name <str>	"mol-keyboard" )
	(property type <str>	"mol-keyboard" )
    }
    {
	(name mol-mouse )
	(full_name /mol-mouse )
	(type mol-mouse )
	(property name <str>	"mol-mouse" )
	(property type <str>	"mol-mouse" )
    }

    #
    # ####################### NODE mac-io ##########################
    #  NOTE:
    #  This dummy node is necessary (the kernel panics otherwise)
    {
	(name mac-io )
 	(full_name /mac-io )
	(type mac-io )
        (mol_phandle 0xFF898040 )
	(property assigned-addresses <word>
	     0x8200b810 0x00000000 0x80000000 0x00000000 0x00080000  )
	(property model              <str>  	"AAPL,Keylargo-DUMMY" )
     	(property device_type        <str>  	"mac-io" )
	(property name               <str>  	"mac-io" )
    }

    #
    # ####################### MOL blk device ##########################
    #
    {
	(name mol-blk-device )
	(property name               <str>  	"mol-blk-device" )
    }
}
