package org.biojava.utils.bytecode;

/**
 * Instructions which take a one-byte operand.
 *
 * @author Thomas Down
 * @author Matthew Pocock
 */

class ShortInstruction implements Instruction {
  private final byte opcode;
  private final int val;
  private final int delta;
  
  ShortInstruction(byte opcode, int val, int delta) {
    this.opcode = opcode;
    this.val = val;
    this.delta = delta;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(opcode);
    ctx.writeShort(val);
  }
  
  public int stackDepth() {
    return Math.max(delta, 0);
  }
  
  public int stackDelta() {
    return delta;
  }
}
