/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RPCServletUtils {
    static final int BUFFER_SIZE = 4096;
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ATTACHMENT = "attachment";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_TYPE_APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private static final String GENERIC_FAILURE_MSG = "The call failed on the server; see server log for details";
    private static final String GWT_RPC_CONTENT_TYPE = "text/x-gwt-rpc";
    private static final int UNCOMPRESSED_BYTE_SIZE_LIMIT = 256;

    public static boolean acceptsGzipEncoding(HttpServletRequest request) {
        assert (request != null);
        String acceptEncoding = request.getHeader(ACCEPT_ENCODING);
        if (null == acceptEncoding) {
            return false;
        }
        return acceptEncoding.indexOf(CONTENT_ENCODING_GZIP) != -1;
    }

    public static boolean exceedsUncompressedContentLengthLimit(String content) {
        return content.length() * 2 > 256;
    }

    public static boolean isExpectedException(Method serviceIntfMethod, Throwable cause) {
        assert (serviceIntfMethod != null);
        assert (cause != null);
        Class<?>[] exceptionsThrown = serviceIntfMethod.getExceptionTypes();
        if (exceptionsThrown.length <= 0) {
            return false;
        }
        Class<?> causeType = cause.getClass();
        for (Class<?> exceptionThrown : exceptionsThrown) {
            assert (exceptionThrown != null);
            if (!exceptionThrown.isAssignableFrom(causeType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContent(HttpServletRequest request, String expectedContentType, String expectedCharSet) throws IOException, ServletException {
        if (expectedContentType != null) {
            RPCServletUtils.checkContentTypeIgnoreCase(request, expectedContentType);
        }
        if (expectedCharSet != null) {
            RPCServletUtils.checkCharacterEncodingIgnoreCase(request, expectedCharSet);
        }
        ServletInputStream in = request.getInputStream();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            int byteCount;
            while ((byteCount = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteCount);
            }
            String contentCharSet = expectedCharSet != null ? expectedCharSet : CHARSET_UTF8;
            String string = out.toString(contentCharSet);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String readContentAsGwtRpc(HttpServletRequest request) throws IOException, ServletException {
        return RPCServletUtils.readContent(request, GWT_RPC_CONTENT_TYPE, CHARSET_UTF8);
    }

    @Deprecated
    public static String readContentAsUtf8(HttpServletRequest request) throws IOException, ServletException {
        return RPCServletUtils.readContent(request, null, null);
    }

    @Deprecated
    public static String readContentAsUtf8(HttpServletRequest request, boolean checkHeaders) throws IOException, ServletException {
        return RPCServletUtils.readContent(request, GWT_RPC_CONTENT_TYPE, CHARSET_UTF8);
    }

    public static void setGzipEncodingHeader(HttpServletResponse response) {
        response.setHeader(CONTENT_ENCODING, CONTENT_ENCODING_GZIP);
    }

    public static boolean shouldGzipResponseContent(HttpServletRequest request, String responseContent) {
        return RPCServletUtils.acceptsGzipEncoding(request) && RPCServletUtils.exceedsUncompressedContentLengthLimit(responseContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(ServletContext servletContext, HttpServletResponse response, String responseContent, boolean gzipResponse) throws IOException {
        byte[] responseBytes = responseContent.getBytes(CHARSET_UTF8);
        if (gzipResponse) {
            ByteArrayOutputStream output = null;
            DeflaterOutputStream gzipOutputStream = null;
            IOException caught = null;
            try {
                output = new ByteArrayOutputStream(responseBytes.length);
                gzipOutputStream = new GZIPOutputStream(output);
                gzipOutputStream.write(responseBytes);
                ((GZIPOutputStream)gzipOutputStream).finish();
                gzipOutputStream.flush();
                RPCServletUtils.setGzipEncodingHeader(response);
                responseBytes = output.toByteArray();
            }
            catch (IOException e) {
                caught = e;
            }
            finally {
                if (null != gzipOutputStream) {
                    gzipOutputStream.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            if (caught != null) {
                servletContext.log("Unable to compress response", (Throwable)caught);
                response.sendError(500);
                return;
            }
        }
        response.setContentLength(responseBytes.length);
        response.setContentType(CONTENT_TYPE_APPLICATION_JSON_UTF8);
        response.setStatus(200);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT);
        response.getOutputStream().write(responseBytes);
    }

    public static void writeResponseForUnexpectedFailure(ServletContext servletContext, HttpServletResponse response, Throwable failure) {
        servletContext.log("Exception while dispatching incoming RPC call", failure);
        try {
            response.setContentType("text/plain");
            response.setStatus(500);
            try {
                response.getOutputStream().write(GENERIC_FAILURE_MSG.getBytes(CHARSET_UTF8));
            }
            catch (IllegalStateException e) {
                response.getWriter().write(GENERIC_FAILURE_MSG);
            }
        }
        catch (IOException ex) {
            servletContext.log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
        }
    }

    private static void checkCharacterEncodingIgnoreCase(HttpServletRequest request, String expectedCharSet) throws ServletException {
        boolean encodingOkay = false;
        String characterEncoding = request.getCharacterEncoding();
        if (characterEncoding != null && characterEncoding.toLowerCase().indexOf(expectedCharSet.toLowerCase()) != -1) {
            encodingOkay = true;
        }
        if (!encodingOkay) {
            throw new ServletException("Character Encoding is '" + (characterEncoding == null ? "(null)" : characterEncoding) + "'.  Expected '" + expectedCharSet + "'");
        }
    }

    private static void checkContentTypeIgnoreCase(HttpServletRequest request, String expectedContentType) throws ServletException {
        String contentType = request.getContentType();
        boolean contentTypeIsOkay = false;
        if (contentType != null && (contentType = contentType.toLowerCase()).startsWith(expectedContentType.toLowerCase())) {
            contentTypeIsOkay = true;
        }
        if (!contentTypeIsOkay) {
            throw new ServletException("Content-Type was '" + (contentType == null ? "(null)" : contentType) + "'. Expected '" + expectedContentType + "'.");
        }
    }

    private RPCServletUtils() {
    }
}

