/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class UpRatioItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public UpRatioItem() {
        super("UpRatio", 2, -1, 70, "Peers");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        float value = 0.0f;
        long lDivisor = 0L;
        long lDivident = 0L;
        if (peer != null) {
            lDivisor = peer.getStats().getBytesDone() - peer.getStats().getTotalSent();
            lDivident = peer.getStats().getTotalSent();
            if (lDivisor > 1024L) {
                value = (float)lDivident / (float)lDivisor;
                if (value == 0.0f) {
                    value = -1.0f;
                }
            } else if (lDivident > 0L) {
                value = 3.1536E7f;
            }
        }
        if (!cell.setSortValue((long)(value * 1000.0f)) && cell.isValid()) {
            return;
        }
        String s = lDivisor <= 0L ? "" : (value == 3.1536E7f ? "\u221e:1" : (value == -1.0f ? "1:\u221e" : String.valueOf(DisplayFormatters.formatDecimal(value, 2)) + ":1"));
        cell.setText(s);
    }
}

