/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.SWT.GraphicSWT;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.GraphicSWTImpl;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem1;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem2;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;

public class TableCellImpl
implements TableCellCore {
    private TableRowCore tableRow;
    private Comparable sortValue;
    private BufferedTableItem bufferedTableItem;
    private ArrayList refreshListeners;
    private ArrayList disposeListeners;
    private ArrayList tooltipListeners;
    private TableColumnCore tableColumn;
    private boolean valid;
    private int refreshErrLoopCount;
    private int loopFactor;
    private Object oToolTip;
    private AEMonitor this_mon = new AEMonitor("TableCell");

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn) {
        this(_tableRow, _tableColumn, false);
    }

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn, boolean bSkipFirstColumn) {
        this.tableColumn = _tableColumn;
        this.tableRow = _tableRow;
        this.valid = false;
        this.refreshErrLoopCount = 0;
        this.loopFactor = 0;
        int position = this.tableColumn.getPosition();
        int n = position = position >= 0 && bSkipFirstColumn ? position + 1 : position;
        this.bufferedTableItem = this.tableColumn.getType() != 2 ? new BufferedTableItem((BufferedTableRow)((Object)this.tableRow), position){

            public void refresh() {
                TableCellImpl.this.refresh();
            }

            public void invalidate() {
                TableCellImpl.this.setValid(false);
            }
        } : (COConfigurationManager.getBooleanParameter("GUI_SWT_bAlternateTablePainting") ? new BufferedGraphicTableItem2((BufferedTableRow)((Object)this.tableRow), position){

            public void refresh() {
                TableCellImpl.this.refresh();
            }

            public void invalidate() {
                TableCellImpl.this.setValid(false);
            }
        } : new BufferedGraphicTableItem1((BufferedTableRow)((Object)this.tableRow), position){

            public void refresh() {
                TableCellImpl.this.refresh();
            }

            public void invalidate() {
                TableCellImpl.this.setValid(false);
            }
        });
        this.tableColumn.invokeCellAddedListeners(this);
    }

    private void pluginError(Throwable e) {
        String sPosition = this.bufferedTableItem == null ? "null" : this.bufferedTableItem.getPosition() + " (" + this.bufferedTableItem.getColumnName() + ")";
        LGLogger.log(3, "Table Cell Plugin for Column #" + sPosition + " generated an exception: " + e);
        Debug.printStackTrace(e);
    }

    public Object getDataSource() {
        return this.tableRow.getDataSource(this.tableColumn.getUseCoreDataSource());
    }

    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    public TableRow getTableRow() {
        return this.tableRow;
    }

    public String getTableID() {
        return this.tableRow.getTableID();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean setForeground(Color color) {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.setItemForeground(color);
    }

    public boolean setForeground(int red, int green, int blue) {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.setItemForeground(red, green, blue);
    }

    public boolean setText(String text) {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.setText(text);
    }

    public String getText() {
        if (this.bufferedTableItem == null) {
            return "";
        }
        return this.bufferedTableItem.getText();
    }

    public boolean isShown() {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.isShown();
    }

    public boolean setSortValue(Comparable valueToSort) {
        if (this.sortValue == valueToSort) {
            return false;
        }
        this.sortValue = valueToSort;
        return true;
    }

    public boolean setSortValue(long valueToSort) {
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        this.sortValue = new Long(valueToSort);
        return true;
    }

    public boolean setSortValue(float valueToSort) {
        if (this.sortValue instanceof Float && ((Float)this.sortValue).floatValue() == valueToSort) {
            return false;
        }
        this.sortValue = new Float(valueToSort);
        return true;
    }

    public Comparable getSortValue() {
        if (this.sortValue == null) {
            if (this.bufferedTableItem != null) {
                return this.bufferedTableItem.getText();
            }
            return "";
        }
        return this.sortValue;
    }

    public Point getSize() {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).getSize();
    }

    public int getWidth() {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return -1;
        }
        Point pt = ((BufferedGraphicTableItem)this.bufferedTableItem).getSize();
        if (pt == null) {
            return -1;
        }
        return pt.x;
    }

    public int getHeight() {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return -1;
        }
        Point pt = ((BufferedGraphicTableItem)this.bufferedTableItem).getSize();
        if (pt == null) {
            return -1;
        }
        return pt.y;
    }

    public boolean setGraphic(Image img) {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(img);
    }

    public boolean setGraphic(Graphic img) {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        if (img == null) {
            return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(null);
        }
        if (!(img instanceof GraphicSWT)) {
            return false;
        }
        Image imgSWT = ((GraphicSWT)img).getImage();
        return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(imgSWT);
    }

    public Graphic getGraphic() {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        Image img = ((BufferedGraphicTableItem)this.bufferedTableItem).getGraphic();
        return new GraphicSWTImpl(img);
    }

    public Image getGraphicSWT() {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).getGraphic();
    }

    public void setFillCell(boolean bFillCell) {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)this.bufferedTableItem).fillCell = bFillCell;
    }

    public void setMarginHeight(int height) {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)this.bufferedTableItem).marginHeight = height;
    }

    public void setMarginWidth(int width) {
        if (this.bufferedTableItem == null || !(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)this.bufferedTableItem).marginWidth = width;
    }

    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList();
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList();
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList();
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setValid(boolean _valid) {
        this.valid = _valid;
    }

    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean bDoGraphics) {
        block8: {
            if (this.bufferedTableItem == null || this.refreshErrLoopCount > 2) {
                return;
            }
            int iErrCount = this.tableColumn.getConsecutiveErrCount();
            if (iErrCount > 10) {
                return;
            }
            try {
                int iInterval = this.tableColumn.getRefreshInterval();
                if ((iInterval == -2 || iInterval == -1 && bDoGraphics || iInterval > 0 && this.loopFactor % iInterval == 0 || !this.valid) && this.bufferedTableItem.isShown()) {
                    this.tableColumn.invokeCellRefreshListeners(this);
                    if (this.refreshListeners != null) {
                        int i = 0;
                        while (i < this.refreshListeners.size()) {
                            ((TableCellRefreshListener)this.refreshListeners.get(i)).refresh(this);
                            ++i;
                        }
                    }
                    this.setValid(true);
                }
                ++this.loopFactor;
                this.refreshErrLoopCount = 0;
                if (iErrCount > 0) {
                    this.tableColumn.setConsecutiveErrCount(0);
                }
            }
            catch (Throwable e) {
                ++this.refreshErrLoopCount;
                this.tableColumn.setConsecutiveErrCount(++iErrCount);
                this.pluginError(e);
                if (this.refreshErrLoopCount <= 2) break block8;
                LGLogger.log(3, "TableCell will not be refreshed anymore this session.");
            }
        }
    }

    public void dispose() {
        if (this.disposeListeners != null) {
            try {
                this.tableColumn.invokeCellDisposeListeners(this);
                Iterator iter = this.disposeListeners.iterator();
                while (iter.hasNext()) {
                    TableCellDisposeListener listener = (TableCellDisposeListener)iter.next();
                    listener.dispose(this);
                }
                this.disposeListeners = null;
            }
            catch (Throwable e) {
                this.pluginError(e);
            }
        }
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.dispose();
        }
        this.refreshListeners = null;
        this.bufferedTableItem = null;
        this.tableColumn = null;
        this.tableRow = null;
        this.sortValue = null;
    }

    public void setImage(Image img) {
        if (this.bufferedTableItem == null) {
            return;
        }
        this.bufferedTableItem.setImage(img);
    }

    public boolean needsPainting() {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.needsPainting();
    }

    public void doPaint(GC gc) {
        if (this.bufferedTableItem == null) {
            return;
        }
        this.bufferedTableItem.doPaint(gc);
    }

    public void locationChanged() {
        if (this.bufferedTableItem == null) {
            return;
        }
        this.bufferedTableItem.locationChanged();
    }

    public TableRowCore getTableRowCore() {
        return this.tableRow;
    }

    public int compareTo(Object o) {
        try {
            Comparable ourSortValue = this.getSortValue();
            Comparable otherSortValue = ((TableCellImpl)o).getSortValue();
            if (ourSortValue instanceof String && otherSortValue instanceof String) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(ourSortValue, otherSortValue);
            }
            try {
                return ourSortValue.compareTo(otherSortValue);
            }
            catch (ClassCastException e) {
            }
        }
        catch (Exception e) {
            System.out.println("Could not compare cells");
            Debug.printStackTrace(e);
        }
        return 0;
    }

    public void setToolTip(Object tooltip) {
        this.oToolTip = tooltip;
    }

    public Object getToolTip() {
        return this.oToolTip;
    }

    public void invokeToolTipListeners(int type) {
        this.tableColumn.invokeCellToolTipListeners(this, type);
        if (this.tooltipListeners == null) {
            return;
        }
        if (type == 0) {
            int i = 0;
            while (i < this.tooltipListeners.size()) {
                ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHover(this);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.tooltipListeners.size()) {
                ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHoverComplete(this);
                ++i;
            }
        }
    }
}

