/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.ui.swt.components.graphics.PieUtils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class PeersGraphicView
extends AbstractIView
implements DownloadManagerPeerListener {
    private DownloadManager manager;
    private List peers;
    private AEMonitor peers_mon = new AEMonitor("PeersGraphicView:peers");
    private PeerComparator peerComparator;
    private Composite panel;
    private static final int PEER_SIZE = 15;
    private static final int OWN_SIZE = 75;

    public PeersGraphicView(DownloadManager manager) {
        this.manager = manager;
        this.peers = new ArrayList();
        this.peerComparator = new PeerComparator();
        this.manager.addPeerListener(this);
    }

    public void delete() {
        this.manager.removePeerListener(this);
        super.delete();
    }

    public Composite getComposite() {
        return this.panel;
    }

    public String getData() {
        return "PeersGraphicView.title";
    }

    public void initialize(Composite composite) {
        this.panel = new Canvas(composite, 0);
    }

    public void refresh() {
        PEPeer[] sortedPeers;
        try {
            this.peers_mon.enter();
            ArrayList<PEPeerTransport> connectedPeers = new ArrayList<PEPeerTransport>();
            Iterator iter = this.peers.iterator();
            while (iter.hasNext()) {
                PEPeerTransport peer = (PEPeerTransport)iter.next();
                if (peer.getConnectionState() != 4) continue;
                connectedPeers.add(peer);
            }
            sortedPeers = connectedPeers.toArray(new PEPeer[connectedPeers.size()]);
        }
        finally {
            this.peers_mon.exit();
        }
        if (sortedPeers == null) {
            return;
        }
        Arrays.sort(sortedPeers, this.peerComparator);
        this.render(sortedPeers);
    }

    private void render(PEPeer[] sortedPeers) {
        int r;
        Display display = this.panel.getDisplay();
        Point panelSize = this.panel.getSize();
        Image buffer = new Image((Device)display, panelSize.x, panelSize.y);
        GC gcBuffer = new GC((Drawable)buffer);
        gcBuffer.setBackground(Colors.white);
        gcBuffer.setForeground(Colors.blue);
        gcBuffer.fillRectangle(0, 0, panelSize.x, panelSize.y);
        gcBuffer.setBackground(Colors.blues[2]);
        int nbPeers = sortedPeers.length;
        int x0 = panelSize.x / 2;
        int y0 = panelSize.y / 2;
        int n = r = x0 > y0 ? y0 - 20 : x0 - 20;
        if (r < 10) {
            return;
        }
        int i = 0;
        while (i < nbPeers) {
            int y1;
            int x1;
            PEPeer peer = sortedPeers[i];
            double angle = Math.PI * 2 * (double)i / (double)nbPeers - 1.5707963267948966;
            int x = x0 + (int)((double)r * Math.cos(angle));
            int y = y0 + (int)((double)r * Math.sin(angle));
            int[] triangle = new int[6];
            triangle[0] = x;
            triangle[1] = y;
            if (!peer.isChokedByMe()) {
                gcBuffer.setBackground(Colors.blues[2]);
                x1 = (int)(5.0 * Math.cos(angle + 1.5707963267948966));
                y1 = (int)(5.0 * Math.sin(angle + 1.5707963267948966));
                triangle[0] = x;
                triangle[1] = y;
                triangle[2] = x0;
                triangle[3] = y0;
                triangle[4] = x0 + x1;
                triangle[5] = y0 + y1;
                gcBuffer.fillPolygon(triangle);
            }
            if (!peer.isChokingMe()) {
                gcBuffer.setBackground(Colors.blues[7]);
                x1 = (int)(5.0 * Math.cos(angle + 1.5707963267948966));
                y1 = (int)(5.0 * Math.sin(angle + 1.5707963267948966));
                triangle[0] = x - x1;
                triangle[1] = y - y1;
                triangle[2] = x;
                triangle[3] = y;
                triangle[4] = x0;
                triangle[5] = y0;
                gcBuffer.fillPolygon(triangle);
            }
            PieUtils.drawPie(gcBuffer, x - 7, y - 7, 15, 15, peer.getPercentDoneInThousandNotation() / 10);
            ++i;
        }
        PieUtils.drawPie(gcBuffer, x0 - 37, y0 - 37, 75, 75, this.manager.getStats().getCompleted() / 10);
        gcBuffer.dispose();
        GC gcPanel = new GC((Drawable)this.panel);
        gcPanel.drawImage(buffer, 0, 0);
        gcPanel.dispose();
        buffer.dispose();
    }

    public void peerManagerAdded(PEPeerManager manager) {
    }

    public void peerManagerRemoved(PEPeerManager manager) {
    }

    public void pieceAdded(PEPiece piece) {
    }

    public void pieceRemoved(PEPiece piece) {
    }

    public void peerAdded(PEPeer peer) {
        try {
            this.peers_mon.enter();
            this.peers.add(peer);
        }
        finally {
            this.peers_mon.exit();
        }
    }

    public void peerRemoved(PEPeer peer) {
        try {
            this.peers_mon.enter();
            this.peers.remove(peer);
        }
        finally {
            this.peers_mon.exit();
        }
    }

    class PeerComparator
    implements Comparator {
        PeerComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            boolean interested1;
            boolean interesting1;
            PEPeer peer0 = (PEPeer)arg0;
            PEPeer peer1 = (PEPeer)arg1;
            boolean interesting0 = peer0.isInterestedInMe();
            int result = (interesting0 ? 1 : -1) - ((interesting1 = peer1.isInterestedInMe()) ? 1 : -1);
            if (result != 0) {
                return result;
            }
            boolean interested0 = peer0.isInterestingToMe();
            result = (interested0 ? 1 : -1) - ((interested1 = peer1.isInterestingToMe()) ? 1 : -1);
            if (result != 0) {
                return result;
            }
            int percent0 = peer0.getPercentDoneInThousandNotation();
            int percent1 = peer1.getPercentDoneInThousandNotation();
            return interested0 ? percent0 - percent1 : percent1 - percent0;
        }
    }
}

