/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class GeneralView
extends AbstractIView
implements ParameterListener {
    private Display display;
    private DownloadManager manager;
    boolean[] pieces;
    int loopFactor;
    Composite genComposite;
    Group gFile;
    Canvas piecesImage;
    Image pImage;
    BufferedLabel piecesPercent;
    Canvas availabilityImage;
    Image aImage;
    BufferedLabel availabilityPercent;
    Group gTransfer;
    BufferedLabel timeElapsed;
    BufferedLabel timeRemaining;
    BufferedLabel download;
    BufferedLabel downloadSpeed;
    Text maxDLSpeed;
    BufferedLabel upload;
    BufferedLabel uploadSpeed;
    Text maxULSpeed;
    Text maxUploads;
    BufferedLabel totalSpeed;
    BufferedLabel seeds;
    BufferedLabel peers;
    Group gInfo;
    BufferedLabel fileName;
    BufferedLabel fileSize;
    BufferedLabel saveIn;
    BufferedLabel hash;
    BufferedLabel tracker;
    BufferedLabel trackerUpdateIn;
    Menu menuTracker;
    MenuItem itemSelect;
    BufferedLabel trackerUrlValue;
    BufferedLabel pieceNumber;
    BufferedLabel pieceSize;
    BufferedLabel comment;
    BufferedLabel creation_date;
    BufferedLabel hashFails;
    BufferedLabel shareRatio;
    Button updateButton;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");

    public GeneralView(DownloadManager _manager) {
        this.manager = _manager;
        this.pieces = new boolean[this.manager.getNbPieces()];
    }

    public void initialize(Composite composite) {
        this.display = composite.getDisplay();
        this.genComposite = new Canvas(composite, 0);
        GridLayout genLayout = new GridLayout();
        genLayout.marginHeight = 0;
        genLayout.marginWidth = 2;
        genLayout.numColumns = 1;
        this.genComposite.setLayout((Layout)genLayout);
        this.gFile = new Group(this.genComposite, 8);
        GridData gridData = new GridData(768);
        this.gFile.setLayoutData((Object)gridData);
        GridLayout fileLayout = new GridLayout();
        fileLayout.marginHeight = 2;
        fileLayout.numColumns = 3;
        this.gFile.setLayout((Layout)fileLayout);
        Label piecesInfo = new Label((Composite)this.gFile, 16384);
        Messages.setLanguageText((Widget)piecesInfo, "GeneralView.section.downloaded");
        gridData = new GridData(32);
        piecesInfo.setLayoutData((Object)gridData);
        this.piecesImage = new Canvas((Composite)this.gFile, 0);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.piecesImage.setLayoutData((Object)gridData);
        this.piecesPercent = new BufferedLabel((Composite)this.gFile, 131072);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.piecesPercent.setLayoutData(gridData);
        Label availabilityInfo = new Label((Composite)this.gFile, 16384);
        Messages.setLanguageText((Widget)availabilityInfo, "GeneralView.section.availability");
        gridData = new GridData(32);
        availabilityInfo.setLayoutData((Object)gridData);
        this.availabilityImage = new Canvas((Composite)this.gFile, 0);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.availabilityImage.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.availabilityImage, "GeneralView.label.status.pieces_available.tooltip");
        this.availabilityPercent = new BufferedLabel((Composite)this.gFile, 131072);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.availabilityPercent.setLayoutData(gridData);
        Messages.setLanguageText(this.availabilityPercent, "GeneralView.label.status.pieces_available.tooltip");
        this.gTransfer = new Group(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gTransfer, "GeneralView.section.transfer");
        gridData = new GridData(768);
        this.gTransfer.setLayoutData((Object)gridData);
        GridLayout layoutTransfer = new GridLayout();
        layoutTransfer.numColumns = 6;
        this.gTransfer.setLayout((Layout)layoutTransfer);
        Label label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.timeelapsed");
        this.timeElapsed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.timeElapsed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.remaining");
        this.timeRemaining = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.timeRemaining.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.shareRatio");
        this.shareRatio = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.shareRatio.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloaded");
        this.download = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.download.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloadspeed");
        this.downloadSpeed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.downloadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hashfails");
        this.hashFails = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.hashFails.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploaded");
        this.upload = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.upload.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploadspeed");
        this.uploadSpeed = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.uploadSpeed.setLayoutData(gridData);
        Composite culdl = new Composite((Composite)this.gTransfer, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        culdl.setLayoutData((Object)gridData);
        GridLayout layoutInfo = new GridLayout();
        layoutInfo.numColumns = 4;
        layoutInfo.horizontalSpacing = 3;
        layoutInfo.marginHeight = 0;
        layoutInfo.marginWidth = 0;
        culdl.setLayout((Layout)layoutInfo);
        label = new Label(culdl, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.maxuploads");
        this.maxUploads = new Text(culdl, 2048);
        gridData = new GridData();
        gridData.widthHint = Constants.isLinux ? 40 : 35;
        this.maxUploads.setLayoutData((Object)gridData);
        this.maxUploads.setText(String.valueOf(this.manager.getStats().getMaxUploads()));
        this.maxUploads.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.maxUploads.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int value = Integer.parseInt(GeneralView.this.maxUploads.getText());
                    if (value < 2) {
                        value = 2;
                    }
                    GeneralView.this.manager.getStats().setMaxUploads(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.maxUploads.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int value = Integer.parseInt(GeneralView.this.maxUploads.getText());
                    if (value < 2) {
                        GeneralView.this.maxUploads.setText("2");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        label = new Label(culdl, 16384);
        label.setText(String.valueOf(MessageText.getString("GeneralView.label.maxuploadspeed")) + " " + DisplayFormatters.getRateUnit(1) + ":");
        Messages.setLanguageText((Widget)label, "GeneralView.label.maxuploadspeed.tooltip", true);
        this.maxULSpeed = new Text(culdl, 2048);
        gridData = new GridData();
        gridData.widthHint = Constants.isLinux ? 40 : 35;
        this.maxULSpeed.setLayoutData((Object)gridData);
        this.maxULSpeed.setText(String.valueOf(this.manager.getStats().getUploadRateLimitBytesPerSecond() / 1024));
        this.maxULSpeed.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        Listener maxULSpeedListener = new Listener(){

            public void handleEvent(Event event) {
                try {
                    int value = Integer.parseInt(GeneralView.this.maxULSpeed.getText());
                    GeneralView.this.manager.getStats().setUploadRateLimitBytesPerSecond(value * 1024);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.maxULSpeed.addListener(24, maxULSpeedListener);
        this.maxULSpeed.addListener(16, maxULSpeedListener);
        label = new Label(culdl, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalspeed");
        this.totalSpeed = new BufferedLabel(culdl, 16384);
        gridData = new GridData();
        gridData.widthHint = Constants.isLinux ? 70 : 65;
        this.totalSpeed.setLayoutData(gridData);
        label = new Label(culdl, 16384);
        label.setText(String.valueOf(MessageText.getString("GeneralView.label.maxdownloadspeed")) + " " + DisplayFormatters.getRateUnit(1) + ":");
        Messages.setLanguageText((Widget)label, "GeneralView.label.maxdownloadspeed.tooltip", true);
        this.maxDLSpeed = new Text(culdl, 2048);
        gridData = new GridData();
        gridData.widthHint = Constants.isLinux ? 40 : 35;
        this.maxDLSpeed.setLayoutData((Object)gridData);
        this.maxDLSpeed.setText(String.valueOf(this.manager.getStats().getMaxDownloadKBSpeed()));
        this.maxDLSpeed.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        Listener maxDLSpeedListener = new Listener(){

            public void handleEvent(Event event) {
                try {
                    int value = Integer.parseInt(GeneralView.this.maxDLSpeed.getText());
                    GeneralView.this.manager.getStats().setMaxDownloadKBSpeed(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.maxDLSpeed.addListener(24, maxDLSpeedListener);
        this.maxDLSpeed.addListener(16, maxDLSpeedListener);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.seeds");
        this.seeds = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.seeds.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.peers");
        this.peers = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.peers.setLayoutData(gridData);
        this.gInfo = new Group(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gInfo, "GeneralView.section.info");
        gridData = new GridData(1808);
        this.gInfo.setLayoutData((Object)gridData);
        layoutInfo = new GridLayout();
        layoutInfo.numColumns = 4;
        this.gInfo.setLayout((Layout)layoutInfo);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.filename");
        this.fileName = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.fileName.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalsize");
        this.fileSize = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.fileSize.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.savein");
        this.saveIn = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.saveIn.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hash");
        this.hash = new BufferedLabel((Composite)this.gInfo, 16384);
        Messages.setLanguageText(this.hash, "GeneralView.label.hash.tooltip", true);
        gridData = new GridData(768);
        this.hash.setLayoutData(gridData);
        this.hash.setCursor(Cursors.handCursor);
        this.hash.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.hash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.numberofpieces");
        this.pieceNumber = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.pieceNumber.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.size");
        this.pieceSize = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.pieceSize.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.trackerurl");
        label.setCursor(Cursors.handCursor);
        label.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String announce = GeneralView.this.trackerUrlValue.getText();
                if (announce != null && announce.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{announce}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String announce = GeneralView.this.trackerUrlValue.getText();
                if (announce != null && announce.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{announce}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.menuTracker = new Menu((Decorations)this.genComposite.getShell(), 8);
        this.itemSelect = new MenuItem(this.menuTracker, 64);
        Messages.setLanguageText((Widget)this.itemSelect, "GeneralView.menu.selectTracker");
        MenuItem itemEdit = new MenuItem(this.menuTracker, 0);
        Messages.setLanguageText((Widget)itemEdit, "MyTorrentsView.menu.editTracker");
        itemEdit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TOTorrent torrent = GeneralView.this.manager.getTorrent();
                List group = TorrentUtils.announceGroupsToList(torrent);
                new MultiTrackerEditor(null, group, new TrackerEditorListener(this, torrent){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ TOTorrent val$torrent;
                    {
                        this.this$1 = var1_1;
                        this.val$torrent = tOTorrent;
                    }

                    public void trackersChanged(String str, String str2, List _group) {
                        TorrentUtils.listToAnnounceGroups(_group, this.val$torrent);
                        try {
                            TorrentUtils.writeToFile(this.val$torrent);
                        }
                        catch (Throwable e2) {
                            Debug.printStackTrace(e2);
                        }
                        TRTrackerClient tc = GeneralView.access$0(11.access$0(this.this$1)).getTrackerClient();
                        if (tc != null) {
                            tc.resetTrackerUrl(true);
                        }
                    }
                }, true);
            }

            static /* synthetic */ GeneralView access$0(11 var0) {
                return var0.GeneralView.this;
            }
        });
        final Listener menuListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget instanceof MenuItem) {
                    String text = ((MenuItem)e.widget).getText();
                    TOTorrent torrent = GeneralView.this.manager.getTorrent();
                    TorrentUtils.announceGroupsSetFirst(torrent, text);
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (TOTorrentException f) {
                        Debug.printStackTrace(f);
                    }
                    TRTrackerClient tc = GeneralView.this.manager.getTrackerClient();
                    if (tc != null) {
                        tc.resetTrackerUrl(false);
                    }
                }
            }
        };
        this.menuTracker.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Menu menuSelect = GeneralView.this.itemSelect.getMenu();
                if (menuSelect != null && !menuSelect.isDisposed()) {
                    menuSelect.dispose();
                }
                if (GeneralView.this.manager == null || GeneralView.this.genComposite == null || GeneralView.this.genComposite.isDisposed()) {
                    return;
                }
                List groups = TorrentUtils.announceGroupsToList(GeneralView.this.manager.getTorrent());
                menuSelect = new Menu((Decorations)GeneralView.this.genComposite.getShell(), 4);
                GeneralView.this.itemSelect.setMenu(menuSelect);
                Iterator iterGroups = groups.iterator();
                while (iterGroups.hasNext()) {
                    List trackers = (List)iterGroups.next();
                    MenuItem menuItem = new MenuItem(menuSelect, 64);
                    Messages.setLanguageText((Widget)menuItem, "wizard.multitracker.group");
                    Menu menu = new Menu((Decorations)GeneralView.this.genComposite.getShell(), 4);
                    menuItem.setMenu(menu);
                    Iterator iterTrackers = trackers.iterator();
                    while (iterTrackers.hasNext()) {
                        String url = (String)iterTrackers.next();
                        MenuItem menuItemTracker = new MenuItem(menu, 64);
                        menuItemTracker.setText(url);
                        menuItemTracker.addListener(13, menuListener);
                    }
                }
            }
        });
        this.trackerUrlValue = new BufferedLabel((Composite)this.gInfo, 16384);
        this.trackerUrlValue.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                if (event.button == 1) {
                    String url = GeneralView.this.trackerUrlValue.getText();
                    if (url.startsWith("http://") || url.startsWith("https://")) {
                        int pos = -1;
                        pos = url.indexOf("/announce");
                        if (pos != -1) {
                            url = url.substring(0, pos);
                        }
                        Program.launch((String)url);
                    }
                } else if (event.button == 3) {
                    GeneralView.this.menuTracker.setVisible(true);
                }
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.creationdate");
        this.creation_date = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.creation_date.setLayoutData(gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.trackerUrlValue.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.tracker");
        this.tracker = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.tracker.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.updatein");
        this.trackerUpdateIn = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.trackerUpdateIn.setLayoutData(gridData);
        this.updateButton = new Button((Composite)this.gInfo, 8);
        Messages.setLanguageText((Widget)this.updateButton, "GeneralView.label.trackerurlupdate");
        gridData = new GridData(64);
        this.updateButton.setLayoutData((Object)gridData);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GeneralView.this.manager.checkTracker();
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        label = new Label((Composite)this.gInfo, 16384);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "GeneralView.label.comment");
        this.comment = new BufferedLabel((Composite)this.gInfo, 16448);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.comment.setLayoutData(gridData);
        this.piecesImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (e.count == 0 && e.width > 0 && e.height > 0) {
                    GeneralView.this.updatePiecesInfo(true);
                }
            }
        });
        this.availabilityImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (e.count == 0 && e.width > 0 && e.height > 0) {
                    GeneralView.this.updateAvailability();
                }
            }
        });
        if (Constants.isOSX) {
            Shell shell = MainWindow.getWindow().getShell();
            Point size = shell.getSize();
            shell.setSize(size.x - 1, size.y - 1);
            shell.setSize(size);
        }
        this.genComposite.layout();
        COConfigurationManager.addParameterListener("Graphics Update", this);
    }

    public Composite getComposite() {
        return this.genComposite;
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        ++this.loopFactor;
        if (this.loopFactor % this.graphicsUpdate == 0) {
            this.updateAvailability();
            this.updatePiecesInfo(false);
        }
        DiskManager dm = this.manager.getDiskManager();
        this.setTime(this.manager.getStats().getElapsedTime(), String.valueOf(DisplayFormatters.formatETA(this.manager.getStats().getETA())) + (dm != null ? " " + DisplayFormatters.formatByteCountToKiBEtc(dm.getRemaining()) : ""));
        TRTrackerScraperResponse hd = this.manager.getTrackerScrapeResponse();
        String seeds_str = String.valueOf(this.manager.getNbSeeds()) + " " + MessageText.getString("GeneralView.label.connected");
        String peers_str = String.valueOf(this.manager.getNbPeers()) + " " + MessageText.getString("GeneralView.label.connected");
        if (hd != null && hd.isValid()) {
            seeds_str = String.valueOf(seeds_str) + " (" + hd.getSeeds() + " " + MessageText.getString("GeneralView.label.in_swarm") + ")";
            peers_str = String.valueOf(peers_str) + " (" + hd.getPeers() + " " + MessageText.getString("GeneralView.label.in_swarm") + ")";
        }
        String _shareRatio = "";
        int sr = this.manager.getStats().getShareRatio();
        if (sr == -1) {
            _shareRatio = "\u221e";
        }
        if (sr > 0) {
            String partial = "" + sr % 1000;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            _shareRatio = String.valueOf(sr / 1000) + "." + partial;
        }
        DownloadManagerStats stats = this.manager.getStats();
        this.setStats(DisplayFormatters.formatDownloaded(stats), DisplayFormatters.formatByteCountToKiBEtc(stats.getUploaded()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getDownloadAverage()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getUploadAverage()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats.getTotalAverage()), "" + this.manager.getStats().getMaxDownloadKBSpeed(), "" + this.manager.getStats().getUploadRateLimitBytesPerSecond() / 1024, seeds_str, peers_str, DisplayFormatters.formatHashFails(this.manager), _shareRatio);
        this.setTracker(this.manager);
        TOTorrent torrent = this.manager.getTorrent();
        this.setInfos(this.manager.getDisplayName(), torrent == null ? null : LocaleUtil.getSingleton().getCurrentTorrentEncoding(torrent), DisplayFormatters.formatByteCountToKiBEtc(this.manager.getSize()), this.manager.getTorrentSaveDirAndFile(), ByteFormatter.nicePrintTorrentHash(torrent), this.manager.getNbPieces(), this.manager.getPieceLength(), this.manager.getTorrentComment(), DisplayFormatters.formatDate(this.manager.getTorrentCreationDate() * 1000L));
        if (this.loopFactor == 2) {
            this.getComposite().layout(true);
        }
    }

    public void delete() {
        if (this.aImage != null) {
            this.aImage.dispose();
        }
        this.aImage = null;
        if (this.pImage != null) {
            this.pImage.dispose();
        }
        this.pImage = null;
        Utils.disposeComposite(this.genComposite);
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    public String getData() {
        return "GeneralView.title.short";
    }

    public String getFullTitle() {
        return MessageText.getString("GeneralView.title.full");
    }

    public void updateAvailability() {
        try {
            int[] available;
            this.this_mon.enter();
            PEPeerManager pm = this.manager.getPeerManager();
            if (this.manager.getPeerManager() == null) {
                if (this.availabilityPercent.getText() != "") {
                    this.availabilityPercent.setText("");
                }
                available = new int[this.manager.getNbPieces()];
            } else {
                available = pm.getAvailability();
            }
            if (this.display == null || this.display.isDisposed()) {
                this.this_mon.exit();
                return;
            }
            if (this.availabilityImage == null || this.availabilityImage.isDisposed()) {
                this.this_mon.exit();
                return;
            }
            Rectangle bounds = this.availabilityImage.getClientArea();
            GC gc = new GC((Drawable)this.availabilityImage);
            if (this.aImage != null && !this.aImage.isDisposed()) {
                this.aImage.dispose();
            }
            this.aImage = new Image((Device)this.display, bounds.width, bounds.height);
            GC gcImage = new GC((Drawable)this.aImage);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            int allMin = 0;
            int allMax = 0;
            int total = 0;
            String sTotal = "000";
            if (available != null) {
                int xMax = bounds.width - 2;
                int yMax = bounds.height - 2;
                if (xMax < 10 || yMax < 5) {
                    this.this_mon.exit();
                    return;
                }
                allMin = available.length == 0 ? 0 : available[0];
                allMax = available.length == 0 ? 0 : available[0];
                int nbPieces = available.length;
                int i = 0;
                while (i < nbPieces) {
                    if (available[i] < allMin) {
                        allMin = available[i];
                    }
                    if (available[i] > allMax) {
                        allMax = available[i];
                    }
                    ++i;
                }
                int maxAboveMin = allMax - allMin;
                if (maxAboveMin == 0) {
                    gcImage.setBackground(Colors.blues[allMin == 0 ? 0 : 9]);
                    gcImage.fillRectangle(1, 1, xMax, yMax);
                } else {
                    int i2 = 0;
                    while (i2 < nbPieces) {
                        if (available[i2] > allMin) {
                            ++total;
                        }
                        ++i2;
                    }
                    total = total * 1000 / nbPieces;
                    sTotal = "" + total;
                    if (total < 10) {
                        sTotal = "0" + sTotal;
                    }
                    if (total < 100) {
                        sTotal = "0" + sTotal;
                    }
                    i2 = 0;
                    while (i2 < xMax) {
                        int index;
                        int a1 = (i2 + 1) * nbPieces / xMax;
                        int a0 = i2 * nbPieces / xMax;
                        if (a1 == a0) {
                            ++a1;
                        }
                        if (a1 > nbPieces) {
                            a1 = nbPieces;
                        }
                        int max = 0;
                        int min = available[a0];
                        int Pi = 1000;
                        int j = a0;
                        while (j < a1) {
                            if (available[j] > max) {
                                max = available[j];
                            }
                            if (available[j] < min) {
                                min = available[j];
                            }
                            Pi *= available[j];
                            Pi /= available[j] + 1;
                            ++j;
                        }
                        int pond = Pi;
                        if (max == 0) {
                            pond = 0;
                        } else {
                            int PiM = 1000;
                            int j2 = a0;
                            while (j2 < a1) {
                                PiM *= max + 1;
                                PiM /= max;
                                ++j2;
                            }
                            pond *= PiM;
                            pond /= 1000;
                            pond *= max - min;
                            pond /= 1000;
                            pond += min;
                        }
                        if (pond <= 0 || allMax == 0) {
                            index = 0;
                        } else {
                            index = (pond - allMin) * 8 / maxAboveMin + 1;
                            if (index > 9) {
                                index = 9;
                            }
                        }
                        gcImage.setBackground(Colors.blues[index]);
                        gcImage.fillRectangle(i2 + 1, 1, 1, yMax);
                        ++i2;
                    }
                }
            }
            gcImage.dispose();
            if (this.availabilityPercent == null || this.availabilityPercent.isDisposed()) {
                gc.dispose();
                this.this_mon.exit();
                return;
            }
            this.availabilityPercent.setText(String.valueOf(allMin) + "." + sTotal);
            gc.drawImage(this.aImage, bounds.x, bounds.y);
            gc.dispose();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void updatePiecesInfo(boolean bForce) {
        try {
            this.this_mon.enter();
            if (this.display == null || this.display.isDisposed()) {
                this.this_mon.exit();
                return;
            }
            if (this.piecesImage == null || this.piecesImage.isDisposed()) {
                this.this_mon.exit();
                return;
            }
            DiskManager dm = this.manager.getDiskManager();
            boolean valid = !bForce;
            boolean[] new_pieces = new boolean[this.manager.getNbPieces()];
            if (dm != null) {
                DiskManagerPiece[] dm_pieces = dm.getPieces();
                int i = 0;
                while (i < this.pieces.length) {
                    new_pieces[i] = dm_pieces[i].getDone();
                    ++i;
                }
            }
            if (this.pieces == null) {
                valid = false;
            } else {
                int i = 0;
                while (i < this.pieces.length) {
                    if (this.pieces[i] != new_pieces[i]) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
            }
            this.pieces = new_pieces;
            if (!valid) {
                Rectangle bounds = this.piecesImage.getClientArea();
                GC gc = new GC((Drawable)this.piecesImage);
                if (this.pImage != null && !this.pImage.isDisposed()) {
                    this.pImage.dispose();
                }
                int xMax = bounds.width - 2;
                int yMax = bounds.height - 2 - 6;
                if (xMax < 10 || yMax < 5) {
                    this.this_mon.exit();
                    return;
                }
                this.pImage = new Image((Device)this.display, bounds.width, bounds.height);
                GC gcImage = new GC((Drawable)this.pImage);
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                gcImage.drawLine(1, 6, xMax, 6);
                int total = 0;
                if (this.pieces != null && this.pieces.length != 0) {
                    int nbPieces = this.pieces.length;
                    int i = 0;
                    while (i < nbPieces) {
                        if (this.pieces[i]) {
                            ++total;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < xMax) {
                        int a1 = (i + 1) * nbPieces / xMax;
                        int a0 = i * nbPieces / xMax;
                        if (a1 == a0) {
                            ++a1;
                        }
                        if (a1 > nbPieces) {
                            a1 = nbPieces;
                        }
                        int nbAvailable = 0;
                        int j = a0;
                        while (j < a1) {
                            if (this.pieces[j]) {
                                ++nbAvailable;
                            }
                            int index = nbAvailable * 9 / (a1 - a0);
                            gcImage.setBackground(Colors.blues[index]);
                            gcImage.fillRectangle(i + 1, 7, 1, yMax);
                            ++j;
                        }
                        ++i;
                    }
                    total = total * 1000 / nbPieces;
                }
                if (dm == null) {
                    total = this.manager.getStats().getDownloadCompleted(true);
                }
                int limit = xMax * total / 1000;
                gcImage.setBackground(Colors.colorProgressBar);
                gcImage.fillRectangle(1, 1, limit, 5);
                if (limit < xMax) {
                    gcImage.setBackground(Colors.blues[0]);
                    gcImage.fillRectangle(limit + 1, 1, xMax - limit, 5);
                }
                gcImage.dispose();
                if (this.piecesPercent != null && !this.piecesPercent.isDisposed()) {
                    this.piecesPercent.setText(String.valueOf(total / 10) + "." + total % 10 + " %");
                }
                if (this.pImage == null || this.pImage.isDisposed()) {
                    gc.dispose();
                    this.this_mon.exit();
                    return;
                }
                gc.drawImage(this.pImage, bounds.x, bounds.y);
                gc.dispose();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setTime(String elapsed, String remaining) {
        this.timeElapsed.setText(elapsed);
        this.timeRemaining.setText(remaining);
    }

    public void setStats(String dl, String ul, String dls, String uls, String ts, String dl_speed, String ul_speed, String s, String p, String hash_fails, String share_ratio) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.download.setText(dl);
        this.downloadSpeed.setText(dls);
        this.upload.setText(ul);
        this.uploadSpeed.setText(uls);
        this.totalSpeed.setText(ts);
        if (!this.maxDLSpeed.getText().equals(dl_speed)) {
            this.maxDLSpeed.setText(dl_speed);
        }
        if (!this.maxULSpeed.getText().equals(ul_speed)) {
            this.maxULSpeed.setText(ul_speed);
        }
        this.seeds.setText(s);
        this.peers.setText(p);
        this.hashFails.setText(hash_fails);
        this.shareRatio.setText(share_ratio);
    }

    public void setTracker(DownloadManager _manager) {
        TOTorrent torrent;
        URL temp;
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        String status = _manager.getTrackerStatus();
        int time = _manager.getTrackerTime();
        TRTrackerClient trackerClient = _manager.getTrackerClient();
        this.tracker.setText(status);
        if (time < 0) {
            this.trackerUpdateIn.setText(MessageText.getString("GeneralView.label.updatein.querying"));
        } else {
            this.trackerUpdateIn.setText(TimeFormatter.formatColon(time));
        }
        String trackerURL = null;
        if (trackerClient != null && (temp = trackerClient.getTrackerUrl()) != null) {
            trackerURL = temp.toString();
        }
        if (trackerURL == null && (torrent = _manager.getTorrent()) != null) {
            trackerURL = torrent.getAnnounceURL().toString();
        }
        if (trackerURL != null) {
            this.trackerUrlValue.setText(trackerURL);
            if (trackerURL.startsWith("http://") || trackerURL.startsWith("https://")) {
                this.trackerUrlValue.setForeground(Colors.blue);
                this.trackerUrlValue.setCursor(Cursors.handCursor);
                Messages.setLanguageText(this.trackerUrlValue, "GeneralView.label.trackerurlopen.tooltip", true);
            } else {
                this.trackerUrlValue.setForeground(null);
                this.trackerUrlValue.setCursor(null);
                Messages.setLanguageText(this.trackerUrlValue, null);
                this.trackerUrlValue.setToolTipText(null);
            }
        }
        boolean update_state = trackerClient != null ? SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L : false;
        if (this.updateButton.getEnabled() != update_state) {
            this.updateButton.setEnabled(update_state);
        }
    }

    public void setInfos(final String _fileName, final String _encoding, final String _fileSize, final String _path, final String _hash, final int _pieceNumber, final String _pieceLength, final String _comment, final String _creation_date) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String lc;
                int http_pos;
                GeneralView.this.fileName.setText(String.valueOf(_fileName) + (_encoding == null ? "" : " [" + _encoding + "]"));
                GeneralView.this.fileSize.setText(_fileSize);
                GeneralView.this.saveIn.setText(_path);
                GeneralView.this.hash.setText(_hash);
                GeneralView.this.pieceNumber.setText("" + _pieceNumber);
                GeneralView.this.pieceSize.setText(_pieceLength);
                String old_comment = GeneralView.this.comment.getText();
                GeneralView.this.comment.setText(_comment);
                if (_comment != null && !old_comment.equals(_comment) && (http_pos = (lc = _comment.toLowerCase()).indexOf("http")) != -1) {
                    GeneralView.this.comment.setCursor(Cursors.handCursor);
                    GeneralView.this.comment.setForeground(Colors.blue);
                    GeneralView.this.comment.addMouseListener((MouseListener)new MouseAdapter(this, http_pos){
                        final /* synthetic */ 19 this$1;
                        private final /* synthetic */ int val$http_pos;
                        {
                            this.this$1 = var1_1;
                            this.val$http_pos = n;
                        }

                        public void mouseUp(MouseEvent event) {
                            if (event.button == 1) {
                                String url = 19.access$0(this.this$1).comment.getText().substring(this.val$http_pos);
                                int i = 0;
                                while (i < url.length()) {
                                    if (Character.isWhitespace(url.charAt(i))) {
                                        url = url.substring(0, i);
                                        break;
                                    }
                                    ++i;
                                }
                                Program.launch((String)url);
                            }
                        }
                    });
                }
                GeneralView.this.creation_date.setText(_creation_date);
            }

            static /* synthetic */ GeneralView access$0(19 var0) {
                return var0.GeneralView.this;
            }
        });
    }

    public void parameterChanged(String parameterName) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }
}

