/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.test;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PrintTransferTypes
extends ByteArrayTransfer {
    private static PrintTransferTypes _instance = new PrintTransferTypes();
    private int[] ids = new int[50000];
    private String[] names = new String[50000];

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas((Composite)shell, 0);
        DropTarget target = new DropTarget((Control)canvas, 31);
        target.setTransfer(new Transfer[]{PrintTransferTypes.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
                String ops = "";
                if ((event.operations & 1) != 0) {
                    ops = String.valueOf(ops) + "Copy;";
                }
                if ((event.operations & 2) != 0) {
                    ops = String.valueOf(ops) + "Move;";
                }
                if ((event.operations & 4) != 0) {
                    ops = String.valueOf(ops) + "Link;";
                }
                System.out.println("Allowed Operations are " + ops);
                TransferData[] data = event.dataTypes;
                int i = 0;
                while (i < data.length) {
                    int id = data[i].type;
                    String name = PrintTransferTypes.getNameFromId(id);
                    System.out.println("Data type is " + id + " " + name);
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 4;
            }

            public void drop(DropTargetEvent event) {
                System.out.println("URL dropped: " + event.data);
                System.out.println("Data type is " + event.currentDataType.type + " " + PrintTransferTypes.getNameFromId(event.currentDataType.type));
            }
        });
        shell.setSize(400, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static PrintTransferTypes getInstance() {
        return _instance;
    }

    PrintTransferTypes() {
        int i = 0;
        while (i < this.ids.length) {
            this.ids[i] = i;
            this.names[i] = PrintTransferTypes.getNameFromId(i);
            ++i;
        }
    }

    public void javaToNative(Object object, TransferData transferData) {
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] buffer = (byte[])super.nativeToJava(transferData);
        if (buffer == null) {
            return null;
        }
        int size = buffer.length;
        byte[] text = new byte[size];
        int j = 0;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] != 0) {
                text[j++] = buffer[i];
            }
            ++i;
        }
        String data = new String(text, 0, j);
        int end = data.indexOf("\n");
        return end >= 0 ? data.substring(0, end) : data;
    }

    protected String[] getTypeNames() {
        return this.names;
    }

    protected int[] getTypeIds() {
        return this.ids;
    }

    static String getNameFromId(int id) {
        switch (id) {
            case 1: {
                return "CF_TEXT";
            }
            case 8: {
                return "CF_DIB";
            }
            case 13: {
                return "CF_UNICODETEXT";
            }
            case 15: {
                return "CF_HDROP";
            }
            case 49158: {
                return "FileName";
            }
            case 49159: {
                return "FileNameW";
            }
            case 49267: {
                return "Shell IDList Array";
            }
            case 49350: {
                return "FileContents";
            }
            case 49351: {
                return "FileGroupDescriptor";
            }
            case 49352: {
                return "FileGroupDescriptorW";
            }
            case 49356: {
                return "HTML Format";
            }
            case 49357: {
                return "Preferred DropEffect";
            }
            case 49361: {
                return "UniformResourceLocator";
            }
            case 49362: {
                return "UniformResourceLocator";
            }
            case 49368: {
                return "UniformResourceLocator";
            }
            case 49429: {
                return "UniformResourceLocatorW";
            }
            case 49458: {
                return "UniformResourceLocatorW";
            }
            case 49569: {
                return "text/html";
            }
            case 49570: {
                return "text/_moz_htmlcontext";
            }
            case 49571: {
                return "text/_moz_htmlinfo";
            }
            case 49624: {
                return "application/x-moz-nativeimage";
            }
        }
        return "*UNKNOWN_TYPE*";
    }
}

