/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.donations;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class DonationWindow2 {
    private Display display;
    private Shell shell;
    private Button radioDonate;
    private Button radioNoDonate;
    private Button radioLater;
    private Button radioAlready;
    private Button ok;
    private String mainText;
    private String footerText;
    int timeToWait;
    OverallStats stats;
    Image workingImage;
    Image background;
    Font mainFont;
    Font smallFont;
    Font mediumFont;
    Animator animator;
    PaintListener listener;
    private static final String donationUrl = "https://www.paypal.com/xclick/business=olivier%40gudy.org&item_name=Azureus&no_note=1&tax=0&currency_code=EUR&lc=US";
    private static final String donationUrlShort = "https://www.paypal.com/xclick/business=olivier%40gudy.org&item_name=Azureus&currency_code=EUR&lc=US";
    private static final int DONATIONS_ASK_AFTER = 168;
    private static final AEMonitor class_mon = new AEMonitor("DonationWindow:class");

    public DonationWindow2(Display display) {
        this.display = display;
        this.stats = StatsFactory.getStats();
        this.mainText = MessageText.getString("DonationWindow.text");
        this.footerText = MessageText.getString("DonationWindow.text.footer");
        this.timeToWait = this.mainText.length() / 29;
    }

    public void show() {
        this.shell = new Shell(67584);
        FormLayout layout = new FormLayout();
        this.shell.setLayout((Layout)layout);
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        this.shell.setText(MessageText.getString("DonationWindow.title"));
        this.shell.setBackground(Colors.white);
        this.background = ImageRepository.getImage("donation");
        Font tempFont = this.shell.getFont();
        FontData[] fontDataMain = tempFont.getFontData();
        boolean isMacLinux = Constants.isOSX || Constants.isLinux;
        int i = 0;
        while (i < fontDataMain.length) {
            if (!isMacLinux) {
                fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 1.4));
            } else {
                fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 1.1));
            }
            fontDataMain[i].setStyle(1);
            ++i;
        }
        this.mainFont = new Font((Device)this.display, fontDataMain);
        tempFont = this.shell.getFont();
        fontDataMain = tempFont.getFontData();
        i = 0;
        while (i < fontDataMain.length) {
            if (!isMacLinux) {
                fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 1.2));
            }
            ++i;
        }
        this.mediumFont = new Font((Device)this.display, fontDataMain);
        tempFont = this.shell.getFont();
        fontDataMain = tempFont.getFontData();
        i = 0;
        while (i < fontDataMain.length) {
            if (isMacLinux) {
                fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 0.75));
            } else {
                fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 0.9));
            }
            ++i;
        }
        this.smallFont = new Font((Device)this.display, fontDataMain);
        this.listener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (DonationWindow2.this.shell == null || DonationWindow2.this.shell.isDisposed()) {
                    return;
                }
                DonationWindow2.this.paint();
            }
        };
        this.shell.addPaintListener(this.listener);
        ImageData data = this.background.getImageData();
        this.shell.setSize(data.width, data.height);
        Utils.centreWindow(this.shell);
        this.addControls();
        this.shell.open();
        this.animator = new Animator();
        this.animator.start();
    }

    private void close() {
        this.animator.dispose();
        this.mainFont.dispose();
        this.mediumFont.dispose();
        this.smallFont.dispose();
        this.workingImage.dispose();
        this.shell.dispose();
    }

    private void paint() {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        if (this.workingImage == null || this.workingImage.isDisposed()) {
            return;
        }
        GC gcShell = new GC((Drawable)this.shell);
        gcShell.drawImage(this.workingImage, 0, 0);
        gcShell.dispose();
    }

    private void enableOk() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (DonationWindow2.this.shell == null || DonationWindow2.this.shell.isDisposed()) {
                    return;
                }
                DonationWindow2.this.ok.setEnabled(true);
            }
        });
    }

    private void addControls() {
        this.ok = new Button((Composite)this.shell, 8);
        this.ok.setEnabled(false);
        Messages.setLanguageText((Widget)this.ok, "DonationWindow.ok");
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment(100, -5);
        formData.width = 100;
        this.ok.setLayoutData((Object)formData);
        this.radioDonate = new Button((Composite)this.shell, 16);
        Messages.setLanguageText((Widget)this.radioDonate, "DonationWindow.options.donate");
        this.radioDonate.setFont(this.mainFont);
        this.radioDonate.setBackground(Colors.white);
        formData = new FormData();
        formData.top = new FormAttachment(65, 0);
        formData.left = new FormAttachment(0, 140);
        formData.right = new FormAttachment(100, -5);
        this.radioDonate.setLayoutData((Object)formData);
        Label textFooter = new Label((Composite)this.shell, 0);
        textFooter.setFont(this.smallFont);
        textFooter.setText(this.footerText);
        textFooter.setForeground(Colors.black);
        textFooter.setBackground(Colors.white);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.radioDonate);
        formData.left = new FormAttachment(0, 140);
        formData.right = new FormAttachment(100, -5);
        textFooter.setLayoutData((Object)formData);
        this.radioNoDonate = new Button((Composite)this.shell, 16);
        Messages.setLanguageText((Widget)this.radioNoDonate, "DonationWindow.options.nodonate");
        this.radioNoDonate.setFont(this.mediumFont);
        this.radioNoDonate.setBackground(Colors.white);
        formData = new FormData();
        formData.top = new FormAttachment((Control)textFooter);
        formData.left = new FormAttachment(0, 140);
        formData.right = new FormAttachment(100, -5);
        this.radioNoDonate.setLayoutData((Object)formData);
        this.radioLater = new Button((Composite)this.shell, 16);
        Messages.setLanguageText((Widget)this.radioLater, "DonationWindow.options.later");
        this.radioLater.setFont(this.mediumFont);
        this.radioLater.setBackground(Colors.white);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.radioNoDonate);
        formData.left = new FormAttachment(0, 140);
        formData.right = new FormAttachment(100, -5);
        this.radioLater.setLayoutData((Object)formData);
        this.radioAlready = new Button((Composite)this.shell, 16);
        Messages.setLanguageText((Widget)this.radioAlready, "DonationWindow.options.already");
        this.radioAlready.setFont(this.mediumFont);
        this.radioAlready.setBackground(Colors.white);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.radioLater);
        formData.left = new FormAttachment(0, 140);
        formData.right = new FormAttachment(100, -5);
        this.radioAlready.setLayoutData((Object)formData);
        Text textForCopy = new Text((Composite)this.shell, 2048);
        textForCopy.setText(donationUrlShort);
        textForCopy.setFont(this.smallFont);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, -7);
        formData.left = new FormAttachment(0, 5);
        textForCopy.setLayoutData((Object)formData);
        this.radioDonate.setSelection(true);
        this.ok.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                DonationWindow2.this.handleChoice();
            }
        });
        Listener keyListener = new Listener(){

            public void handleEvent(Event e) {
                System.out.println(e.character);
                if (e.character == '\u001b' && DonationWindow2.this.ok.getEnabled()) {
                    DonationWindow2.this.close();
                }
            }
        };
        this.shell.addListener(2, keyListener);
        textForCopy.addListener(2, keyListener);
        this.shell.layout();
    }

    private void handleChoice() {
        if (this.radioDonate.getSelection()) {
            Program.launch((String)donationUrl);
        }
        if (this.radioAlready.getSelection()) {
            this.thanks();
            this.stopAsking();
        }
        if (this.radioNoDonate.getSelection()) {
            this.stopAsking();
        }
        if (!this.radioDonate.getSelection()) {
            this.close();
        }
    }

    private void thanks() {
        MessageBox msgThanks = new MessageBox(this.shell, 32);
        msgThanks.setText(MessageText.getString("DonationWindow.thanks.title"));
        msgThanks.setMessage(MessageText.getString("DonationWindow.thanks.text"));
        msgThanks.open();
        COConfigurationManager.setParameter("donations.donated", true);
        COConfigurationManager.save();
    }

    private void stopAsking() {
        COConfigurationManager.setParameter("donations.nextAskTime", -1);
        COConfigurationManager.setParameter("donations.lastVersion", "2.2.0.2");
        COConfigurationManager.save();
    }

    public static void checkForDonationPopup() {
        try {
            class_mon.enter();
            boolean alreadyDonated = COConfigurationManager.getBooleanParameter("donations.donated", false);
            if (alreadyDonated) {
                class_mon.exit();
                return;
            }
            String lastVersionAsked = COConfigurationManager.getStringParameter("donations.lastVersion", "");
            long upTime = StatsFactory.getStats().getTotalUpTime();
            int hours = (int)(upTime / 3600L);
            int nextAsk = (COConfigurationManager.getIntParameter("donations.nextAskTime", 0) + 1) * 168;
            if (nextAsk == 0) {
                if (lastVersionAsked.equals("2.2.0.2")) {
                    class_mon.exit();
                    return;
                }
                COConfigurationManager.setParameter("donations.nextAskTime", hours / 168);
                COConfigurationManager.save();
                class_mon.exit();
                return;
            }
            if (hours < nextAsk) {
                class_mon.exit();
                return;
            }
            COConfigurationManager.setParameter("donations.nextAskTime", hours / 168);
            COConfigurationManager.save();
            final Display display = SWTThread.getInstance().getDisplay();
            if (display != null && !display.isDisposed()) {
                display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        new DonationWindow2(display).show();
                    }
                });
            }
        }
        finally {
            class_mon.exit();
        }
    }

    static /* synthetic */ String access$1(DonationWindow2 donationWindow2) {
        return donationWindow2.mainText;
    }

    private class Animator
    extends AEThread {
        boolean ended;
        boolean drawingDone;
        int nbchars;

        public Animator() {
            super("Donation animator");
            this.ended = false;
            this.nbchars = 0;
        }

        public void runSupport() {
            while (!this.ended) {
                if (DonationWindow2.this.display == null || DonationWindow2.this.display.isDisposed()) {
                    return;
                }
                this.drawingDone = false;
                DonationWindow2.this.display.asyncExec((Runnable)new AERunnable(this){
                    final /* synthetic */ Animator this$1;
                    {
                        this.this$1 = animator;
                    }

                    public void runSupport() {
                        Image tempImage = new Image((Device)DonationWindow2.access$0(Animator.access$0(this.this$1)), Animator.access$0((Animator)this.this$1).background, 0);
                        ++this.this$1.nbchars;
                        if (this.this$1.nbchars <= DonationWindow2.access$1(Animator.access$0(this.this$1)).length()) {
                            String textToSet = DonationWindow2.access$1(Animator.access$0(this.this$1)).substring(0, this.this$1.nbchars);
                            GC tempGC = new GC((Drawable)tempImage);
                            if (Animator.access$0((Animator)this.this$1).mainFont == null || Animator.access$0((Animator)this.this$1).mainFont.isDisposed()) {
                                return;
                            }
                            tempGC.setFont(Animator.access$0((Animator)this.this$1).mainFont);
                            tempGC.drawText(DisplayFormatters.formatByteCountToKiBEtc(Animator.access$0((Animator)this.this$1).stats.getDownloadedBytes()), 80, 14, true);
                            tempGC.drawText(DisplayFormatters.formatByteCountToKiBEtc(Animator.access$0((Animator)this.this$1).stats.getUploadedBytes()), 235, 14, true);
                            tempGC.drawText(String.valueOf(Animator.access$0((Animator)this.this$1).stats.getTotalUpTime() / 3600L) + " " + MessageText.getString("DonationWindow.text.hours"), 465, 14, true);
                            tempGC.drawText(textToSet, 10, 60, true);
                            tempGC.setFont(null);
                            tempGC.drawText(MessageText.getString("DonationWindow.text.downloaded"), 70, 32, true);
                            tempGC.drawText(MessageText.getString("DonationWindow.text.uploaded"), 235, 32, true);
                            tempGC.dispose();
                            Image oldImage = Animator.access$0((Animator)this.this$1).workingImage;
                            Animator.access$0((Animator)this.this$1).workingImage = tempImage;
                            if (oldImage != null && !oldImage.isDisposed()) {
                                oldImage.dispose();
                            }
                            DonationWindow2.access$2(Animator.access$0(this.this$1));
                        } else {
                            this.this$1.ended = true;
                        }
                        this.this$1.drawingDone = true;
                    }
                });
                try {
                    Thread.sleep(30L);
                    while (!this.drawingDone) {
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException e) {
                    this.ended = true;
                }
            }
            DonationWindow2.this.enableOk();
        }

        public void dispose() {
            this.ended = true;
        }

        static /* synthetic */ DonationWindow2 access$0(Animator animator) {
            return animator.DonationWindow2.this;
        }
    }
}

