/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.NatPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class TransferPanel
extends AbstractWizardPanel {
    Label nbMaxActive;
    Label nbMaxDownloads;
    Label nbMaxUploadsPerTorrent;
    private static final int[] upRates;

    static {
        int[] nArray = new int[40];
        nArray[1] = 5;
        nArray[2] = 6;
        nArray[3] = 7;
        nArray[4] = 8;
        nArray[5] = 9;
        nArray[6] = 10;
        nArray[7] = 11;
        nArray[8] = 12;
        nArray[9] = 13;
        nArray[10] = 14;
        nArray[11] = 15;
        nArray[12] = 20;
        nArray[13] = 25;
        nArray[14] = 30;
        nArray[15] = 35;
        nArray[16] = 40;
        nArray[17] = 45;
        nArray[18] = 50;
        nArray[19] = 55;
        nArray[20] = 60;
        nArray[21] = 70;
        nArray[22] = 80;
        nArray[23] = 85;
        nArray[24] = 90;
        nArray[25] = 100;
        nArray[26] = 110;
        nArray[27] = 150;
        nArray[28] = 200;
        nArray[29] = 250;
        nArray[30] = 300;
        nArray[31] = 350;
        nArray[32] = 400;
        nArray[33] = 450;
        nArray[34] = 500;
        nArray[35] = 600;
        nArray[36] = 700;
        nArray[37] = 800;
        nArray[38] = 900;
        nArray[39] = 1000;
        upRates = nArray;
    }

    public TransferPanel(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("configureWizard.transfer.title"));
        this.wizard.setCurrentInfo(MessageText.getString("configureWizard.transfer.hint"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 380;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.message");
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.connection");
        final Combo connections = new Combo(panel, 12);
        int i = 0;
        while (i < 8) {
            connections.add(MessageText.getString("configureWizard.transfer.connection." + i));
            ++i;
        }
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxUpSpeed");
        String[] upsLabels = new String[upRates.length];
        int[] upsValues = new int[upRates.length];
        upsLabels[0] = MessageText.getString("ConfigView.unlimited");
        upsValues[0] = 0;
        int i2 = 1;
        while (i2 < upRates.length) {
            upsLabels[i2] = " " + upRates[i2] + " KB/s";
            upsValues[i2] = 1024 * upRates[i2];
            ++i2;
        }
        final Combo cMaxUpSpeed = new Combo(panel, 12);
        int i3 = 0;
        while (i3 < upRates.length) {
            cMaxUpSpeed.add(upsLabels[i3]);
            ++i3;
        }
        gridData = new GridData();
        gridData.widthHint = 100;
        cMaxUpSpeed.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxActiveTorrents");
        this.nbMaxActive = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.nbMaxActive.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxDownloads");
        this.nbMaxDownloads = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.nbMaxDownloads.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer.maxUploadsPerTorrent");
        this.nbMaxUploadsPerTorrent = new Label(panel, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.nbMaxUploadsPerTorrent.setLayoutData((Object)gridData);
        connections.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index;
                ((ConfigureWizard)((TransferPanel)TransferPanel.this).wizard).upSpeed = index = connections.getSelectionIndex();
                if (index == 0) {
                    cMaxUpSpeed.setEnabled(true);
                } else {
                    int maxUp;
                    cMaxUpSpeed.setEnabled(false);
                    int[] nArray = new int[8];
                    nArray[1] = 5;
                    nArray[2] = 13;
                    nArray[3] = 25;
                    nArray[4] = 40;
                    nArray[5] = 55;
                    nArray[6] = 85;
                    nArray[7] = 110;
                    int[] upSpeeds = nArray;
                    cMaxUpSpeed.select(TransferPanel.this.findIndex(upSpeeds[index], upRates));
                    ((ConfigureWizard)((TransferPanel)TransferPanel.this).wizard).maxUpSpeed = maxUp = upRates[cMaxUpSpeed.getSelectionIndex()];
                    TransferPanel.this.computeAll(maxUp);
                }
            }
        });
        cMaxUpSpeed.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int maxUp;
                ((ConfigureWizard)((TransferPanel)TransferPanel.this).wizard).maxUpSpeed = maxUp = upRates[cMaxUpSpeed.getSelectionIndex()];
                TransferPanel.this.computeAll(maxUp);
            }
        });
        connections.select(((ConfigureWizard)this.wizard).upSpeed);
        cMaxUpSpeed.select(this.findIndex(((ConfigureWizard)this.wizard).maxUpSpeed, upRates));
        cMaxUpSpeed.setEnabled(((ConfigureWizard)this.wizard).upSpeed == 0);
        this.computeAll(((ConfigureWizard)this.wizard).maxUpSpeed);
    }

    public void computeAll(int maxUploadSpeed) {
        if (maxUploadSpeed != 0) {
            int nbMaxActive = (int)(Math.pow(maxUploadSpeed, 0.34) * 0.92);
            int nbMaxUploads = (int)(Math.pow(maxUploadSpeed, 0.25) * 1.68);
            int nbMaxDownloads = nbMaxActive * 4 / 5;
            if (nbMaxDownloads == 0) {
                nbMaxDownloads = 1;
            }
            if (nbMaxUploads > 50) {
                nbMaxUploads = 50;
            }
            ((ConfigureWizard)this.wizard).maxActiveTorrents = nbMaxActive;
            ((ConfigureWizard)this.wizard).maxDownloads = nbMaxDownloads;
            ((ConfigureWizard)this.wizard).nbUploadsPerTorrent = nbMaxUploads;
        } else {
            ((ConfigureWizard)this.wizard).maxActiveTorrents = 0;
            ((ConfigureWizard)this.wizard).maxDownloads = 0;
            ((ConfigureWizard)this.wizard).nbUploadsPerTorrent = 4;
        }
        this.refresh();
    }

    public void refresh() {
        this.nbMaxActive.setText("" + ((ConfigureWizard)this.wizard).maxActiveTorrents);
        this.nbMaxDownloads.setText("" + ((ConfigureWizard)this.wizard).maxDownloads);
        this.nbMaxUploadsPerTorrent.setText("" + ((ConfigureWizard)this.wizard).nbUploadsPerTorrent);
    }

    private int findIndex(int value, int[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public boolean isNextEnabled() {
        return true;
    }

    public IWizardPanel getNextPanel() {
        return new NatPanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }
}

