/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class BufferedTableRow {
    public static final int VALUE_SIZE_INC = 8;
    protected TableItem item;
    protected String[] text_values = new String[0];
    protected Image[] image_values = new Image[0];
    protected Color[] foreground_colors = new Color[0];
    protected Color foreground;

    public BufferedTableRow(Table _table) {
        this(_table, -1);
    }

    public BufferedTableRow(Table _table, int index) {
        this.item = index >= 0 && index < _table.getItemCount() ? new TableItem(_table, 0, index) : new TableItem(_table, 0);
    }

    public TableItem getItem() {
        return this.item;
    }

    public void dispose() {
        this.item.dispose();
    }

    public void setImage(int index, Image new_image) {
        Image image;
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        if (index >= this.image_values.length) {
            int new_size = Math.max(index + 1, this.image_values.length + 8);
            Image[] new_images = new Image[new_size];
            System.arraycopy(this.image_values, 0, new_images, 0, this.image_values.length);
            this.image_values = new_images;
        }
        if (new_image == (image = this.image_values[index])) {
            return;
        }
        this.image_values[index] = new_image;
        this.item.setImage(index, new_image);
    }

    public boolean isDisposed() {
        return this.item == null || this.item.isDisposed();
    }

    public Color getForeground() {
        if (this.item == null || this.item.isDisposed()) {
            return null;
        }
        return this.item.getForeground();
    }

    public void setForeground(Color c) {
        if (this.item == null || this.item.isDisposed()) {
            return;
        }
        if (this.foreground != null && this.foreground.equals((Object)c)) {
            return;
        }
        this.foreground = c;
        this.item.setForeground(this.foreground);
    }

    public boolean setForeground(int index, Color new_color) {
        Color value;
        if (this.item == null || this.item.isDisposed()) {
            return false;
        }
        if (index >= this.foreground_colors.length) {
            int new_size = Math.max(index + 1, this.foreground_colors.length + 8);
            Color[] new_colors = new Color[new_size];
            System.arraycopy(this.foreground_colors, 0, new_colors, 0, this.foreground_colors.length);
            this.foreground_colors = new_colors;
        }
        if (new_color == (value = this.foreground_colors[index])) {
            return false;
        }
        if (new_color != null && value != null && new_color.equals((Object)value)) {
            return false;
        }
        this.foreground_colors[index] = new_color;
        try {
            this.item.setForeground(index, new_color);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return true;
    }

    public Color getForeground(int index) {
        if (this.item == null || this.item.isDisposed()) {
            return null;
        }
        if (index >= this.foreground_colors.length) {
            return this.item.getForeground();
        }
        return this.foreground_colors[index];
    }

    public String getText(int index) {
        if (index >= this.text_values.length) {
            return "";
        }
        return this.text_values[index] == null ? "" : this.text_values[index];
    }

    public boolean setText(int index, String new_value) {
        String value;
        if (this.item == null || this.item.isDisposed()) {
            return false;
        }
        if (index >= this.text_values.length) {
            int new_size = Math.max(index + 1, this.text_values.length + 8);
            String[] new_values = new String[new_size];
            System.arraycopy(this.text_values, 0, new_values, 0, this.text_values.length);
            this.text_values = new_values;
        }
        if (new_value == (value = this.text_values[index])) {
            return false;
        }
        if (new_value != null && value != null && new_value.equals(value)) {
            return false;
        }
        this.text_values[index] = new_value;
        this.item.setText(index, new_value == null ? "" : new_value);
        return true;
    }

    public Rectangle getBounds(int index) {
        if (this.item == null || this.item.isDisposed()) {
            return null;
        }
        return this.item.getBounds(index);
    }

    public Table getTable() {
        if (this.item == null || this.item.isDisposed()) {
            return null;
        }
        Table parent = this.item.getParent();
        if (parent == null || parent.isDisposed()) {
            return null;
        }
        return parent;
    }

    public Color getBackground() {
        if (this.item == null || this.item.isDisposed()) {
            return null;
        }
        return this.item.getBackground();
    }

    public int getIndex() {
        Table table = this.getTable();
        if (table == null) {
            return -1;
        }
        return table.indexOf(this.item);
    }

    public boolean setIndex(int index) {
        Table table = this.getTable();
        if (table == null) {
            return false;
        }
        int oldIndex = table.indexOf(this.item);
        if (oldIndex == index) {
            return false;
        }
        if (index > oldIndex) {
            --index;
        }
        TableItem newItem = new TableItem(table, 0, index);
        this.copyToItem(newItem);
        table.remove(table.indexOf(this.item));
        this.item = newItem;
        return true;
    }

    private void copyToItem(TableItem newItem) {
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        newItem.setText(this.text_values);
        newItem.setImage(this.image_values);
        Color colorFG = this.item.getForeground();
        Color colorBG = this.item.getBackground();
        newItem.setForeground(colorFG);
        newItem.setBackground(colorBG);
        int numColumns = table.getColumnCount();
        int i = 0;
        while (i < numColumns) {
            try {
                Color colorColumnFG = this.item.getForeground(i);
                Color colorColumnBG = this.item.getBackground(i);
                if (!colorColumnFG.equals((Object)colorFG)) {
                    newItem.setForeground(i, colorColumnFG);
                }
                if (!colorColumnBG.equals((Object)colorBG)) {
                    newItem.setBackground(i, colorColumnBG);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            ++i;
        }
        if (this.getSelected()) {
            table.select(table.indexOf(newItem));
        } else {
            table.deselect(table.indexOf(newItem));
        }
    }

    public boolean getSelected() {
        Table table = this.getTable();
        if (table == null) {
            return false;
        }
        return table.isSelected(table.indexOf(this.item));
    }

    public void setSelected(boolean bSelected) {
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        if (bSelected) {
            table.select(this.getIndex());
        } else {
            table.deselect(this.getIndex());
        }
    }

    public void setTableItem(TableItem ti, boolean bCopyFromOld) {
        if (bCopyFromOld) {
            this.copyToItem(ti);
        } else {
            ti.setForeground(null);
            ti.setBackground(null);
            Table table = this.getTable();
            if (table == null) {
                return;
            }
            int numColumns = table.getColumnCount();
            int i = 0;
            while (i < numColumns) {
                try {
                    ti.setForeground(i, null);
                    ti.setBackground(i, null);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.text_values = new String[0];
        this.image_values = new Image[0];
        this.foreground_colors = new Color[0];
        this.foreground = null;
        this.item = ti;
    }
}

