/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class Utils {
    public static void disposeComposite(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            if (control != null && !control.isDisposed()) {
                if (control instanceof Composite) {
                    Utils.disposeComposite((Composite)control);
                }
                try {
                    control.dispose();
                }
                catch (SWTException e) {
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
        if (!composite.isDisposed()) {
            try {
                composite.dispose();
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void changeBackgroundComposite(Composite composite, Color color) {
    }

    public static void setTextLinkFromClipboard(Shell shell, GridData gridData, Text url) {
        String link = Utils.getLinkFromClipboard(shell.getDisplay());
        Utils.setTextLink(shell, gridData, url, link);
    }

    public static void setTextLink(Shell shell, GridData gridData, Text url, String link) {
        if (link == null) {
            return;
        }
        if (link.length() > 7) {
            GC gc = new GC((Drawable)url);
            FontMetrics fm = gc.getFontMetrics();
            int width = (link.length() + 10) * fm.getAverageCharWidth();
            if (width > gridData.widthHint) {
                if (width > shell.getDisplay().getBounds().width) {
                    gridData.widthHint = shell.getDisplay().getBounds().width - 20;
                    shell.setLocation(0, 0);
                } else {
                    gridData.widthHint = width;
                }
            }
        }
        url.setText(link);
    }

    public static String getLinkFromClipboard(Display display) {
        int begin;
        String link = "http://";
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents((Transfer)transfer);
        if (data != null && (begin = data.indexOf("http://")) >= 0) {
            int end = data.indexOf("\n", begin + 7);
            String stringURL = end >= 0 ? data.substring(begin, end - 1) : data.substring(begin);
            try {
                URL parsedURL = new URL(stringURL);
                link = parsedURL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return link;
    }

    public static void saveTableColumn(TableColumn t) {
        if (t != null && t.getData("configName") != null) {
            COConfigurationManager.setParameter(String.valueOf((String)t.getData("configName")) + ".width", t.getWidth());
            COConfigurationManager.save();
        }
    }

    public static void saveTableColumn(TableColumn[] t) {
        int i = 0;
        while (i < t.length) {
            if (t[i] != null && t[i].getData("configName") != null) {
                COConfigurationManager.setParameter(String.valueOf((String)t[i].getData("configName")) + ".width", t[i].getWidth());
            }
            ++i;
        }
        COConfigurationManager.save();
    }

    public static void saveTableColumnIfAllowed(TableColumn t) {
        if (COConfigurationManager.getBooleanParameter("Save detail views column widths", false)) {
            Utils.saveTableColumn(t);
        }
    }

    public static void centreWindow(Shell shell) {
        Rectangle displayRect;
        try {
            displayRect = shell.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayRect = shell.getDisplay().getClientArea();
        }
        Rectangle shellRect = shell.getBounds();
        int x = (displayRect.width - shellRect.width) / 2;
        int y = (displayRect.height - shellRect.height) / 2;
        shell.setLocation(x, y);
    }

    public static void createURLDropTarget(final Control control, final Text url) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.detail = 4;
            }

            public void drop(DropTargetEvent event) {
                GridData gridData = new GridData(768);
                gridData.widthHint = 300;
                Utils.setTextLink(control instanceof Shell ? (Shell)control : control.getShell(), gridData, url, ((URLTransfer.URLType)event.data).linkURL);
                url.setLayoutData((Object)gridData);
                control.pack();
            }
        });
    }

    public static void alternateTableBackground(Table table) {
        TableItem[] rows = table.getItems();
        Color[] colors = new Color[]{table.getDisplay().getSystemColor(25), Colors.colorAltRow};
        int i = 0;
        while (i < rows.length) {
            Color newColor = colors[i % colors.length];
            if (!rows[i].getBackground().equals((Object)newColor)) {
                rows[i].setBackground(newColor);
            }
            ++i;
        }
    }

    public static class LabelWrapControlListener
    extends ControlAdapter {
        public void controlResized(ControlEvent e) {
            GridLayout parentLayout;
            Composite parent = (Composite)e.widget;
            Control[] children = parent.getChildren();
            if (children.length > 0 && (parentLayout = (GridLayout)parent.getLayout()) != null) {
                Point size;
                int marginWidth = parentLayout.marginWidth;
                Composite grandParent = parent.getParent();
                if (grandParent instanceof ScrolledComposite) {
                    ScrollBar sb;
                    Composite greatGP = grandParent.getParent();
                    if (greatGP != null) {
                        size = greatGP.getSize();
                        if (greatGP.getLayout() instanceof GridLayout) {
                            marginWidth += ((GridLayout)greatGP.getLayout()).marginWidth;
                        }
                    } else {
                        size = grandParent.getSize();
                    }
                    if (grandParent.getLayout() instanceof GridLayout) {
                        marginWidth += ((GridLayout)grandParent.getLayout()).marginWidth;
                    }
                    if ((sb = grandParent.getVerticalBar()) != null) {
                        size.x -= sb.getSize().x + 1;
                    }
                } else {
                    size = parent.getSize();
                }
                boolean oneChanged = false;
                int i = 0;
                while (i < children.length) {
                    GridData gd;
                    if (children[i] instanceof Label && (children[i].getStyle() & 0x40) == 64 && (gd = (GridData)children[i].getLayoutData()) != null && gd.horizontalAlignment == 4) {
                        if (gd.horizontalSpan == parentLayout.numColumns) {
                            gd.widthHint = size.x - 2 * marginWidth;
                            oneChanged = true;
                        } else {
                            Point pt = children[i].getLocation();
                            gd.widthHint = size.x - pt.x - 2 * marginWidth;
                            oneChanged = true;
                        }
                    }
                    ++i;
                }
                if (oneChanged) {
                    parent.layout(true);
                    if (grandParent instanceof ScrolledComposite) {
                        ((ScrolledComposite)grandParent).setMinSize(parent.computeSize(-1, -1, true));
                    }
                }
            }
        }
    }
}

