/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class StartServer {
    public static final String ACCESS_STRING = "Azureus Start Server Access";
    private ServerSocket socket;
    private int state;
    private AzureusCore azureus_core;
    private boolean bContinue;
    public static final int STATE_FAULTY = 0;
    public static final int STATE_LISTENING = 1;
    protected List queued_torrents = new ArrayList();
    protected boolean core_started = false;
    protected AEMonitor this_mon = new AEMonitor("StartServer");

    public StartServer(AzureusCore _azureus_core) {
        try {
            this.azureus_core = _azureus_core;
            this.socket = new ServerSocket(6880, 50, InetAddress.getByName("127.0.0.1"));
            this.state = 1;
            this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                public void started(AzureusCore core) {
                    StartServer.this.openQueuedTorrents();
                }
            });
            LGLogger.log("StartServer: listening on 127.0.0.1:6880 for passed torrent info");
        }
        catch (Exception e) {
            this.state = 0;
            LGLogger.log("StartServer ERROR: unable to bind to 127.0.0.1:6880 for passed torrent info");
        }
    }

    public void pollForConnections() {
        AEThread t = new AEThread("Start Server"){

            public void runSupport() {
                StartServer.this.pollForConnectionsSupport();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void pollForConnectionsSupport() {
        this.bContinue = true;
        while (this.bContinue) {
            BufferedReader br = null;
            try {
                try {
                    Socket sck = this.socket.accept();
                    String address = sck.getInetAddress().getHostAddress();
                    if (address.equals("localhost") || address.equals("127.0.0.1")) {
                        br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                        String line = br.readLine();
                        LGLogger.log("Main::startServer: received '" + line + "'");
                        if (line != null) {
                            if (!COConfigurationManager.getBooleanParameter("add_torrents_silently")) {
                                this.showMainWindow();
                            }
                            StringTokenizer st = new StringTokenizer(line, ";");
                            int i = 0;
                            if (st.countTokens() > 1) {
                                String[] args = new String[st.countTokens() - 1];
                                String checker = st.nextToken();
                                if (checker.equals(ACCESS_STRING)) {
                                    String debug_str = "";
                                    while (st.hasMoreElements()) {
                                        String bit = st.nextToken().replaceAll("&;", ";").replaceAll("&&", "&");
                                        debug_str = String.valueOf(debug_str) + (debug_str.length() == 0 ? "" : " ; ") + bit;
                                        args[i++] = bit;
                                    }
                                    LGLogger.log("Main::startServer: decoded to '" + debug_str + "'");
                                    this.openTorrent(args);
                                }
                            }
                        }
                    }
                    sck.close();
                }
                catch (Exception e) {
                    if (e instanceof SocketException) continue;
                    Debug.printStackTrace(e);
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void openTorrent(String[] args) {
        if (args.length != 0 && args[0].equals("args") && args.length > 1) {
            int i = 1;
            while (i < args.length) {
                LGLogger.log("Main::useParam: open '" + args[i] + "'");
                try {
                    this.this_mon.enter();
                    if (!this.core_started) {
                        this.queued_torrents.add(args[i]);
                        this.this_mon.exit();
                        return;
                    }
                }
                finally {
                    this.this_mon.exit();
                }
                try {
                    TorrentOpener.openTorrent(this.azureus_core, args[i]);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    protected void openQueuedTorrents() {
        try {
            this.this_mon.enter();
            this.core_started = true;
        }
        finally {
            this.this_mon.exit();
        }
        int i = 0;
        while (i < this.queued_torrents.size()) {
            try {
                TorrentOpener.openTorrent(this.azureus_core, (String)this.queued_torrents.get(i));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void showMainWindow() {
        if (MainWindow.getWindow() != null) {
            MainWindow.getWindow().getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!COConfigurationManager.getBooleanParameter("Password enabled", false) || MainWindow.getWindow().isVisible()) {
                        MainWindow.getWindow().setVisible(true);
                    } else {
                        PasswordWindow.showPasswordWindow(MainWindow.getWindow().getDisplay());
                    }
                }
            });
        }
    }

    public void stopIt() {
        this.bContinue = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getState() {
        return this.state;
    }
}

