/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.components.BufferedWidget;
import org.gudy.azureus2.ui.swt.config.IParameter;
import org.gudy.azureus2.ui.swt.views.TableView;

public class Messages {
    private Messages() {
    }

    public static void updateLanguageForControl(Widget widget) {
        block19: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block18: {
                                        if (widget == null || widget.isDisposed()) {
                                            return;
                                        }
                                        Messages.updateLanguageFromData(widget, null);
                                        Messages.updateToolTipFromData(widget);
                                        if (!(widget instanceof CTabFolder)) break block18;
                                        CTabFolder folder = (CTabFolder)widget;
                                        CTabItem[] items = folder.getItems();
                                        int i = 0;
                                        while (i < items.length) {
                                            Messages.updateLanguageForControl((Widget)items[i]);
                                            Messages.updateLanguageForControl((Widget)items[i].getControl());
                                            ++i;
                                        }
                                        break block19;
                                    }
                                    if (!(widget instanceof TabFolder)) break block20;
                                    TabFolder folder = (TabFolder)widget;
                                    TabItem[] items = folder.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        Messages.updateLanguageForControl((Widget)items[i]);
                                        Messages.updateLanguageForControl((Widget)items[i].getControl());
                                        ++i;
                                    }
                                    break block19;
                                }
                                if (!(widget instanceof CoolBar)) break block21;
                                CoolItem[] items = ((CoolBar)widget).getItems();
                                int i = 0;
                                while (i < items.length) {
                                    Control control = items[i].getControl();
                                    Messages.updateLanguageForControl((Widget)control);
                                    ++i;
                                }
                                break block19;
                            }
                            if (!(widget instanceof ToolBar)) break block22;
                            ToolItem[] items = ((ToolBar)widget).getItems();
                            int i = 0;
                            while (i < items.length) {
                                Messages.updateLanguageForControl((Widget)items[i]);
                                ++i;
                            }
                            break block19;
                        }
                        if (!(widget instanceof Composite)) break block23;
                        Composite group = (Composite)widget;
                        Control[] controls = group.getChildren();
                        int i = 0;
                        while (i < controls.length) {
                            Messages.updateLanguageForControl((Widget)controls[i]);
                            ++i;
                        }
                        if (widget instanceof Table) {
                            Table table = (Table)widget;
                            TableColumn[] columns = table.getColumns();
                            int i2 = 0;
                            while (i2 < columns.length) {
                                Messages.updateLanguageFromData((Widget)columns[i2], null);
                                ++i2;
                            }
                            Messages.updateLanguageForControl((Widget)table.getMenu());
                            TableView tv = (TableView)widget.getData("TableView");
                            if (tv != null) {
                                tv.tableInvalidate();
                            }
                        } else if (widget instanceof Tree) {
                            Tree tree = (Tree)widget;
                            TreeItem[] treeitems = tree.getItems();
                            int i3 = 0;
                            while (i3 < treeitems.length) {
                                Messages.updateLanguageForControl((Widget)treeitems[i3]);
                                ++i3;
                            }
                        } else if (widget instanceof TreeItem) {
                            TreeItem treeItem = (TreeItem)widget;
                            TreeItem[] treeitems = treeItem.getItems();
                            int i4 = 0;
                            while (i4 < treeitems.length) {
                                Messages.updateLanguageForControl((Widget)treeitems[i4]);
                                ++i4;
                            }
                        }
                        group.layout();
                        break block19;
                    }
                    if (!(widget instanceof MenuItem)) break block24;
                    MenuItem menuItem = (MenuItem)widget;
                    Messages.updateLanguageForControl((Widget)menuItem.getMenu());
                    break block19;
                }
                if (!(widget instanceof Menu)) break block25;
                Menu menu = (Menu)widget;
                if (menu.getStyle() == 8) {
                    System.out.println("POP_UP");
                }
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    Messages.updateLanguageForControl((Widget)items[i]);
                    ++i;
                }
                break block19;
            }
            if (!(widget instanceof TreeItem)) break block19;
            TreeItem treeitem = (TreeItem)widget;
            TreeItem[] treeitems = treeitem.getItems();
            int i = 0;
            while (i < treeitems.length) {
                Messages.updateLanguageFromData((Widget)treeitems[i], null);
                ++i;
            }
        }
    }

    public static void setLanguageText(IParameter paramObject, String key) {
        Messages.setLanguageText((Widget)paramObject.getControl(), key, false);
    }

    public static void setLanguageText(IParameter paramObject, String key, String[] params) {
        Messages.setLanguageText((Widget)paramObject.getControl(), key, params, false);
    }

    public static void setLanguageText(Widget widget, String key) {
        Messages.setLanguageText(widget, key, false);
    }

    public static void setLanguageText(Widget widget, String key, String[] params) {
        Messages.setLanguageText(widget, key, params, false);
    }

    public static void setLanguageText(Widget widget, String key, boolean setTooltipOnly) {
        Messages.setLanguageText(widget, key, null, setTooltipOnly);
    }

    private static void setLanguageText(Widget widget, String key, String[] params, boolean setTooltipOnly) {
        widget.setData((Object)key);
        if (!setTooltipOnly) {
            Messages.updateLanguageFromData(widget, params);
        }
        Messages.updateToolTipFromData(widget);
    }

    public static void setLanguageText(BufferedWidget buffered_widget, String key) {
        Messages.setLanguageText(buffered_widget.getWidget(), key, false);
    }

    public static void setLanguageText(BufferedWidget buffered_widget, String key, boolean setTooltipOnly) {
        Messages.setLanguageText(buffered_widget.getWidget(), key, setTooltipOnly);
    }

    private static void updateToolTipFromData(Widget widget) {
        String key;
        if (widget instanceof Control) {
            String key2 = (String)widget.getData();
            if (key2 != null) {
                String toolTip;
                if (!key2.endsWith(".tooltip")) {
                    key2 = String.valueOf(key2) + ".tooltip";
                }
                if (!(toolTip = MessageText.getString(key2)).equals(String.valueOf('!') + key2 + '!')) {
                    ((Control)widget).setToolTipText(toolTip);
                }
            }
        } else if (widget instanceof ToolItem && (key = (String)widget.getData()) != null) {
            String toolTip;
            if (!key.endsWith(".tooltip")) {
                key = String.valueOf(key) + ".tooltip";
            }
            if (!(toolTip = MessageText.getString(key)).equals(String.valueOf('!') + key + '!')) {
                ((ToolItem)widget).setToolTipText(toolTip);
            }
        }
    }

    private static void updateLanguageFromData(Widget widget, String[] params) {
        if (widget.getData() != null) {
            String key = null;
            try {
                key = (String)widget.getData();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (key == null) {
                return;
            }
            if (key.endsWith(".tooltip")) {
                return;
            }
            String message = params == null ? MessageText.getString((String)widget.getData()) : MessageText.getString((String)widget.getData(), params);
            if (widget instanceof MenuItem) {
                ((MenuItem)widget).setText(message);
            } else if (widget instanceof TableColumn) {
                ((TableColumn)widget).setText(message);
            } else if (widget instanceof Label) {
                ((Label)widget).setText(message);
            } else if (widget instanceof Group) {
                ((Group)widget).setText(message);
            } else if (widget instanceof Button) {
                ((Button)widget).setText(message);
            } else if (widget instanceof CTabItem) {
                ((CTabItem)widget).setText(message);
            } else if (widget instanceof TabItem) {
                ((TabItem)widget).setText(message);
            } else if (widget instanceof TreeItem) {
                ((TreeItem)widget).setText(message);
            } else if (widget instanceof Shell) {
                ((Shell)widget).setText(message);
            } else {
                System.out.println("No cast for " + widget.getClass().getName());
            }
        }
    }

    public static void setLanguageTooltip(Widget widget, String key) {
        widget.setData((Object)key);
        Messages.updateTooltipLanguageFromData(widget);
    }

    public static void updateTooltipLanguageFromData(Widget widget) {
        if (widget.getData() != null) {
            if (widget instanceof CLabel) {
                ((CLabel)widget).setToolTipText(MessageText.getString((String)widget.getData()));
            } else {
                System.out.println("No cast for " + widget.getClass().getName());
            }
        }
    }
}

