/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.view;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeEvent;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;

public class BasicPluginViewImpl
extends PluginView
implements UIPropertyChangeListener {
    BasicPluginViewModel model;
    String pluginName;
    Display display;
    Composite panel;
    ProgressBar progress;
    BufferedLabel status;
    BufferedLabel task;
    StyledText log;

    public BasicPluginViewImpl(BasicPluginViewModel model) {
        this.model = model;
        this.pluginName = model.getName();
    }

    public String getPluginViewName() {
        return this.pluginName;
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void initialize(Composite composite) {
        GridData gridData;
        this.display = composite.getDisplay();
        this.panel = new Composite(composite, 0);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 2;
        this.panel.setLayout((Layout)panelLayout);
        if (this.model.getStatus().getVisible()) {
            Label statusTitle = new Label(this.panel, 0);
            Messages.setLanguageText((Widget)statusTitle, "plugins.basicview.status");
            this.status = new BufferedLabel(this.panel, 0);
            gridData = new GridData(768);
            this.status.setLayoutData(gridData);
        }
        if (this.model.getActivity().getVisible()) {
            Label activityTitle = new Label(this.panel, 0);
            Messages.setLanguageText((Widget)activityTitle, "plugins.basicview.activity");
            this.task = new BufferedLabel(this.panel, 0);
            gridData = new GridData(768);
            this.task.setLayoutData(gridData);
        }
        if (this.model.getProgress().getVisible()) {
            Label progressTitle = new Label(this.panel, 0);
            Messages.setLanguageText((Widget)progressTitle, "plugins.basicview.progress");
            this.progress = new ProgressBar(this.panel, 0);
            this.progress.setMaximum(100);
            this.progress.setMinimum(0);
            gridData = new GridData(768);
            this.progress.setLayoutData((Object)gridData);
        }
        if (this.model.getLogArea().getVisible()) {
            Label logTitle = new Label(this.panel, 0);
            Messages.setLanguageText((Widget)logTitle, "plugins.basicview.log");
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            logTitle.setLayoutData((Object)gridData);
            this.log = new StyledText(this.panel, 776);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            this.log.setLayoutData((Object)gridData);
            this.log.setText(this.model.getLogArea().getText());
            this.model.getLogArea().addPropertyChangeListener(this);
        }
    }

    public void refresh() {
        if (this.status != null) {
            this.status.setText(this.model.getStatus().getText());
        }
        if (this.task != null) {
            this.task.setText(this.model.getActivity().getText());
        }
        if (this.progress != null) {
            this.progress.setSelection(this.model.getProgress().getPercentageComplete());
        }
    }

    public void propertyChanged(final UIPropertyChangeEvent ev) {
        if (ev.getSource() != this.model.getLogArea()) {
            return;
        }
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if (this.log == null) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (BasicPluginViewImpl.this.log.isDisposed()) {
                    return;
                }
                String old_value = (String)ev.getOldPropertyValue();
                String new_value = (String)ev.getNewPropertyValue();
                if (new_value.startsWith(old_value)) {
                    if (new_value.length() > 60000) {
                        BasicPluginViewImpl.this.log.setText(new_value.substring(new_value.length() - 50000));
                    } else {
                        BasicPluginViewImpl.this.log.append(new_value.substring(old_value.length()));
                    }
                } else {
                    BasicPluginViewImpl.this.log.setText(new_value);
                }
            }
        });
    }

    public void delete() {
        this.model.getLogArea().removePropertyChangeListener(this);
        super.delete();
    }

    public String getFullTitle() {
        return this.pluginName;
    }
}

