/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;

public class ParameterImpl
implements EnablerParameter,
org.gudy.azureus2.core3.config.ParameterListener {
    protected PluginConfig config;
    private String key;
    private String label;
    private List toDisable = new ArrayList();
    private List toEnable = new ArrayList();
    private List listeners = new ArrayList();

    public ParameterImpl(PluginConfig _config, String _key, String _label) {
        this.config = _config;
        this.key = _key;
        this.label = _label;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public void addDisabledOnSelection(Parameter parameter) {
        this.toDisable.add(parameter);
    }

    public void addEnabledOnSelection(Parameter parameter) {
        this.toEnable.add(parameter);
    }

    public List getDisabledOnSelectionParameters() {
        return this.toDisable;
    }

    public List getEnabledOnSelectionParameters() {
        return this.toEnable;
    }

    public void parameterChanged(String key) {
        int i = 0;
        while (i < this.listeners.size()) {
            Object o = this.listeners.get(i);
            if (o instanceof ParameterListener) {
                ((ParameterListener)o).parameterChanged(this);
            } else {
                ((ConfigParameterListener)o).configParameterChanged(this);
            }
            ++i;
        }
    }

    public void addListener(ParameterListener l) {
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, this);
        }
    }

    public void removeListener(ParameterListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }

    public void addConfigParameterListener(ConfigParameterListener l) {
        this.listeners.add(l);
        if (this.listeners.size() == 1) {
            COConfigurationManager.addParameterListener(this.key, this);
        }
    }

    public void removeConfigParameterListener(ConfigParameterListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            COConfigurationManager.removeParameterListener(this.key, this);
        }
    }
}

