/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebContextImpl;

public class TrackerImpl
extends TrackerWCHelper
implements Tracker,
TRHostListener,
TRHostAuthenticationListener {
    protected static TrackerImpl tracker;
    protected static AEMonitor class_mon;
    protected List listeners = new ArrayList();
    protected TRHost host;
    protected List auth_listeners = new ArrayList();

    static {
        class_mon = new AEMonitor("Tracker");
    }

    public static Tracker getSingleton() {
        try {
            class_mon.enter();
            if (tracker == null) {
                tracker = new TrackerImpl(TRHostFactory.getSingleton());
            }
            TrackerImpl trackerImpl = tracker;
            class_mon.exit();
            return trackerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected TrackerImpl(TRHost _host) {
        this.setTracker(this);
        this.host = _host;
        this.host.addListener(this);
    }

    public String getName() {
        return this.host.getName();
    }

    public URL[] getURLs() {
        String tracker_host = COConfigurationManager.getStringParameter("Tracker IP", "");
        ArrayList<URL> urls = new ArrayList<URL>();
        if (tracker_host.length() > 0) {
            int port;
            if (COConfigurationManager.getBooleanParameter("Tracker Port Enable", false)) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                try {
                    urls.add(new URL("http://" + tracker_host + ":" + port + "/announce"));
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port SSL Enable", true)) {
                port = COConfigurationManager.getIntParameter("Tracker Port SSL", 7000);
                try {
                    urls.add(new URL("https://" + tracker_host + ":" + port + "/announce"));
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port UDP Enable")) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                boolean auth = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
                try {
                    urls.add(new URL("udp://" + tracker_host + ":" + port + "/announce" + (auth ? "?auth" : "")));
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        URL[] res = new URL[urls.size()];
        urls.toArray(res);
        return res;
    }

    public TrackerTorrent host(Torrent _torrent, boolean _persistent) throws TrackerException {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return new TrackerTorrentImpl(this.host.hostTorrent(torrent.getTorrent(), _persistent));
        }
        catch (Throwable e) {
            throw new TrackerException("Tracker: host operation fails", e);
        }
    }

    public TrackerTorrent[] getTorrents() {
        TRHostTorrent[] hts = this.host.getTorrents();
        TrackerTorrent[] res = new TrackerTorrent[hts.length];
        int i = 0;
        while (i < hts.length) {
            res[i] = new TrackerTorrentImpl(hts[i]);
            ++i;
        }
        return res;
    }

    public TrackerWebContext createWebContext(int port, int protocol) throws TrackerException {
        return new TrackerWebContextImpl(this, null, port, protocol);
    }

    public TrackerWebContext createWebContext(String name, int port, int protocol) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol);
    }

    public void torrentAdded(TRHostTorrent t) {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.listeners.size()) {
                ((TrackerListener)this.listeners.get(i)).torrentAdded(new TrackerTorrentImpl(t));
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void torrentChanged(TRHostTorrent t) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((TrackerListener)this.listeners.get(i)).torrentChanged(new TrackerTorrentImpl(t));
            ++i;
        }
    }

    public void torrentRemoved(TRHostTorrent t) {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.listeners.size()) {
                ((TrackerListener)this.listeners.get(i)).torrentRemoved(new TrackerTorrentImpl(t));
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(TrackerListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
            TrackerTorrent[] torrents = this.getTorrents();
            int i = 0;
            while (i < torrents.length) {
                listener.torrentAdded(torrents[i]);
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(TrackerListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean authenticate(URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                boolean res = ((TrackerAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user, password);
                if (res) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    public byte[] authenticate(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] res = ((TrackerAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    public void addAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                this.host.addAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                this.host.removeAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

