/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.test;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1;

public class SHA1Verification {
    public static final String dirname = "D:" + System.getProperty("file.separator") + "testdir";

    public static void main(String[] args) {
        if (!new File(dirname).exists()) {
            SHA1Verification.createTestFiles();
        }
        SHA1Verification.runTests();
    }

    public static void createTestFiles() {
        try {
            System.out.println("Creating test files ... ");
            Random rand = new Random();
            String rootname = "f-";
            long[] lArray = new long[3];
            lArray[1] = 1L;
            lArray[2] = 50000000L;
            long[] sizes = lArray;
            File testdir = new File(dirname);
            testdir.mkdirs();
            int i = 0;
            while (i < sizes.length) {
                long size = sizes[i];
                File file = new File(testdir, String.valueOf(rootname) + String.valueOf(size));
                System.out.println(String.valueOf(file.getName()) + "...");
                FileChannel fc = new RandomAccessFile(file, "rw").getChannel();
                long position = 0L;
                while (position < size) {
                    long remaining = size - position;
                    if (remaining > 1024000L) {
                        remaining = 1024000L;
                    }
                    byte[] buffer = new byte[new Long(remaining).intValue()];
                    rand.nextBytes(buffer);
                    ByteBuffer bb = ByteBuffer.wrap(buffer);
                    position += (long)fc.write(bb);
                }
                fc.close();
                ++i;
            }
            System.out.println("DONE\n");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public static void runTests() {
        try {
            MessageDigest sha1Sun = MessageDigest.getInstance("SHA-1");
            SHA1 sha1Gudy = new SHA1();
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            File dir = new File(dirname);
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                FileChannel fc = new RandomAccessFile(files[i], "r").getChannel();
                System.out.println("Testing " + files[i].getName() + " ...");
                while (fc.position() < fc.size()) {
                    fc.read(buffer);
                    buffer.flip();
                    byte[] raw = new byte[buffer.limit()];
                    System.arraycopy(buffer.array(), 0, raw, 0, raw.length);
                    sha1Gudy.update(buffer);
                    sha1Gudy.saveState();
                    ByteBuffer bb = ByteBuffer.wrap(new byte[56081]);
                    sha1Gudy.digest(bb);
                    sha1Gudy.restoreState();
                    sha1Sun.update(raw);
                    buffer.clear();
                }
                byte[] sun = sha1Sun.digest();
                sha1Sun.reset();
                byte[] gudy = sha1Gudy.digest();
                sha1Gudy.reset();
                if (Arrays.equals(sun, gudy)) {
                    System.out.println("  SHA1-Gudy: OK");
                } else {
                    System.out.println("  SHA1-Gudy: FAILED");
                }
                buffer.clear();
                fc.close();
                System.out.println();
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

