/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Debug;

public class ByteFormatter {
    public static String nicePrintTorrentHash(TOTorrent torrent) {
        return ByteFormatter.nicePrintTorrentHash(torrent, false);
    }

    public static String nicePrintTorrentHash(TOTorrent torrent, boolean tight) {
        byte[] hash;
        if (torrent == null) {
            hash = new byte[20];
        } else {
            try {
                hash = torrent.getHash();
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
                hash = new byte[20];
            }
        }
        return ByteFormatter.nicePrint(hash, tight);
    }

    public static String nicePrint(String str) {
        return ByteFormatter.nicePrint(str.getBytes(), true);
    }

    public static String nicePrint(byte[] data) {
        return ByteFormatter.nicePrint(data, false);
    }

    public static String nicePrint(byte[] data, boolean tight) {
        if (data == null) {
            return "";
        }
        String out = "";
        int i = 0;
        while (i < data.length) {
            out = String.valueOf(out) + ByteFormatter.nicePrint(data[i]);
            if (!tight && i % 4 == 3) {
                out = String.valueOf(out) + " ";
            }
            ++i;
        }
        return out;
    }

    public static String nicePrint(byte b) {
        byte b1 = (byte)(b >> 4 & 0xF);
        byte b2 = (byte)(b & 0xF);
        return String.valueOf(ByteFormatter.nicePrint2(b1)) + ByteFormatter.nicePrint2(b2);
    }

    public static String nicePrint2(byte b) {
        String out = "";
        switch (b) {
            case 0: {
                out = "0";
                break;
            }
            case 1: {
                out = "1";
                break;
            }
            case 2: {
                out = "2";
                break;
            }
            case 3: {
                out = "3";
                break;
            }
            case 4: {
                out = "4";
                break;
            }
            case 5: {
                out = "5";
                break;
            }
            case 6: {
                out = "6";
                break;
            }
            case 7: {
                out = "7";
                break;
            }
            case 8: {
                out = "8";
                break;
            }
            case 9: {
                out = "9";
                break;
            }
            case 10: {
                out = "A";
                break;
            }
            case 11: {
                out = "B";
                break;
            }
            case 12: {
                out = "C";
                break;
            }
            case 13: {
                out = "D";
                break;
            }
            case 14: {
                out = "E";
                break;
            }
            case 15: {
                out = "F";
            }
        }
        return out;
    }

    public static String encodeString(byte[] bytes) {
        return ByteFormatter.nicePrint(bytes, true);
    }

    public static byte[] decodeString(String str) {
        char[] chars = str.toCharArray();
        int chars_length = chars.length - chars.length % 2;
        byte[] res = new byte[chars_length / 2];
        int i = 0;
        while (i < chars_length) {
            String b = new String(chars, i, 2);
            res[i / 2] = (byte)Integer.parseInt(b, 16);
            i += 2;
        }
        return res;
    }
}

