/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequest;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class PRUDPPacketRequestScrape
extends PRUDPPacketRequest {
    protected byte[] hash;

    public PRUDPPacketRequestScrape(long con_id, byte[] _hash) {
        super(2, con_id);
        this.hash = _hash;
    }

    protected PRUDPPacketRequestScrape(DataInputStream is, long con_id, int trans_id) throws IOException {
        super(2, con_id, trans_id);
        this.hash = new byte[20];
        is.read(this.hash);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.write(this.hash);
    }

    public String getString() {
        return super.getString().concat("[").concat("hash=").concat(ByteFormatter.nicePrint(this.hash, true)).concat("]");
    }
}

