/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerPublishImpl;
import org.gudy.azureus2.core3.util.AEMonitor;

public class TRHostTorrentPublishImpl
implements TRHostTorrent {
    protected TRHostImpl host;
    protected TOTorrent torrent;
    protected int status = 3;
    protected boolean persistent;
    protected TRHostPeer[] peers = new TRHostPeer[0];
    protected List listeners = new ArrayList();
    protected List removal_listeners = new ArrayList();
    private HashMap data;
    protected AEMonitor this_mon = new AEMonitor("TRHostTorrentPublish");

    protected TRHostTorrentPublishImpl(TRHostImpl _host, TOTorrent _torrent) {
        this.host = _host;
        this.torrent = _torrent;
    }

    public void start() {
    }

    public void stop() {
    }

    public void remove() throws TRHostTorrentRemovalVetoException {
        try {
            this.this_mon.enter();
            this.canBeRemoved();
            this.host.remove(this);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean canBeRemoved() throws TRHostTorrentRemovalVetoException {
        int i = 0;
        while (i < this.removal_listeners.size()) {
            ((TRHostTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
            ++i;
        }
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean _persistent) {
        this.persistent = _persistent;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public int getPort() {
        return -1;
    }

    public TRHostPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRHostPeer[] tRHostPeerArray = this.peers;
            this.this_mon.exit();
            return tRHostPeerArray;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public long getAnnounceCount() {
        return 0L;
    }

    public long getScrapeCount() {
        return 0L;
    }

    public long getCompletedCount() {
        return 0L;
    }

    protected void updateStats() {
        TRTrackerScraperResponse resp = null;
        TRTrackerClient tc = this.host.getTrackerClient(this);
        if (tc != null) {
            resp = TRTrackerScraperFactory.getSingleton().scrape(tc);
        }
        if (resp == null) {
            resp = TRTrackerScraperFactory.getSingleton().scrape(this.torrent);
        }
        try {
            this.this_mon.enter();
            if (resp != null && resp.isValid()) {
                int peer_count = resp.getPeers();
                int seed_count = resp.getSeeds();
                this.peers = new TRHostPeer[peer_count + seed_count];
                int i = 0;
                while (i < this.peers.length) {
                    this.peers[i] = new TRHostPeerPublishImpl(i < seed_count);
                    ++i;
                }
            } else {
                this.peers = new TRHostPeer[0];
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getSeedCount() {
        return 0;
    }

    public int getLeecherCount() {
        return 0;
    }

    public int getBadNATCount() {
        return 0;
    }

    public long getTotalUploaded() {
        return 0L;
    }

    public long getTotalDownloaded() {
        return 0L;
    }

    public long getTotalLeft() {
        return 0L;
    }

    public long getAverageUploaded() {
        return 0L;
    }

    public long getAverageDownloaded() {
        return 0L;
    }

    public long getTotalBytesIn() {
        return 0L;
    }

    public long getTotalBytesOut() {
        return 0L;
    }

    public long getAverageBytesIn() {
        return 0L;
    }

    public long getAverageBytesOut() {
        return 0L;
    }

    public void disableReplyCaching() {
    }

    protected void postProcess(TRHostTorrentRequest req) throws TRHostException {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.listeners.size()) {
                ((TRHostTorrentListener)this.listeners.get(i)).postProcess(req);
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            this.listeners.add(l);
            this.host.torrentListenerRegistered();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            this.listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

