/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientFactoryListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostConfigImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostExternalTorrent;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentPublishImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentRequestImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequest;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class TRHostImpl
implements TRHost,
TRTrackerClientFactoryListener,
TRTrackerServerListener,
TRTrackerServerFactoryListener,
TRTrackerServerRequestListener,
TRTrackerServerAuthenticationListener {
    protected static final int URL_DEFAULT_PORT = 80;
    protected static final int URL_DEFAULT_PORT_SSL = 443;
    protected static final int STATS_PERIOD_SECS = 60;
    protected static TRHostImpl singleton;
    protected static AEMonitor class_mon;
    protected TRHostConfigImpl config;
    protected Hashtable server_map = new Hashtable();
    protected List host_torrents = new ArrayList();
    protected Map host_torrent_hash_map = new HashMap();
    protected Map host_torrent_map = new HashMap();
    protected Map tracker_client_map = new HashMap();
    private static final int LDT_TORRENT_ADDED = 1;
    private static final int LDT_TORRENT_REMOVED = 2;
    private static final int LDT_TORRENT_CHANGED = 3;
    private ListenerManager listeners = ListenerManager.createAsyncManager("TRHost:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            TRHostListener target = (TRHostListener)_listener;
            if (type == 1) {
                target.torrentAdded((TRHostTorrent)value);
            } else if (type == 2) {
                target.torrentRemoved((TRHostTorrent)value);
            } else if (type == 3) {
                target.torrentChanged((TRHostTorrent)value);
            }
        }
    });
    protected List auth_listeners = new ArrayList();
    protected boolean server_factory_listener_added;
    protected AEMonitor this_mon = new AEMonitor("TRHost");

    static {
        class_mon = new AEMonitor("TRHost:class");
    }

    public static TRHost create() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRHostImpl();
            }
            TRHostImpl tRHostImpl = singleton;
            class_mon.exit();
            return tRHostImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRHostImpl() {
        try {
            this.this_mon.enter();
            this.config = new TRHostConfigImpl(this);
            TRTrackerClientFactory.addListener(this);
            AEThread t = new AEThread("TRHost::stats.loop"){

                public void runSupport() {
                    while (true) {
                        try {
                            if (COConfigurationManager.getBooleanParameter("Tracker Port Enable", false)) {
                                try {
                                    int port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                                    TRHostImpl.this.startServer(1, port, false);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            if (COConfigurationManager.getBooleanParameter("Tracker Port UDP Enable", false)) {
                                try {
                                    int port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                                    TRHostImpl.this.startServer(2, port, false);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            if (COConfigurationManager.getBooleanParameter("Tracker Port SSL Enable", false)) {
                                try {
                                    int port = COConfigurationManager.getIntParameter("Tracker Port SSL", 7000);
                                    TRHostImpl.this.startServer(1, port, true);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            Thread.sleep(60000L);
                            try {
                                TRHostImpl.this.this_mon.enter();
                                int i = 0;
                                while (i < TRHostImpl.this.host_torrents.size()) {
                                    TRHostTorrent ht = (TRHostTorrent)TRHostImpl.this.host_torrents.get(i);
                                    if (ht instanceof TRHostTorrentHostImpl) {
                                        ((TRHostTorrentHostImpl)ht).updateStats();
                                    } else {
                                        ((TRHostTorrentPublishImpl)ht).updateStats();
                                    }
                                    ++i;
                                }
                            }
                            finally {
                                TRHostImpl.this.this_mon.exit();
                            }
                            TRHostImpl.this.config.saveConfig();
                        }
                        catch (InterruptedException e) {
                            Debug.printStackTrace(e);
                            return;
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.setPriority(9);
            t.start();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void initialise(TRHostTorrentFinder finder) {
        this.config.loadConfig(finder);
    }

    public String getName() {
        return "Azureus";
    }

    public TRHostTorrent hostTorrent(TOTorrent torrent) throws TRHostException {
        return this.hostTorrent(torrent, true);
    }

    public TRHostTorrent hostTorrent(TOTorrent torrent, boolean persistent) throws TRHostException {
        return this.addTorrent(torrent, 2, persistent);
    }

    public TRHostTorrent publishTorrent(TOTorrent torrent) throws TRHostException {
        return this.addTorrent(torrent, 3, true);
    }

    protected TRHostTorrent addTorrent(TOTorrent torrent, int state, boolean persistent) throws TRHostException {
        boolean ssl;
        int port;
        block19: {
            try {
                this.this_mon.enter();
                TRHostTorrent ht = this.lookupHostTorrent(torrent);
                if (ht == null) break block19;
                try {
                    TRHostTorrentHostImpl hti;
                    ht = this.lookupHostTorrentViaHash(torrent.getHash());
                    if (ht instanceof TRHostTorrentHostImpl && (hti = (TRHostTorrentHostImpl)ht).getTorrent() != torrent) {
                        hti.setTorrent(torrent);
                        if (persistent && !hti.isPersistent()) {
                            hti.setPersistent(true);
                        }
                        if (state != 3) {
                            this.startHosting(hti);
                            if (state == 2) {
                                hti.start();
                            }
                        }
                        this.listeners.dispatch(3, ht);
                    }
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
                TRHostTorrent tRHostTorrent = ht;
                this.this_mon.exit();
                return tRHostTorrent;
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
        }
        int protocol = 1;
        if (state == 3) {
            port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
            ssl = false;
        } else {
            String tracker_ip;
            URL announce_url = torrent.getAnnounceURL();
            String protocol_str = announce_url.getProtocol();
            ssl = protocol_str.equalsIgnoreCase("https");
            if (protocol_str.equalsIgnoreCase("udp")) {
                protocol = 2;
            }
            boolean force_external = COConfigurationManager.getBooleanParameter("Tracker Port Force External", false);
            port = announce_url.getPort();
            if (force_external && (tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "")).length() > 0 && !announce_url.getHost().equalsIgnoreCase(tracker_ip)) {
                port = ssl ? COConfigurationManager.getIntParameter("Tracker Port SSL", 7000) : COConfigurationManager.getIntParameter("Tracker Port", 6969);
            }
            if (port == -1) {
                port = ssl ? 443 : 80;
            }
        }
        TRTrackerServer server = this.startServer(protocol, port, ssl);
        TRHostTorrent host_torrent = state == 3 ? new TRHostTorrentPublishImpl(this, torrent) : new TRHostTorrentHostImpl(this, server, torrent, port);
        host_torrent.setPersistent(persistent);
        this.host_torrents.add(host_torrent);
        try {
            this.host_torrent_hash_map.put(new HashWrapper(torrent.getHash()), host_torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        this.host_torrent_map.put(torrent, host_torrent);
        if (state != 3) {
            this.startHosting((TRHostTorrentHostImpl)host_torrent);
            if (state == 2) {
                host_torrent.start();
            }
            if (!persistent) {
                this.config.recoverStats((TRHostTorrentHostImpl)host_torrent);
            }
        }
        this.listeners.dispatch(1, host_torrent);
        this.config.saveConfig();
        TRHostTorrent tRHostTorrent = host_torrent;
        this.this_mon.exit();
        return tRHostTorrent;
    }

    protected TRTrackerServer startServer(int protocol, int port, boolean ssl) throws TRHostException {
        try {
            this.this_mon.enter();
            String key = protocol + ":" + port;
            TRTrackerServer server = (TRTrackerServer)this.server_map.get(key);
            if (server == null) {
                try {
                    server = ssl ? TRTrackerServerFactory.createSSL(protocol, port, true) : TRTrackerServerFactory.create(protocol, port, true);
                    this.server_map.put(key, server);
                    if (this.auth_listeners.size() > 0) {
                        server.addAuthenticationListener(this);
                    }
                    server.addListener(this);
                }
                catch (TRTrackerServerException e) {
                    LGLogger.log(0, 0, 3, "Tracker Host: failed to start server: " + e.toString());
                    throw new TRHostException(e.getMessage());
                }
            }
            TRTrackerServer tRTrackerServer = server;
            this.this_mon.exit();
            return tRTrackerServer;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected TRHostTorrent lookupHostTorrent(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        try {
            return (TRHostTorrent)this.host_torrent_hash_map.get(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected void startHosting(TRHostTorrentHostImpl host_torrent) {
        TOTorrent torrent = host_torrent.getTorrent();
        TRTrackerClient tc = (TRTrackerClient)this.tracker_client_map.get(torrent);
        if (tc != null) {
            this.startHosting(host_torrent, tc);
        }
    }

    protected void startHosting(TRTrackerClient tracker_client) {
        TRHostTorrent host_torrent = (TRHostTorrent)this.host_torrent_map.get(tracker_client.getTorrent());
        if (host_torrent instanceof TRHostTorrentHostImpl) {
            this.startHosting((TRHostTorrentHostImpl)host_torrent, tracker_client);
        }
    }

    protected void startHosting(TRHostTorrentHostImpl host_torrent, final TRTrackerClient tracker_client) {
        final TOTorrent torrent = host_torrent.getTorrent();
        tracker_client.setIPOverride(torrent.getAnnounceURL().getHost());
        TRTrackerClientListener listener = new TRTrackerClientListener(){

            public void receivedTrackerResponse(TRTrackerResponse response) {
                try {
                    TRTrackerScraperFactory.getSingleton().scrape(torrent, true);
                }
                finally {
                    tracker_client.removeListener(this);
                }
            }

            public void urlChanged(String url, boolean explicit) {
            }

            public void urlRefresh() {
            }
        };
        tracker_client.addListener(listener);
        tracker_client.refreshListeners();
    }

    protected void remove(TRHostTorrent host_torrent) {
        try {
            this.this_mon.enter();
            if (!this.host_torrents.contains(host_torrent)) {
                this.this_mon.exit();
                return;
            }
            this.host_torrents.remove(host_torrent);
            TOTorrent torrent = host_torrent.getTorrent();
            try {
                this.host_torrent_hash_map.remove(new HashWrapper(torrent.getHash()));
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
            this.host_torrent_map.remove(torrent);
            if (host_torrent instanceof TRHostTorrentHostImpl) {
                this.stopHosting((TRHostTorrentHostImpl)host_torrent);
            }
            this.listeners.dispatch(2, host_torrent);
            this.config.saveConfig();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void stopHosting(TRHostTorrentHostImpl host_torrent) {
        TOTorrent torrent = host_torrent.getTorrent();
        TRTrackerClient tc = (TRTrackerClient)this.tracker_client_map.get(torrent);
        if (tc != null) {
            this.stopHosting(host_torrent, tc);
        }
    }

    protected void stopHosting(TRTrackerClient tracker_client) {
        TRHostTorrent host_torrent = (TRHostTorrent)this.host_torrent_map.get(tracker_client.getTorrent());
        if (host_torrent instanceof TRHostTorrentHostImpl) {
            this.stopHosting((TRHostTorrentHostImpl)host_torrent, tracker_client);
        }
    }

    protected void stopHosting(final TRHostTorrentHostImpl host_torrent, final TRTrackerClient tracker_client) {
        AEThread thread = new AEThread("StopHosting"){

            public void runSupport() {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    TRHostImpl.this.this_mon.enter();
                    TRHostTorrent ht = TRHostImpl.this.lookupHostTorrent(host_torrent.getTorrent());
                    if (ht == null || ht == host_torrent && ht.getStatus() == 1) {
                        tracker_client.clearIPOverride();
                    }
                }
                finally {
                    TRHostImpl.this.this_mon.exit();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected TRTrackerClient getTrackerClient(TRHostTorrent host_torrent) {
        try {
            this.this_mon.enter();
            TRTrackerClient tRTrackerClient = (TRTrackerClient)this.tracker_client_map.get(host_torrent.getTorrent());
            this.this_mon.exit();
            return tRTrackerClient;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void hostTorrentStateChange(TRHostTorrent host_torrent) {
        try {
            this.this_mon.enter();
            TOTorrent torrent = host_torrent.getTorrent();
            TRTrackerClient tc = (TRTrackerClient)this.tracker_client_map.get(torrent);
            if (tc != null) {
                tc.refreshListeners();
            }
            this.config.saveConfig();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TRHostTorrent[] getTorrents() {
        try {
            this.this_mon.enter();
            TRHostTorrent[] res = new TRHostTorrent[this.host_torrents.size()];
            this.host_torrents.toArray(res);
            TRHostTorrent[] tRHostTorrentArray = res;
            this.this_mon.exit();
            return tRHostTorrentArray;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void clientCreated(TRTrackerClient client) {
        try {
            this.this_mon.enter();
            this.tracker_client_map.put(client.getTorrent(), client);
            this.startHosting(client);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void clientDestroyed(TRTrackerClient client) {
        try {
            this.this_mon.enter();
            this.tracker_client_map.remove(client.getTorrent());
            this.stopHosting(client);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected TRHostTorrent lookupHostTorrentViaHash(byte[] hash) {
        return (TRHostTorrent)this.host_torrent_hash_map.get(new HashWrapper(hash));
    }

    public boolean permitted(byte[] hash, boolean explicit) {
        block4: {
            block5: {
                try {
                    this.this_mon.enter();
                    TRHostTorrent ht = this.lookupHostTorrentViaHash(hash);
                    if (ht == null) break block4;
                    if (explicit || ht.getStatus() == 2) break block5;
                    this.this_mon.exit();
                    return false;
                }
                catch (Throwable throwable) {
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            this.this_mon.exit();
            return true;
        }
        this.addExternalTorrent(hash, 2);
        this.this_mon.exit();
        return true;
    }

    protected void addExternalTorrent(byte[] hash, int state) {
        try {
            this.this_mon.enter();
            if (this.lookupHostTorrentViaHash(hash) != null) {
                this.this_mon.exit();
                return;
            }
            String tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "127.0.0.1");
            int port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
            try {
                TRHostExternalTorrent external_torrent = new TRHostExternalTorrent(hash, new URL("http://" + tracker_ip + ":" + port + "/announce"));
                this.addTorrent(external_torrent, state, true);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean denied(byte[] hash, boolean permitted) {
        return true;
    }

    public boolean handleExternalRequest(String client_address, String url, String header, InputStream is, OutputStream os) throws IOException {
        List listeners_copy = this.listeners.getListenersCopy();
        int i = 0;
        while (i < listeners_copy.size()) {
            TRHostListener listener = (TRHostListener)listeners_copy.get(i);
            if (listener.handleExternalRequest(client_address, url, header, is, os)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TRHostTorrent getHostTorrent(TOTorrent torrent) {
        return this.lookupHostTorrent(torrent);
    }

    public void addListener(TRHostListener l) {
        try {
            this.this_mon.enter();
            this.listeners.addListener(l);
            int i = 0;
            while (i < this.host_torrents.size()) {
                this.listeners.dispatch(l, 1, this.host_torrents.get(i));
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(TRHostListener l) {
        this.listeners.removeListener(l);
    }

    protected void torrentListenerRegistered() {
        try {
            this.this_mon.enter();
            if (!this.server_factory_listener_added) {
                this.server_factory_listener_added = true;
                TRTrackerServerFactory.addListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void serverCreated(TRTrackerServer server) {
        server.addRequestListener(this);
    }

    public void postProcess(TRTrackerServerRequest request2) throws TRTrackerServerException {
        TRTrackerServerTorrent ts_torrent;
        HashWrapper hash_wrapper;
        TRHostTorrent h_torrent;
        if ((request2.getType() == 1 || request2.getType() == 2) && (h_torrent = this.lookupHostTorrentViaHash((hash_wrapper = (ts_torrent = request2.getTorrent()).getHash()).getHash())) != null) {
            TRHostTorrentRequestImpl req = new TRHostTorrentRequestImpl(h_torrent, new TRHostPeerHostImpl(request2.getPeer()), request2);
            try {
                if (h_torrent instanceof TRHostTorrentHostImpl) {
                    ((TRHostTorrentHostImpl)h_torrent).postProcess(req);
                } else {
                    ((TRHostTorrentPublishImpl)h_torrent).postProcess(req);
                }
            }
            catch (TRHostException e) {
                throw new TRTrackerServerException("Post process fails", e);
            }
        }
    }

    public void close() {
        this.config.saveConfig();
    }

    public boolean authenticate(URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                boolean res = ((TRHostAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user, password);
                if (res) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    public byte[] authenticate(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] res = ((TRHostAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    public void addAuthenticationListener(TRHostAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                Iterator it = this.server_map.values().iterator();
                while (it.hasNext()) {
                    ((TRTrackerServer)it.next()).addAuthenticationListener(this);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeAuthenticationListener(TRHostAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                Iterator it = this.server_map.values().iterator();
                while (it.hasNext()) {
                    ((TRTrackerServer)it.next()).removeAuthenticationListener(this);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void startTorrent(TRHostTorrentHostImpl torrent) {
        try {
            this.this_mon.enter();
            torrent.startSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void stopTorrent(TRHostTorrentHostImpl torrent) {
        try {
            this.this_mon.enter();
            torrent.stopSupport();
        }
        finally {
            this.this_mon.exit();
        }
    }
}

