/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.classic;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.peer.PEPeerServer;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientFactoryListener;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerClientClassicImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TRTrackerClientFactoryImpl {
    protected static List listeners = new ArrayList();
    protected static List clients = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerClientFactory");

    public static TRTrackerClient create(TOTorrent torrent, PEPeerServer peer_server) throws TRTrackerClientException {
        TRTrackerClientClassicImpl client = new TRTrackerClientClassicImpl(torrent, peer_server);
        ArrayList listeners_copy = new ArrayList();
        try {
            class_mon.enter();
            clients.add(client);
            listeners_copy = new ArrayList(listeners);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            try {
                ((TRTrackerClientFactoryListener)listeners_copy.get(i)).clientCreated(client);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return client;
    }

    public static void addListener(TRTrackerClientFactoryListener l) {
        ArrayList clients_copy;
        try {
            class_mon.enter();
            listeners.add(l);
            clients_copy = new ArrayList(clients);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < clients_copy.size()) {
            try {
                l.clientCreated((TRTrackerClient)clients_copy.get(i));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public static void removeListener(TRTrackerClientFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    public static void destroy(TRTrackerClient client) {
        ArrayList listeners_copy = new ArrayList();
        try {
            class_mon.enter();
            clients.remove(client);
            listeners_copy = new ArrayList(listeners);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < listeners_copy.size()) {
            try {
                ((TRTrackerClientFactoryListener)listeners_copy.get(i)).clientDestroyed(client);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }
}

