/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;

public class TOTorrentDeserialiseImpl
extends TOTorrentImpl {
    public TOTorrentDeserialiseImpl(File file) throws TOTorrentException {
        if (!file.isFile()) {
            throw new TOTorrentException("TOTorrentDeserialise: Torrent must be a file ('" + file.getName() + "')", 1);
        }
        if (file.length() == 0L) {
            throw new TOTorrentException("TOTorrentDeserialise: Torrent is zero length ('" + file.getName() + "')", 2);
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                this.construct(fis);
            }
            catch (IOException e) {
                throw new TOTorrentException("TOTorrentDeserialise: IO exception reading torrent '" + e.toString() + "'", 4);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public TOTorrentDeserialiseImpl(InputStream is) throws TOTorrentException {
        this.construct(is);
    }

    public TOTorrentDeserialiseImpl(byte[] bytes) throws TOTorrentException {
        this.construct(bytes);
    }

    public TOTorrentDeserialiseImpl(Map map) throws TOTorrentException {
        this.construct(map);
    }

    protected void construct(InputStream is) throws TOTorrentException {
        ByteArrayOutputStream metaInfo = new ByteArrayOutputStream();
        try {
            int nbRead;
            byte[] buf = new byte[32768];
            int iFirstByte = is.read();
            if (iFirstByte != 100 && iFirstByte != 101 && iFirstByte != 105 && (iFirstByte < 48 || iFirstByte > 57)) {
                block8: {
                    try {
                        int nbRead2;
                        metaInfo.write(iFirstByte);
                        while ((nbRead2 = is.read(buf)) > 0 && metaInfo.size() < 32000) {
                            metaInfo.write(buf, 0, nbRead2);
                        }
                        String char_data = new String(metaInfo.toByteArray()).toLowerCase();
                        if (char_data.indexOf("html") != -1) {
                            throw new TOTorrentException("Contents maybe HTML", 6);
                        }
                    }
                    catch (Throwable e) {
                        if (!(e instanceof TOTorrentException)) break block8;
                        throw (TOTorrentException)e;
                    }
                }
                throw new TOTorrentException("Contents invalid - bad header", 6);
            }
            metaInfo.write(iFirstByte);
            while ((nbRead = is.read(buf)) > 0) {
                metaInfo.write(buf, 0, nbRead);
            }
        }
        catch (IOException e) {
            throw new TOTorrentException("TOTorrentDeserialise: IO exception reading torrent '" + e.toString() + "'", 4);
        }
        this.construct(metaInfo.toByteArray());
    }

    protected void construct(byte[] bytes) throws TOTorrentException {
        try {
            Map meta_data = BDecoder.decode(bytes);
            this.construct(meta_data);
        }
        catch (IOException e) {
            throw new TOTorrentException("IO Error: " + e.getMessage(), 6);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void construct(Map meta_data) throws TOTorrentException {
        try {
            Map info;
            String announce_url = null;
            boolean got_announce = false;
            boolean got_announce_list = false;
            boolean bad_announce = false;
            Iterator root_it = meta_data.keySet().iterator();
            while (root_it.hasNext()) {
                String key = (String)root_it.next();
                if (key.equalsIgnoreCase("announce")) {
                    got_announce = true;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    announce_url = announce_url.replaceAll(" ", "");
                    try {
                        this.setAnnounceURL(new URL(announce_url));
                    }
                    catch (MalformedURLException e) {
                        if (announce_url.indexOf("://") == -1) {
                            announce_url = "http:/" + (announce_url.startsWith("/") ? "" : "/") + announce_url;
                        }
                        try {
                            this.setAnnounceURL(new URL(announce_url));
                        }
                        catch (MalformedURLException f) {
                            bad_announce = true;
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("announce-list")) {
                    got_announce_list = true;
                    List announce_list = (List)meta_data.get("announce-list");
                    if (announce_list == null || announce_list.size() <= 0) continue;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    announce_url = announce_url.replaceAll(" ", "");
                    boolean announce_url_found = false;
                    int i = 0;
                    while (i < announce_list.size()) {
                        List set = (List)announce_list.get(i);
                        Vector<URL> urls = new Vector<URL>();
                        int j = 0;
                        while (j < set.size()) {
                            String url_str = this.readStringFromMetaData((byte[])set.get(j));
                            url_str = url_str.replaceAll(" ", "");
                            try {
                                urls.add(new URL(url_str));
                                if (url_str.equalsIgnoreCase(announce_url)) {
                                    announce_url_found = true;
                                }
                            }
                            catch (MalformedURLException e) {
                                if (url_str.indexOf("://") == -1) {
                                    url_str = "http:/" + (url_str.startsWith("/") ? "" : "/") + url_str;
                                }
                                try {
                                    urls.add(new URL(url_str));
                                    if (url_str.equalsIgnoreCase(announce_url)) {
                                        announce_url_found = true;
                                    }
                                }
                                catch (MalformedURLException f) {
                                    Debug.printStackTrace(f);
                                }
                            }
                            ++j;
                        }
                        if (urls.size() > 0) {
                            Object[] url_array = new URL[urls.size()];
                            urls.copyInto(url_array);
                            this.addTorrentAnnounceURLSet((URL[])url_array);
                        }
                        ++i;
                    }
                    if (announce_url_found || announce_url.length() <= 0) continue;
                    try {
                        Vector<URL> urls = new Vector<URL>();
                        urls.add(new URL(announce_url));
                        Object[] url_array = new URL[urls.size()];
                        urls.copyInto(url_array);
                        this.addTorrentAnnounceURLSet((URL[])url_array);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("comment")) {
                    this.setComment((byte[])meta_data.get("comment"));
                    continue;
                }
                if (key.equalsIgnoreCase("created by")) {
                    this.setCreatedBy((byte[])meta_data.get("created by"));
                    continue;
                }
                if (key.equalsIgnoreCase("creation date")) {
                    try {
                        Long creation_date = (Long)meta_data.get("creation date");
                        if (creation_date == null) continue;
                        this.setCreationDate(creation_date);
                    }
                    catch (Exception e) {
                        System.out.println("TOTorrentDeserialise: creation_date extraction fails, ignoring");
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("info")) continue;
                Object prop = meta_data.get(key);
                if (prop instanceof byte[]) {
                    this.setAdditionalByteArrayProperty(key, (byte[])prop);
                    continue;
                }
                if (prop instanceof Long) {
                    this.setAdditionalLongProperty(key, (Long)prop);
                    continue;
                }
                if (prop instanceof List) {
                    this.setAdditionalListProperty(key, (List)prop);
                    continue;
                }
                this.setAdditionalMapProperty(key, (Map)prop);
            }
            if (bad_announce) {
                if (!got_announce_list) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + announce_url + "'", 6);
                TOTorrentAnnounceURLSet[] sets = this.getAnnounceURLGroup().getAnnounceURLSets();
                if (sets.length <= 0) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + announce_url + "' and no usable announce list", 6);
                this.setAnnounceURL(sets[0].getAnnounceURLs()[0]);
            }
            if ((info = (Map)meta_data.get("info")) == null) {
                throw new TOTorrentException("Decode fails, 'info' element not found'", 6);
            }
            this.setName((byte[])info.get("name"));
            this.setHashFromInfo(info);
            Long simple_file_length = (Long)info.get("length");
            if (simple_file_length != null) {
                this.setSimpleTorrent(true);
                this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)this, (long)simple_file_length, new byte[][]{this.getName()})});
            } else {
                this.setSimpleTorrent(false);
                List meta_files = (List)info.get("files");
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[meta_files.size()];
                int i = 0;
                while (i < files.length) {
                    Map file_map = (Map)meta_files.get(i);
                    long len = (Long)file_map.get("length");
                    List paths = (List)file_map.get("path");
                    byte[][] path_comps = new byte[paths.size()][];
                    int j = 0;
                    while (j < paths.size()) {
                        path_comps[j] = (byte[])paths.get(j);
                        ++j;
                    }
                    TOTorrentFileImpl file = files[i] = new TOTorrentFileImpl((TOTorrent)this, len, path_comps);
                    Iterator file_it = file_map.keySet().iterator();
                    while (file_it.hasNext()) {
                        String key = (String)file_it.next();
                        if (key.equals("length") || key.equals("path")) continue;
                        file.setAdditionalProperty(key, file_map.get(key));
                    }
                    ++i;
                }
                this.setFiles(files);
            }
            this.setPieceLength((Long)info.get("piece length"));
            byte[] flat_pieces = (byte[])info.get("pieces");
            byte[][] pieces = new byte[flat_pieces.length / 20][20];
            int i = 0;
            while (i < pieces.length) {
                System.arraycopy(flat_pieces, i * 20, pieces[i], 0, 20);
                ++i;
            }
            this.setPieces(pieces);
            Iterator info_it = info.keySet().iterator();
            while (info_it.hasNext()) {
                String key = (String)info_it.next();
                if (key.equals("name") || key.equals("length") || key.equals("files") || key.equals("piece length") || key.equals("pieces")) continue;
                this.addAdditionalInfoProperty(key, info.get(key));
            }
            return;
        }
        catch (Throwable e) {
            if (!(e instanceof TOTorrentException)) throw new TOTorrentException("Decode fails '" + e.toString() + "'", 6);
            throw (TOTorrentException)e;
        }
    }

    public void printMap() {
        try {
            this.print("", "root", this.serialiseToMap());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void print(String indent, String name, Map map) {
        System.out.println(String.valueOf(indent) + name + "{map}");
        Set keys = map.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = map.get(key);
            if (value instanceof Map) {
                this.print(String.valueOf(indent) + "  ", key, (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.print(String.valueOf(indent) + "  ", key, (List)value);
                continue;
            }
            if (value instanceof Long) {
                this.print(String.valueOf(indent) + "  ", key, (Long)value);
                continue;
            }
            this.print(String.valueOf(indent) + "  ", key, (byte[])value);
        }
    }

    protected void print(String indent, String name, List list) {
        System.out.println(String.valueOf(indent) + name + "{list}");
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Map) {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (Map)value);
            } else if (value instanceof List) {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (List)value);
            } else if (value instanceof Long) {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (Long)value);
            } else {
                this.print(String.valueOf(indent) + "  ", "[" + index + "]", (byte[])value);
            }
            ++index;
        }
    }

    protected void print(String indent, String name, Long value) {
        System.out.println(String.valueOf(indent) + name + "{long} = " + value);
    }

    protected void print(String indent, String name, byte[] value) {
        String x = new String(value);
        boolean print = true;
        int i = 0;
        while (i < x.length()) {
            char c = x.charAt(i);
            if (c >= '\u0080') {
                print = false;
                break;
            }
            ++i;
        }
        if (print) {
            System.out.println(String.valueOf(indent) + name + "{byte[]} = " + x);
        } else {
            System.out.println(String.valueOf(indent) + name + "{byte[], length " + value.length + "}");
        }
    }
}

