/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport;

import com.aelitis.azureus.core.networkmanager.Connection;
import com.aelitis.azureus.core.networkmanager.ConnectionOwner;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.TransportDebugger;
import com.aelitis.azureus.core.networkmanager.TransportOwner;
import com.aelitis.azureus.core.peermanager.UploadManager;
import com.aelitis.azureus.core.peermanager.messages.ProtocolMessage;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTKeepAlive;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTRequest;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTUninterested;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTHaveMessageAggregator;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandler;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportDataReader;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocolState;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.IPToHostNameResolverRequest;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class PEPeerTransportProtocol
implements PEPeerTransport,
ConnectionOwner {
    public static final byte BT_CHOKED = 0;
    public static final byte BT_UNCHOKED = 1;
    public static final byte BT_INTERESTED = 2;
    public static final byte BT_UNINTERESTED = 3;
    public static final byte BT_HAVE = 4;
    public static final byte BT_BITFIELD = 5;
    public static final byte BT_REQUEST = 6;
    public static final byte BT_PIECE = 7;
    public static final byte BT_CANCEL = 8;
    private PEPeerControl manager;
    private byte[] id;
    private String ip;
    private String ip_resolved;
    private IPToHostNameResolverRequest ip_resolver_request;
    private int port;
    private PEPeerStatsImpl stats;
    private List requested = new ArrayList();
    private AEMonitor requested_mon = new AEMonitor("PEPeerTransportProtocol:Req");
    private HashMap data;
    private boolean choked_by_other_peer = true;
    private boolean choking_other_peer = true;
    private boolean interested_in_other_peer = false;
    private boolean other_peer_interested_in_me = false;
    private boolean snubbed = false;
    private boolean[] other_peer_has_pieces;
    private boolean seed = false;
    private boolean connection_registered = false;
    private boolean incoming;
    private volatile boolean closing = false;
    private PEPeerTransportProtocolState currentState;
    private Connection connection;
    private OutgoingBTPieceMessageHandler outgoing_piece_message_handler;
    private OutgoingBTHaveMessageAggregator outgoing_have_message_aggregator;
    private boolean identityAdded = false;
    private int connection_state = 0;
    private String client = "";
    private int processLoop;
    private boolean readyToRequest;
    private int nbBadChunks;
    private int uniquePiece;
    private int spreadTimeHint = 0;
    public static final int componentID = 1;
    public static final int evtProtocol = 0;
    public static final int evtLifeCycle = 1;
    public static final int evtErrors = 2;
    private int readSleepTime;
    private long lastReadTime;
    private long last_message_sent_time = 0L;
    private long last_message_received_time = 0L;
    private long last_data_message_received_time = 0L;
    private long connection_established_time = 0L;
    protected AEMonitor this_mon = new AEMonitor("PEPeerTransportProtocol");
    private final Map recent_outgoing_requests = new LinkedHashMap(100, 0.75f, true){

        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    };
    private AEMonitor recent_outgoing_requests_mon = new AEMonitor("PEPeerTransportProtocol:ROR");
    private static final boolean SHOW_DISCARD_RATE_STATS;
    private static int requests_discarded;
    private static int requests_recovered;
    private static int requests_completed;
    private static final boolean socks_peer_proxy_enable;
    private static final String socks_version;
    private static final String socks_host;
    private static int socks_port;
    private static final String socks_user;
    private static final String socks_password;

    static {
        String prop = System.getProperty("show.discard.rate.stats");
        SHOW_DISCARD_RATE_STATS = prop != null && prop.equals("1");
        requests_discarded = 0;
        requests_recovered = 0;
        requests_completed = 0;
        socks_peer_proxy_enable = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable", false);
        socks_version = COConfigurationManager.getStringParameter("Proxy.Data.SOCKS.version");
        boolean socks_same = COConfigurationManager.getBooleanParameter("Proxy.Data.Same", true);
        socks_host = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Host" : "Proxy.Data.Host");
        String socks_port_str = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Port" : "Proxy.Data.Port");
        if (socks_peer_proxy_enable) {
            try {
                socks_port = Integer.parseInt(socks_port_str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        } else {
            socks_port = 0;
        }
        socks_user = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Username" : "Proxy.Data.Username");
        socks_password = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Password" : "Proxy.Data.Password");
    }

    public PEPeerTransportProtocol(PEPeerControl _manager, String _ip, int _port, boolean _incoming_connection, SocketChannel channel, final byte[] data_already_read) {
        this.manager = _manager;
        this.ip = _ip;
        this.port = _port;
        this.uniquePiece = -1;
        this.incoming = _incoming_connection;
        this.stats = (PEPeerStatsImpl)this.manager.createPeerStats();
        if (this.incoming) {
            this.connection = NetworkManager.getSingleton().createNewInboundConnection(this, channel);
            this.connection.connect(new Connection.ConnectionListener(){

                public void connectStarted() {
                    PEPeerTransportProtocol.this.connection_state = 1;
                }

                public void connectSuccess() {
                    LGLogger.log(1, 1, 1, "Established incoming connection from " + PEPeerTransportProtocol.this);
                    PEPeerTransportProtocol.this.currentState = new StateHandshaking(false, data_already_read);
                }

                public void connectFailure(Throwable failure_msg) {
                    Debug.out("ERROR: incoming connect failure: ", failure_msg);
                    PEPeerTransportProtocol.this.closeAll("ERROR: incoming connect failure [" + PEPeerTransportProtocol.this + "] : " + failure_msg.getMessage(), true, false);
                }

                public void exceptionThrown(Throwable error) {
                    PEPeerTransportProtocol.this.closeAll("Connection [" + PEPeerTransportProtocol.this + "] exception : " + error.getMessage(), true, true);
                }
            });
        } else {
            this.currentState = new StateConnecting();
        }
    }

    private void allocateAll() {
        try {
            this.this_mon.enter();
            if (this.closing) {
                this.this_mon.exit();
                return;
            }
            this.other_peer_has_pieces = new boolean[this.manager.getPiecesNumber()];
            Arrays.fill(this.other_peer_has_pieces, false);
            this.outgoing_piece_message_handler = new OutgoingBTPieceMessageHandler(this.manager.getDiskManager(), this.connection.getOutgoingMessageQueue());
            this.outgoing_have_message_aggregator = new OutgoingBTHaveMessageAggregator(this.connection.getOutgoingMessageQueue());
            this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

                public void messageAdded(ProtocolMessage message) {
                }

                public void messageRemoved(ProtocolMessage message) {
                }

                public void messageSent(ProtocolMessage message) {
                    PEPeerTransportProtocol.this.last_message_sent_time = SystemTime.getCurrentTime();
                }

                public void protocolBytesSent(int byte_count) {
                    PEPeerTransportProtocol.this.stats.protocol_sent(byte_count);
                    PEPeerTransportProtocol.this.manager.protocol_sent(byte_count);
                }

                public void dataBytesSent(int byte_count) {
                    PEPeerTransportProtocol.this.stats.sent(byte_count);
                    PEPeerTransportProtocol.this.manager.sent(byte_count);
                }
            });
            UploadManager.getSingleton().registerStandardPeerConnection(this.connection, this.manager.getUploadLimitedRateGroup());
            this.connection_registered = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void closeAll(String reason, boolean closedOnError, boolean attemptReconnect) {
        try {
            this.this_mon.enter();
            if (this.closing) {
                this.this_mon.exit();
                return;
            }
            this.closing = true;
        }
        finally {
            this.this_mon.exit();
        }
        this.currentState = new StateClosing();
        LGLogger.log(1, 0, closedOnError ? 3 : 0, reason);
        this.cancelRequests();
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.removeAllPieceRequests();
            this.outgoing_piece_message_handler.destroy();
        }
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.destroy();
        }
        if (this.connection != null) {
            if (this.connection_registered) {
                UploadManager.getSingleton().cancelStandardPeerConnection(this.connection);
            }
            this.connection.close();
        }
        try {
            this.recent_outgoing_requests_mon.enter();
            this.recent_outgoing_requests.clear();
        }
        finally {
            this.recent_outgoing_requests_mon.exit();
        }
        if (this.ip_resolver_request != null) {
            this.ip_resolver_request.cancel();
        }
        if (this.id != null && this.identityAdded) {
            PeerIdentityManager.removeIdentity(this.manager.getPeerIdentityDataID(), this.id);
        }
        LGLogger.log(1, 1, 0, "Connection Ended with " + this.toString());
        if (attemptReconnect && !this.incoming) {
            LGLogger.log(1, 1, 0, "Attempting to reconnect with " + this.toString());
            this.manager.peerConnectionClosed(this, true);
        } else {
            this.manager.peerConnectionClosed(this, false);
        }
    }

    protected void handleHandShakeResponse(DirectByteBuffer handshake_data) {
        handshake_data.position((byte)9, 0);
        byte b = handshake_data.get((byte)9);
        if (b != (byte)"BitTorrent protocol".length()) {
            this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but handshake starts with wrong byte : " + b, true, true);
            handshake_data.returnToPool();
            return;
        }
        byte[] protocol = "BitTorrent protocol".getBytes();
        if (handshake_data.remaining((byte)9) < protocol.length) {
            this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but handshake is of wrong size : " + handshake_data.remaining((byte)9), true, true);
            handshake_data.returnToPool();
            return;
        }
        handshake_data.get((byte)9, protocol);
        if (!new String(protocol).equals("BitTorrent protocol")) {
            this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but protocol is wrong : " + new String(protocol), true, false);
            handshake_data.returnToPool();
            return;
        }
        byte[] reserved = new byte[8];
        if (handshake_data.remaining((byte)9) < reserved.length) {
            this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but handshake is of wrong size(2) : " + handshake_data.remaining((byte)9), true, true);
            handshake_data.returnToPool();
            return;
        }
        handshake_data.get((byte)9, reserved);
        PeerIdentityDataID my_peer_data_id = this.manager.getPeerIdentityDataID();
        byte[] hash = this.manager.getHash();
        byte[] otherHash = new byte[20];
        if (handshake_data.remaining((byte)9) < otherHash.length) {
            this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but handshake is of wrong size(3) : " + handshake_data.remaining((byte)9), true, true);
            handshake_data.returnToPool();
            return;
        }
        handshake_data.get((byte)9, otherHash);
        int i = 0;
        while (i < 20) {
            if (otherHash[i] != hash[i]) {
                this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but infohash is wrong", true, false);
                handshake_data.returnToPool();
                return;
            }
            ++i;
        }
        byte[] otherPeerId = new byte[20];
        if (handshake_data.remaining((byte)9) < otherPeerId.length) {
            this.closeAll(String.valueOf(this.toString()) + " has sent handshake, but handshake is of wrong size(4) : " + handshake_data.remaining((byte)9), true, true);
            handshake_data.returnToPool();
            return;
        }
        handshake_data.get((byte)9, otherPeerId);
        this.id = otherPeerId;
        this.client = PeerClassifier.getClientDescription(otherPeerId);
        if (!PeerClassifier.isClientTypeAllowed(this.client)) {
            this.closeAll(String.valueOf(this.toString()) + ": " + this.client + " client type not allowed to connect, banned", false, false);
            handshake_data.returnToPool();
            return;
        }
        if (Arrays.equals(this.manager.getPeerId(), otherPeerId)) {
            this.closeAll(String.valueOf(this.toString()) + ": peerID matches myself", false, false);
            handshake_data.returnToPool();
            return;
        }
        boolean sameIdentity = PeerIdentityManager.containsIdentity(my_peer_data_id, otherPeerId);
        boolean sameIP = false;
        if (!COConfigurationManager.getBooleanParameter("Allow Same IP Peers") && PeerIdentityManager.containsIPAddress(my_peer_data_id, this.ip)) {
            sameIP = true;
        }
        if (sameIdentity) {
            this.closeAll(String.valueOf(this.toString()) + " exchanged handshake, but peer matches pre-existing identity", false, false);
            handshake_data.returnToPool();
            return;
        }
        if (sameIP) {
            this.closeAll(String.valueOf(this.toString()) + " exchanged handshake, but peer matches pre-existing IP address", false, false);
            handshake_data.returnToPool();
            return;
        }
        int maxAllowed = PeerUtils.numNewConnectionsAllowed(my_peer_data_id);
        if (maxAllowed == 0) {
            this.closeAll(String.valueOf(this.toString()) + ": Too many existing peer connections", false, false);
            handshake_data.returnToPool();
            return;
        }
        PeerIdentityManager.addIdentity(my_peer_data_id, otherPeerId, this.ip);
        this.identityAdded = true;
        LGLogger.log(1, 1, 1, String.valueOf(this.toString()) + " has sent their handshake");
        this.sendBitField();
        handshake_data.returnToPool();
        this.connection_state = 3;
        this.last_data_message_received_time = SystemTime.getCurrentTime();
        this.currentState = new StateTransfering();
    }

    public int processRead() {
        try {
            this.processLoop = 0;
            if (this.currentState != null) {
                return this.currentState.process();
            }
            return 20;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.closeAll(String.valueOf(this.toString()) + " : Exception in process : " + e, true, false);
            return 20;
        }
    }

    public int getState() {
        if (this.currentState != null) {
            return this.currentState.getState();
        }
        return 0;
    }

    public int getPercentDoneInThousandNotation() {
        if (this.other_peer_has_pieces == null) {
            return 0;
        }
        int sum = 0;
        int i = 0;
        while (i < this.other_peer_has_pieces.length) {
            if (this.other_peer_has_pieces[i]) {
                ++sum;
            }
            ++i;
        }
        sum = sum * 1000 / this.other_peer_has_pieces.length;
        return sum;
    }

    public boolean transferAvailable() {
        return !this.choked_by_other_peer && this.interested_in_other_peer;
    }

    /*
     * Unable to fully structure code
     */
    private boolean analyzeIncomingMessage(DirectByteBuffer message_buff) {
        if (this.getState() == 40) {
            return false;
        }
        logging_is_on = LGLogger.isLoggingOn();
        message_buff.position((byte)9, 0);
        this.connection_state = 4;
        this.last_message_received_time = SystemTime.getCurrentTime();
        cmd = message_buff.get((byte)9);
        switch (cmd) {
            case 0: {
                if (message_buff.limit((byte)9) != 1) {
                    this.closeAll(String.valueOf(this.toString()) + " choking received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " is choking you");
                }
                this.choked_by_other_peer = true;
                this.cancelRequests();
                message_buff.returnToPool();
                return true;
            }
            case 1: {
                if (message_buff.limit((byte)9) != 1) {
                    this.closeAll(String.valueOf(this.toString()) + " unchoking received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " is unchoking you");
                }
                this.choked_by_other_peer = false;
                message_buff.returnToPool();
                return true;
            }
            case 2: {
                if (message_buff.limit((byte)9) != 1) {
                    this.closeAll(String.valueOf(this.toString()) + " interested received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " is interested");
                }
                this.other_peer_interested_in_me = true;
                message_buff.returnToPool();
                return true;
            }
            case 3: {
                if (message_buff.limit((byte)9) != 1) {
                    this.closeAll(String.valueOf(this.toString()) + " uninterested received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " is not interested");
                }
                this.other_peer_interested_in_me = false;
                if (this.outgoing_have_message_aggregator != null) {
                    this.outgoing_have_message_aggregator.forceSendOfPending();
                }
                message_buff.returnToPool();
                return true;
            }
            case 4: {
                if (message_buff.limit((byte)9) != 5) {
                    this.closeAll(String.valueOf(this.toString()) + " have received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                pieceNumber = message_buff.getInt((byte)9);
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " has " + pieceNumber);
                }
                this.have(pieceNumber);
                message_buff.returnToPool();
                return true;
            }
            case 5: {
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " has sent BitField");
                }
                this.setBitField(message_buff);
                this.checkInterested();
                this.checkSeed();
                message_buff.returnToPool();
                return true;
            }
            case 6: {
                if (message_buff.limit((byte)9) != 13) {
                    this.closeAll(String.valueOf(this.toString()) + " request received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                pieceNumber = message_buff.getInt((byte)9);
                pieceOffset = message_buff.getInt((byte)9);
                pieceLength = message_buff.getInt((byte)9);
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " has requested #" + pieceNumber + ":" + pieceOffset + "->" + (pieceOffset + pieceLength - 1));
                }
                if (this.manager.checkBlock(pieceNumber, pieceOffset, pieceLength)) {
                    if (!this.choking_other_peer) {
                        this.outgoing_piece_message_handler.addPieceRequest(pieceNumber, pieceOffset, pieceLength);
                    } else {
                        LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " has requested #" + pieceNumber + ":" + pieceOffset + "->" + (pieceOffset + pieceLength) + " but peer is currently choked. Request dropped");
                    }
                } else {
                    this.closeAll(String.valueOf(this.toString()) + " has requested #" + pieceNumber + ":" + pieceOffset + "->" + (pieceOffset + pieceLength) + " which is an invalid request.", true, true);
                    message_buff.returnToPool();
                    return false;
                }
                message_buff.returnToPool();
                return true;
            }
            case 7: {
                this.last_data_message_received_time = SystemTime.getCurrentTime();
                if (message_buff.limit((byte)9) < 9) {
                    this.closeAll(String.valueOf(this.toString()) + " piece block received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                pieceNumber = message_buff.getInt((byte)9);
                pieceOffset = message_buff.getInt((byte)9);
                pieceLength = message_buff.limit((byte)9) - message_buff.position((byte)9);
                msg = "";
                if (logging_is_on) {
                    msg = String.valueOf(msg) + this.toString() + " has sent #" + pieceNumber + ": " + pieceOffset + "->" + (pieceOffset + pieceLength - 1);
                }
                request = this.manager.createDiskManagerRequest(pieceNumber, pieceOffset, pieceLength);
                if (!this.manager.checkBlock(pieceNumber, pieceOffset, message_buff)) ** GOTO lbl149
                if (!this.alreadyRequested(request)) ** GOTO lbl118
                this.removeRequest(request);
                this.setSnubbed(false);
                this.reSetRequestsTime();
                if (this.manager.isBlockAlreadyWritten(pieceNumber, pieceOffset)) {
                    msg = this.manager.isInEndGameMode() != false ? String.valueOf(msg) + ", but piece block ignored as already written in end-game mode" : String.valueOf(msg) + ", but piece block ignored as already written";
                    message_buff.returnToPool();
                } else {
                    this.manager.received(pieceLength);
                    this.manager.writeBlock(pieceNumber, pieceOffset, message_buff, this);
                    ++PEPeerTransportProtocol.requests_completed;
                }
                ** GOTO lbl155
lbl118:
                // 1 sources

                if (this.manager.isBlockAlreadyWritten(pieceNumber, pieceOffset)) ** GOTO lbl142
                try {
                    this.recent_outgoing_requests_mon.enter();
                    ever_requested = this.recent_outgoing_requests.containsKey(request);
                }
                finally {
                    this.recent_outgoing_requests_mon.exit();
                }
                if (ever_requested) {
                    msg = String.valueOf(msg) + ", piece block data recovered as useful";
                    this.manager.received(pieceLength);
                    this.setSnubbed(false);
                    this.reSetRequestsTime();
                    this.manager.writeBlockAndCancelOutstanding(pieceNumber, pieceOffset, message_buff, this);
                    ++PEPeerTransportProtocol.requests_recovered;
                    this.printRequestStats();
                } else {
                    msg = String.valueOf(msg) + ", but piece block discarded as never requested";
                    this.stats.discarded(pieceLength);
                    this.manager.discarded(pieceLength);
                    message_buff.returnToPool();
                    ++PEPeerTransportProtocol.requests_discarded;
                    this.printRequestStats();
                }
                ** GOTO lbl155
lbl142:
                // 1 sources

                msg = String.valueOf(msg) + ", but piece block discarded as already written";
                this.stats.discarded(pieceLength);
                this.manager.discarded(pieceLength);
                message_buff.returnToPool();
                ++PEPeerTransportProtocol.requests_discarded;
                this.printRequestStats();
                ** GOTO lbl155
lbl149:
                // 1 sources

                msg = String.valueOf(msg) + ", but piece block discarded as invalid";
                this.stats.discarded(pieceLength);
                this.manager.discarded(pieceLength);
                message_buff.returnToPool();
                ++PEPeerTransportProtocol.requests_discarded;
                this.printRequestStats();
lbl155:
                // 6 sources

                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, msg);
                }
                return true;
            }
            case 8: {
                if (message_buff.limit((byte)9) != 13) {
                    this.closeAll(String.valueOf(this.toString()) + " cancel received, but message of wrong size : " + message_buff.limit((byte)9), true, true);
                    message_buff.returnToPool();
                    return false;
                }
                pieceNumber = message_buff.getInt((byte)9);
                pieceOffset = message_buff.getInt((byte)9);
                pieceLength = message_buff.getInt((byte)9);
                if (logging_is_on) {
                    LGLogger.log(1, 0, 1, String.valueOf(this.toString()) + " has canceled #" + pieceNumber + ":" + pieceOffset + "->" + (pieceOffset + pieceLength - 1));
                }
                this.outgoing_piece_message_handler.removePieceRequest(pieceNumber, pieceOffset, pieceLength);
                message_buff.returnToPool();
                return true;
            }
        }
        Debug.out(String.valueOf(this.toString()) + " has sent an unknown protocol message id: " + cmd);
        this.closeAll(String.valueOf(this.toString()) + " has sent a wrong message " + cmd, true, true);
        message_buff.returnToPool();
        return false;
    }

    private void printRequestStats() {
        if (SHOW_DISCARD_RATE_STATS) {
            float discard_percentage = (float)requests_discarded * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded) * 1.0f);
            float recover_percentage = (float)requests_recovered * 100.0f / ((float)(requests_recovered + requests_discarded) * 1.0f);
            System.out.println("c=" + requests_completed + " d=" + requests_discarded + " r=" + requests_recovered + " dp=" + discard_percentage + "% rp=" + recover_percentage + "%");
        }
    }

    private void have(int pieceNumber) {
        if (pieceNumber >= this.other_peer_has_pieces.length || pieceNumber < 0) {
            this.closeAll(String.valueOf(this.toString()) + " gave invalid pieceNumber:" + pieceNumber, true, true);
        } else {
            this.other_peer_has_pieces[pieceNumber] = true;
            int pieceLength = this.manager.getPieceLength(pieceNumber);
            this.stats.haveNewPiece(pieceLength);
            this.manager.havePiece(pieceNumber, pieceLength, this);
            if (!this.interested_in_other_peer) {
                this.checkInterested(pieceNumber);
            }
            this.checkSeed();
        }
    }

    private void checkSeed() {
        int i = 0;
        while (i < this.other_peer_has_pieces.length) {
            if (!this.other_peer_has_pieces[i]) {
                return;
            }
            ++i;
        }
        this.seed = true;
    }

    public boolean request(int pieceNumber, int pieceOffset, int pieceLength) {
        if (this.getState() != 30) {
            this.manager.requestCanceled(this.manager.createDiskManagerRequest(pieceNumber, pieceOffset, pieceLength));
            return false;
        }
        DiskManagerReadRequest request2 = this.manager.createDiskManagerRequest(pieceNumber, pieceOffset, pieceLength);
        if (!this.alreadyRequested(request2)) {
            this.addRequest(request2);
            try {
                this.recent_outgoing_requests_mon.enter();
                this.recent_outgoing_requests.put(request2, null);
            }
            finally {
                this.recent_outgoing_requests_mon.exit();
            }
            this.connection.getOutgoingMessageQueue().addMessage(new BTRequest(pieceNumber, pieceOffset, pieceLength), false);
            return true;
        }
        return false;
    }

    public void sendCancel(DiskManagerReadRequest request2) {
        if (this.getState() != 30) {
            return;
        }
        if (this.alreadyRequested(request2)) {
            this.removeRequest(request2);
            this.connection.getOutgoingMessageQueue().addMessage(new BTCancel(request2.getPieceNumber(), request2.getOffset(), request2.getLength()), false);
        }
    }

    public void sendHave(int pieceNumber) {
        if (this.getState() != 30) {
            return;
        }
        boolean force = !this.other_peer_has_pieces[pieceNumber] && !this.other_peer_interested_in_me;
        this.outgoing_have_message_aggregator.queueHaveMessage(pieceNumber, force);
        this.checkInterested();
    }

    public void sendChoke() {
        if (this.getState() != 30) {
            return;
        }
        this.outgoing_piece_message_handler.removeAllPieceRequests();
        this.connection.getOutgoingMessageQueue().addMessage(new BTChoke(), false);
        this.choking_other_peer = true;
    }

    public void sendUnChoke() {
        if (this.getState() != 30) {
            return;
        }
        this.connection.getOutgoingMessageQueue().addMessage(new BTUnchoke(), false);
        this.choking_other_peer = false;
    }

    private void sendKeepAlive() {
        if (this.getState() != 30) {
            return;
        }
        this.connection.getOutgoingMessageQueue().addMessage(new BTKeepAlive(), false);
    }

    private void setBitField(DirectByteBuffer buffer) {
        byte[] dataf = new byte[(this.manager.getPiecesNumber() + 7) / 8];
        if (buffer.remaining((byte)9) < dataf.length) {
            LGLogger.log(1, 0, 3, String.valueOf(this.toString()) + " has sent invalid BitField: too short");
            return;
        }
        buffer.get((byte)9, dataf);
        int i = 0;
        while (i < this.other_peer_has_pieces.length) {
            int index = i / 8;
            byte bData = dataf[index];
            int bit = 7 - i % 8;
            byte b = (byte)(bData >> bit);
            if ((b & 1) == 1) {
                this.other_peer_has_pieces[i] = true;
                this.manager.updateSuperSeedPiece(this, i);
            } else {
                this.other_peer_has_pieces[i] = false;
            }
            ++i;
        }
    }

    private void checkInterested() {
        if (this.getState() == 40) {
            return;
        }
        boolean newInterested = false;
        DiskManagerPiece[] pieces = this.manager.getDiskManager().getPieces();
        int i = 0;
        while (i < pieces.length) {
            if (!pieces[i].getDone() && this.other_peer_has_pieces[i]) {
                newInterested = true;
                break;
            }
            ++i;
        }
        if (newInterested && !this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(), false);
        } else if (!newInterested && this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTUninterested(), false);
        }
        this.interested_in_other_peer = newInterested;
    }

    private void checkInterested(int pieceNumber) {
        boolean newInterested;
        if (this.getState() == 40) {
            return;
        }
        DiskManagerPiece[] pieces = this.manager.getDiskManager().getPieces();
        boolean bl = newInterested = !pieces[pieceNumber].getDone();
        if (newInterested && !this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(), false);
        } else if (!newInterested && this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTUninterested(), false);
        }
        this.interested_in_other_peer = newInterested;
    }

    private void sendBitField() {
        if (this.getState() == 40) {
            return;
        }
        if (this.manager.isSuperSeedMode()) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate((this.manager.getPiecesNumber() + 7) / 8);
        boolean atLeastOne = false;
        DiskManagerPiece[] pieces = this.manager.getDiskManager().getPieces();
        int bToSend = 0;
        int i = 0;
        while (i < pieces.length) {
            if (i % 8 == 0) {
                bToSend = 0;
            }
            bToSend <<= 1;
            if (pieces[i].getDone()) {
                ++bToSend;
                atLeastOne = true;
            }
            if (i % 8 == 7) {
                buffer.put((byte)bToSend);
            }
            ++i;
        }
        if (i % 8 != 0) {
            buffer.put((byte)(bToSend <<= 8 - i % 8));
        }
        if (atLeastOne) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTBitfield(buffer), false);
        }
    }

    public byte[] getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getClient() {
        return this.client;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public boolean isOptimisticUnchoke() {
        return this.manager.isOptimisticUnchoke(this);
    }

    public boolean isReadyToRequest() {
        return this.readyToRequest;
    }

    public PEPeerControl getControl() {
        return this.manager;
    }

    public PEPeerManager getManager() {
        return this.manager;
    }

    public PEPeerStats getStats() {
        return this.stats;
    }

    public boolean[] getAvailable() {
        return this.other_peer_has_pieces;
    }

    public boolean isChokingMe() {
        return this.choked_by_other_peer;
    }

    public boolean isChokedByMe() {
        return this.choking_other_peer;
    }

    public boolean isInterestingToMe() {
        return this.interested_in_other_peer;
    }

    public boolean isInterestedInMe() {
        return this.other_peer_interested_in_me;
    }

    public boolean isSeed() {
        return this.seed;
    }

    public boolean isSnubbed() {
        return this.snubbed;
    }

    public void setSnubbed(boolean b) {
        this.snubbed = b;
    }

    protected abstract void setChannel(SocketChannel var1);

    protected abstract int readData(DirectByteBuffer var1) throws IOException;

    public void hasSentABadChunk() {
        ++this.nbBadChunks;
    }

    public int getNbBadChunks() {
        return this.nbBadChunks;
    }

    public void resetNbBadChunks() {
        this.nbBadChunks = 0;
    }

    public void setUploadHint(int spreadTime) {
        this.spreadTimeHint = spreadTime;
    }

    public int getUploadHint() {
        return this.spreadTimeHint;
    }

    public void setUniqueAnnounce(int _uniquePiece) {
        this.uniquePiece = _uniquePiece;
    }

    public int getUniqueAnnounce() {
        return this.uniquePiece;
    }

    public int getReadSleepTime() {
        return this.readSleepTime;
    }

    public void setReadSleepTime(int time) {
        this.readSleepTime = time;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public void setLastReadTime(long time) {
        this.lastReadTime = time;
    }

    protected PEPeerTransportDataReader getDataReader() {
        return this.manager.getDataReader();
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public String getIPHostName() {
        if (this.ip_resolved == null) {
            this.ip_resolved = this.ip;
            this.ip_resolver_request = IPToHostNameResolver.addResolverRequest(this.ip_resolved, new IPToHostNameResolverListener(){

                public void IPResolutionComplete(String res, boolean ok) {
                    PEPeerTransportProtocol.this.ip_resolved = res;
                }
            });
        }
        return this.ip_resolved;
    }

    protected void cancelRequests() {
        if (this.requested != null) {
            try {
                this.requested_mon.enter();
                int i = this.requested.size() - 1;
                while (i >= 0) {
                    DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.remove(i);
                    this.manager.requestCanceled(request2);
                    --i;
                }
            }
            finally {
                this.requested_mon.exit();
            }
        }
        if (!this.closing) {
            int[] type = new int[]{6};
            this.connection.getOutgoingMessageQueue().removeMessagesOfType(type, false);
        }
    }

    public int getNbRequests() {
        return this.requested.size();
    }

    public List getExpiredRequests() {
        ArrayList<DiskManagerReadRequest> result = null;
        try {
            int i = 0;
            while (i < this.requested.size()) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.get(i);
                if (request2.isExpired()) {
                    if (result == null) {
                        result = new ArrayList<DiskManagerReadRequest>();
                    }
                    result.add(request2);
                }
                ++i;
            }
            return result;
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected boolean alreadyRequested(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            boolean bl = this.requested.contains(request2);
            this.requested_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            this.requested_mon.exit();
            throw throwable;
        }
    }

    protected void addRequest(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            this.requested.add(request2);
        }
        finally {
            this.requested_mon.exit();
        }
    }

    protected void removeRequest(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            this.requested.remove(request2);
        }
        finally {
            this.requested_mon.exit();
        }
        BTRequest msg = new BTRequest(request2.getPieceNumber(), request2.getOffset(), request2.getLength());
        this.connection.getOutgoingMessageQueue().removeMessage(msg, false);
        msg.destroy();
    }

    protected void reSetRequestsTime() {
        try {
            this.requested_mon.enter();
            int i = 0;
            while (i < this.requested.size()) {
                DiskManagerReadRequest request2 = null;
                try {
                    request2 = (DiskManagerReadRequest)this.requested.get(i);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                if (request2 != null) {
                    request2.reSetTime();
                }
                ++i;
            }
        }
        finally {
            this.requested_mon.exit();
        }
    }

    public String toString() {
        return String.valueOf(this.ip) + ":" + this.port + " [" + this.client + "]";
    }

    public TransportOwner getTransportOwner() {
        return new TransportOwner(){

            public TransportDebugger getDebugger() {
                return null;
            }
        };
    }

    public void doKeepAliveCheck() {
        long wait_time = SystemTime.getCurrentTime() - this.last_message_sent_time;
        if (this.last_message_sent_time == 0L || wait_time < 0L) {
            this.last_message_sent_time = SystemTime.getCurrentTime();
            return;
        }
        if (wait_time > 120000L) {
            this.sendKeepAlive();
            this.last_message_sent_time = SystemTime.getCurrentTime();
        }
    }

    public boolean doTimeoutChecks() {
        if (this.connection_state == 4) {
            long dead_time = SystemTime.getCurrentTime() - this.last_message_received_time;
            if (dead_time < 0L) {
                this.last_message_received_time = SystemTime.getCurrentTime();
                return false;
            }
            if (dead_time > 600000L) {
                this.closeAll(String.valueOf(this.toString()) + ": Timed out while waiting for messages", true, true);
                return true;
            }
        } else if (this.connection_state == 2 || this.connection_state == 3) {
            long wait_time = SystemTime.getCurrentTime() - this.connection_established_time;
            if (wait_time < 0L) {
                this.connection_established_time = SystemTime.getCurrentTime();
                return false;
            }
            if (wait_time > 180000L) {
                String phase = this.connection_state == 2 ? "handshaking" : "bitfield";
                this.closeAll(String.valueOf(this.toString()) + ": Timed out while waiting in " + phase + " phase", true, true);
                return true;
            }
        }
        return false;
    }

    public int getConnectionState() {
        return this.connection_state;
    }

    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == 0L) {
            return 0L;
        }
        long time = SystemTime.getCurrentTime() - this.last_data_message_received_time;
        if (time < 0L) {
            this.last_data_message_received_time = SystemTime.getCurrentTime();
            time = 0L;
        }
        return time;
    }

    public long getTimeSinceConnectionEstablished() {
        if (this.connection_established_time == 0L) {
            return 0L;
        }
        long time = SystemTime.getCurrentTime() - this.connection_established_time;
        if (time < 0L) {
            this.connection_established_time = SystemTime.getCurrentTime();
            time = 0L;
        }
        return time;
    }

    private class StateConnecting
    implements PEPeerTransportProtocolState {
        StateConnecting() {
            Connection.ConnectionListener cl;
            if (socks_peer_proxy_enable) {
                PEPeerTransportProtocol.this.connection = NetworkManager.getSingleton().createNewConnection(PEPeerTransportProtocol.this, socks_host, socks_port);
                cl = new Connection.ConnectionListener(this){
                    final /* synthetic */ StateConnecting this$1;
                    {
                        this.this$1 = stateConnecting;
                    }

                    public void connectStarted() {
                        PEPeerTransportProtocol.access$4(StateConnecting.access$0(this.this$1), 1);
                    }

                    public void connectSuccess() {
                        LGLogger.log(1, 1, 2, "Established outgoing connection with " + StateConnecting.access$0(this.this$1));
                        StateConnecting.access$0(this.this$1).setChannel(PEPeerTransportProtocol.access$5(StateConnecting.access$0(this.this$1)).getSocketChannel());
                        PEPeerTransportProtocol.access$6(StateConnecting.access$0(this.this$1), StateConnecting.access$0(this.this$1).new SOCKSStateHandshaking());
                    }

                    public void connectFailure(Throwable failure_msg) {
                        StateConnecting.access$0(this.this$1).closeAll("Failed to establish outgoing connection [" + StateConnecting.access$0(this.this$1) + "] : " + failure_msg.getMessage(), true, false);
                    }

                    public void exceptionThrown(Throwable error) {
                        StateConnecting.access$0(this.this$1).closeAll("Connection [" + StateConnecting.access$0(this.this$1) + "] exception : " + error.getMessage(), true, true);
                    }
                };
            } else {
                PEPeerTransportProtocol.this.connection = NetworkManager.getSingleton().createNewConnection(PEPeerTransportProtocol.this, PEPeerTransportProtocol.this.ip, PEPeerTransportProtocol.this.port);
                cl = new Connection.ConnectionListener(this){
                    final /* synthetic */ StateConnecting this$1;
                    {
                        this.this$1 = stateConnecting;
                    }

                    public void connectStarted() {
                        PEPeerTransportProtocol.access$4(StateConnecting.access$0(this.this$1), 1);
                    }

                    public void connectSuccess() {
                        LGLogger.log(1, 1, 2, "Established outgoing connection with " + StateConnecting.access$0(this.this$1));
                        StateConnecting.access$0(this.this$1).setChannel(PEPeerTransportProtocol.access$5(StateConnecting.access$0(this.this$1)).getSocketChannel());
                        PEPeerTransportProtocol.access$6(StateConnecting.access$0(this.this$1), StateConnecting.access$0(this.this$1).new StateHandshaking(false, null));
                    }

                    public void connectFailure(Throwable failure_msg) {
                        StateConnecting.access$0(this.this$1).closeAll("Failed to establish outgoing connection [" + StateConnecting.access$0(this.this$1) + "] : " + failure_msg.getMessage(), true, false);
                    }

                    public void exceptionThrown(Throwable error) {
                        StateConnecting.access$0(this.this$1).closeAll("Connection [" + StateConnecting.access$0(this.this$1) + "] exception : " + error.getMessage(), true, true);
                    }
                };
            }
            PEPeerTransportProtocol.this.connection.connect(cl);
            LGLogger.log(1, 1, 2, "Creating outgoing connection to " + PEPeerTransportProtocol.this);
        }

        public int process() {
            return 100;
        }

        public int getState() {
            return 10;
        }

        static /* synthetic */ PEPeerTransportProtocol access$0(StateConnecting stateConnecting) {
            return stateConnecting.PEPeerTransportProtocol.this;
        }
    }

    private class SOCKSStateHandshaking
    implements PEPeerTransportProtocolState {
        DirectByteBuffer socks_handshake_read_buff;
        int handshake_phase = 0;
        int socks_v5_reply_rem_length;

        SOCKSStateHandshaking() {
            PEPeerTransportProtocol.this.connection_established_time = SystemTime.getCurrentTime();
            PEPeerTransportProtocol.this.allocateAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int process() {
            if (this.socks_handshake_read_buff == null) {
                int expected_reply_size;
                byte[] ip_bytes;
                int next_handshake_phase = 100;
                String mapped_ip = AEProxyFactory.getAddressMapper().internalise(PEPeerTransportProtocol.this.ip);
                ByteBuffer socks_out = ByteBuffer.allocate(256 + mapped_ip.length());
                if (socks_version.equals("V4")) {
                    socks_out.put((byte)4);
                    socks_out.put((byte)1);
                    socks_out.putShort((short)PEPeerTransportProtocol.this.port);
                    try {
                        ip_bytes = InetAddress.getByName(PEPeerTransportProtocol.this.ip).getAddress();
                        socks_out.put(ip_bytes[0]);
                        socks_out.put(ip_bytes[1]);
                        socks_out.put(ip_bytes[2]);
                        socks_out.put(ip_bytes[3]);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking:: " + e, true, false);
                        return 0;
                    }
                    if (socks_user.length() > 0) {
                        socks_out.put(socks_user.getBytes());
                    }
                    socks_out.put((byte)0);
                    expected_reply_size = 8;
                } else if (socks_version.equals("V4a")) {
                    socks_out.put((byte)4);
                    socks_out.put((byte)1);
                    socks_out.putShort((short)PEPeerTransportProtocol.this.port);
                    socks_out.put((byte)0);
                    socks_out.put((byte)0);
                    socks_out.put((byte)0);
                    socks_out.put((byte)1);
                    if (socks_user.length() > 0) {
                        socks_out.put(socks_user.getBytes());
                    }
                    socks_out.put((byte)0);
                    socks_out.put(mapped_ip.getBytes());
                    socks_out.put((byte)0);
                    expected_reply_size = 8;
                } else if (this.handshake_phase == 0) {
                    socks_out.put((byte)5);
                    socks_out.put((byte)2);
                    socks_out.put((byte)0);
                    socks_out.put((byte)2);
                    next_handshake_phase = 1;
                    expected_reply_size = 2;
                } else if (this.handshake_phase == 1) {
                    socks_out.put((byte)1);
                    socks_out.put((byte)socks_user.length());
                    socks_out.put(socks_user.getBytes());
                    socks_out.put((byte)socks_password.length());
                    socks_out.put(socks_password.getBytes());
                    next_handshake_phase = 2;
                    expected_reply_size = 2;
                } else if (this.handshake_phase == 2) {
                    socks_out.put((byte)5);
                    socks_out.put((byte)1);
                    socks_out.put((byte)0);
                    try {
                        ip_bytes = InetAddress.getByName(mapped_ip).getAddress();
                        socks_out.put((byte)1);
                        socks_out.put(ip_bytes[0]);
                        socks_out.put(ip_bytes[1]);
                        socks_out.put(ip_bytes[2]);
                        socks_out.put(ip_bytes[3]);
                    }
                    catch (Throwable e) {
                        socks_out.put((byte)3);
                        socks_out.put((byte)mapped_ip.length());
                        socks_out.put(mapped_ip.getBytes());
                    }
                    socks_out.putShort((short)PEPeerTransportProtocol.this.port);
                    next_handshake_phase = 3;
                    expected_reply_size = 5;
                } else {
                    next_handshake_phase = 100;
                    expected_reply_size = this.socks_v5_reply_rem_length;
                }
                socks_out.limit(socks_out.position());
                socks_out.position(0);
                SocketChannel chan = PEPeerTransportProtocol.this.connection.getSocketChannel();
                try {
                    while (true) {
                        if (socks_out.position() == socks_out.limit()) {
                            this.handshake_phase = next_handshake_phase;
                            break;
                        }
                        chan.write(socks_out);
                    }
                }
                catch (IOException e) {
                    PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking:: " + e, true, false);
                    if (this.socks_handshake_read_buff != null) {
                        this.socks_handshake_read_buff.returnToPool();
                        this.socks_handshake_read_buff = null;
                    }
                    return 0;
                }
                if (this.socks_handshake_read_buff != null) {
                    this.socks_handshake_read_buff.returnToPool();
                }
                this.socks_handshake_read_buff = DirectByteBufferPool.getBuffer((byte)3, expected_reply_size);
                if (this.socks_handshake_read_buff == null) {
                    PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS handshake_read_buff is null", true, false);
                    return 0;
                }
            }
            if (this.socks_handshake_read_buff.hasRemaining((byte)9)) {
                try {
                    int read = PEPeerTransportProtocol.this.readData(this.socks_handshake_read_buff);
                    if (read == 0) {
                        return 50;
                    }
                    if (read < 0) {
                        throw new IOException("SOCKS: End of Stream reached");
                    }
                }
                catch (IOException e) {
                    PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking:: " + e, true, false);
                    this.socks_handshake_read_buff.returnToPool();
                    return 0;
                }
            }
            if (!this.socks_handshake_read_buff.hasRemaining((byte)9)) {
                block44: {
                    try {
                        this.socks_handshake_read_buff.position((byte)9, 0);
                        if (socks_version.equals("V4") || socks_version.equals("V4a")) {
                            byte ver = this.socks_handshake_read_buff.get((byte)9);
                            byte resp = this.socks_handshake_read_buff.get((byte)9);
                            if (ver != 0 || resp != 90) {
                                PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking: connection declined (" + resp + ")", true, false);
                                this.socks_handshake_read_buff.returnToPool();
                                this.socks_handshake_read_buff = null;
                                return 0;
                            }
                            break block44;
                        }
                        if (this.handshake_phase == 1) {
                            this.socks_handshake_read_buff.get((byte)9);
                            byte method = this.socks_handshake_read_buff.get((byte)9);
                            if (method != 0 && method != 2) {
                                PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking: no valid method (" + method + ")", true, false);
                                this.socks_handshake_read_buff.returnToPool();
                                this.socks_handshake_read_buff = null;
                                return 0;
                            }
                            if (method == 0) {
                                this.handshake_phase = 2;
                            }
                            break block44;
                        }
                        if (this.handshake_phase == 2) {
                            this.socks_handshake_read_buff.get((byte)9);
                            byte status = this.socks_handshake_read_buff.get((byte)9);
                            if (status != 0) {
                                PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking: authentication fails", true, false);
                                this.socks_handshake_read_buff.returnToPool();
                                this.socks_handshake_read_buff = null;
                                return 0;
                            }
                            break block44;
                        }
                        if (this.handshake_phase == 3) {
                            this.socks_handshake_read_buff.get((byte)9);
                            byte rep = this.socks_handshake_read_buff.get((byte)9);
                            if (rep != 0) {
                                String[] error_msgs = new String[]{"", "General SOCKS server failure", "connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
                                String error_msg = rep < error_msgs.length ? error_msgs[rep] : "Unknown error";
                                PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": SOCKS StateHandshaking: request failure ( " + error_msg + "/" + rep + " )", true, false);
                                this.socks_handshake_read_buff.returnToPool();
                                this.socks_handshake_read_buff = null;
                                return 0;
                            }
                            this.socks_handshake_read_buff.get((byte)9);
                            byte atype = this.socks_handshake_read_buff.get((byte)9);
                            byte first_address_byte = this.socks_handshake_read_buff.get((byte)9);
                            int address_len = atype == 1 ? 3 : (atype == 3 ? (int)first_address_byte : 15);
                            this.socks_v5_reply_rem_length = address_len + 2;
                        }
                    }
                    finally {
                        this.socks_handshake_read_buff.returnToPool();
                        this.socks_handshake_read_buff = null;
                    }
                }
                if (this.handshake_phase == 100) {
                    PEPeerTransportProtocol.this.currentState = new StateHandshaking(true, null);
                }
            }
            return 20;
        }

        public int getState() {
            return 20;
        }
    }

    private class StateHandshaking
    implements PEPeerTransportProtocolState {
        DirectByteBuffer handshake_read_buff;
        boolean sent_our_handshake = false;

        StateHandshaking(boolean already_initialised, byte[] data_already_read) {
            PEPeerTransportProtocol.this.connection_established_time = SystemTime.getCurrentTime();
            PEPeerTransportProtocol.this.connection_state = 2;
            if (!already_initialised) {
                PEPeerTransportProtocol.this.allocateAll();
            }
            this.handshake_read_buff = DirectByteBufferPool.getBuffer((byte)3, 68);
            if (this.handshake_read_buff == null) {
                PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": handshake_read_buff is null", true, false);
                return;
            }
            if (data_already_read != null) {
                this.handshake_read_buff.put((byte)9, data_already_read);
            }
        }

        public int process() {
            if (!this.sent_our_handshake) {
                if (this.getState() == 40) {
                    return 0;
                }
                PEPeerTransportProtocol.this.connection.getOutgoingMessageQueue().addMessage(new BTHandshake(PEPeerTransportProtocol.this.manager.getHash(), PEPeerTransportProtocol.this.manager.getPeerId()), false);
                this.sent_our_handshake = true;
            }
            if (this.handshake_read_buff.hasRemaining((byte)9)) {
                try {
                    int read = PEPeerTransportProtocol.this.readData(this.handshake_read_buff);
                    if (read == 0) {
                        return 50;
                    }
                    if (read < 0) {
                        throw new IOException("End of Stream reached");
                    }
                }
                catch (IOException e) {
                    PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": StateHandshaking:: " + e, true, false);
                    this.handshake_read_buff.returnToPool();
                    return 0;
                }
            }
            if (!this.handshake_read_buff.hasRemaining((byte)9)) {
                PEPeerTransportProtocol.this.handleHandShakeResponse(this.handshake_read_buff);
            }
            return 20;
        }

        public int getState() {
            return 20;
        }
    }

    private class StateTransfering
    implements PEPeerTransportProtocolState {
        DirectByteBuffer lengthBuffer = new DirectByteBuffer(ByteBuffer.allocate(4));
        boolean readingLength = true;
        DirectByteBuffer message_read_buff;

        StateTransfering() {
        }

        public int process() {
            int read;
            PEPeerTransportProtocol pEPeerTransportProtocol = PEPeerTransportProtocol.this;
            int n = pEPeerTransportProtocol.processLoop + 1;
            pEPeerTransportProtocol.processLoop = n;
            if (n > 10) {
                return 20;
            }
            if (this.readingLength) {
                if (this.lengthBuffer.hasRemaining((byte)9)) {
                    try {
                        read = PEPeerTransportProtocol.this.readData(this.lengthBuffer);
                        if (read == 0) {
                            if (this.lengthBuffer.remaining((byte)9) == 4) {
                                PEPeerTransportProtocol.this.readyToRequest = true;
                                return 100;
                            }
                            return 50;
                        }
                        if (read < 0) {
                            throw new IOException("End of Stream Reached");
                        }
                    }
                    catch (IOException e) {
                        PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + " : StateTransfering::" + e.getMessage() + " (reading length)", true, true);
                        return 20;
                    }
                }
                if (!this.lengthBuffer.hasRemaining((byte)9)) {
                    int length = this.lengthBuffer.getInt((byte)9, 0);
                    this.readingLength = false;
                    this.lengthBuffer.position((byte)9, 0);
                    if (length < 0) {
                        PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + " : length negative : " + length, true, true);
                        return 20;
                    }
                    if (length > 16393) {
                        Debug.out(PEPeerTransportProtocol.this + " : sent too-large incoming message size: " + length);
                        PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + " : sent too-large incoming message size: " + length, true, true);
                        return 20;
                    }
                    if (length > 0) {
                        this.message_read_buff = DirectByteBufferPool.getBuffer((byte)3, length);
                        if (this.message_read_buff == null) {
                            PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + ": message_read_buff is null", true, false);
                            return 20;
                        }
                        if (length > 13) {
                            PEPeerTransportProtocol.this.readyToRequest = true;
                        } else {
                            PEPeerTransportProtocol.this.readyToRequest = false;
                        }
                    } else {
                        PEPeerTransportProtocol.this.last_message_received_time = SystemTime.getCurrentTime();
                        LGLogger.log(1, 0, 1, PEPeerTransportProtocol.this + " sent keep-alive");
                        this.readingLength = true;
                    }
                }
            }
            if (!this.readingLength) {
                try {
                    read = PEPeerTransportProtocol.this.readData(this.message_read_buff);
                    if (read == 0) {
                        return 50;
                    }
                    if (read < 0) {
                        throw new IOException("End of Stream Reached");
                    }
                    if (this.message_read_buff.limit((byte)9) > 13 && PEPeerTransportProtocol.this.connection_state != 3) {
                        PEPeerTransportProtocol.this.stats.received(read);
                    }
                }
                catch (IOException e) {
                    PEPeerTransportProtocol.this.closeAll(PEPeerTransportProtocol.this + " : StateTransfering::End of Stream Reached (reading data)", true, true);
                    this.message_read_buff.returnToPool();
                    return 20;
                }
                if (!this.message_read_buff.hasRemaining((byte)9)) {
                    PEPeerTransportProtocol.this.readyToRequest = false;
                    this.readingLength = PEPeerTransportProtocol.this.analyzeIncomingMessage(this.message_read_buff);
                    if (this.getState() == 30 && this.readingLength) {
                        this.process();
                        return 20;
                    }
                }
            }
            return 20;
        }

        public int getState() {
            return 30;
        }
    }

    private static class StateClosing
    implements PEPeerTransportProtocolState {
        StateClosing() {
        }

        public int process() {
            return 20;
        }

        public int getState() {
            return 40;
        }
    }
}

