/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer;

import com.aelitis.azureus.core.peermanager.LimitedRateGroup;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public interface PEPeerManager {
    public static final int PS_INITIALISED = 1;
    public static final int PS_DOWNLOADING = 2;
    public static final int PS_SEEDING = 3;
    public static final int PS_STOPPED = 4;

    public int getState();

    public DownloadManager getDownloadManager();

    public void start();

    public void stopAll();

    public byte[] getHash();

    public PeerIdentityDataID getPeerIdentityDataID();

    public byte[] getPeerId();

    public int[] getAvailability();

    public int getAvailability(int var1);

    public float getMinAvailability();

    public PEPiece[] getPieces();

    public PEPeerManagerStats getStats();

    public void processTrackerResponse(TRTrackerResponse var1);

    public int getNbPeers();

    public int getNbSeeds();

    public int getNbHashFails();

    public void setNbHashFails(int var1);

    public int getPiecesNumber();

    public int getPieceLength(int var1);

    public long getRemaining();

    public long getETA();

    public String getElapsedTime();

    public long getTimeStarted();

    public long getTimeStartedSeeding();

    public void addListener(PEPeerManagerListener var1);

    public void removeListener(PEPeerManagerListener var1);

    public void pieceAdded(PEPiece var1);

    public boolean needsMD5CheckOnCompletion(int var1);

    public boolean isSuperSeedMode();

    public int getNbRemoteConnections();

    public void received(int var1);

    public void sent(int var1);

    public void protocol_sent(int var1);

    public void discarded(int var1);

    public PEPeerStats createPeerStats();

    public List getPeers();

    public void addPeer(PEPeer var1);

    public void removePeer(PEPeer var1);

    public void peerAdded(PEPeer var1);

    public void peerRemoved(PEPeer var1);

    public DiskManagerReadRequest createDiskManagerRequest(int var1, int var2, int var3);

    public void requestCanceled(DiskManagerReadRequest var1);

    public boolean checkBlock(int var1, int var2, DirectByteBuffer var3);

    public void writeBlock(int var1, int var2, DirectByteBuffer var3, PEPeer var4);

    public void writeBlockAndCancelOutstanding(int var1, int var2, DirectByteBuffer var3, PEPeer var4);

    public boolean isBlockAlreadyWritten(int var1, int var2);

    public boolean isInEndGameMode();

    public void peerConnectionClosed(PEPeerTransport var1, boolean var2);

    public LimitedRateGroup getUploadLimitedRateGroup();

    public Object getData(String var1);

    public void setData(String var1, Object var2);
}

