/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BannedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.BlockedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IPAddressRangeManager;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;

public class IpFilterImpl
implements IpFilter {
    private static IpFilterImpl ipFilter;
    private static AEMonitor class_mon;
    private List all_ip_ranges;
    private IPAddressRangeManager range_manager = new IPAddressRangeManager();
    private Map bannedIps;
    private List ipsBlocked;
    private long last_update_time;

    static {
        class_mon = new AEMonitor("IpFilter:class");
    }

    private IpFilterImpl() {
        ipFilter = this;
        this.all_ip_ranges = new ArrayList(1024);
        this.bannedIps = new HashMap();
        this.ipsBlocked = new ArrayList();
        try {
            this.loadFilters();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public static IpFilter getInstance() {
        try {
            class_mon.enter();
            if (ipFilter == null) {
                ipFilter = new IpFilterImpl();
            }
            IpFilterImpl ipFilterImpl = ipFilter;
            class_mon.exit();
            return ipFilterImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public File getFile() {
        return FileUtil.getUserFile("filters.config");
    }

    public void reload() throws Exception {
        this.loadFilters();
    }

    public void save() throws Exception {
        try {
            class_mon.enter();
            HashMap map = new HashMap();
            ArrayList filters = new ArrayList();
            map.put("ranges", filters);
            Iterator iter = this.all_ip_ranges.iterator();
            while (iter.hasNext()) {
                IpRange range = (IpRange)iter.next();
                if (!range.isValid() || range.isSessionOnly()) continue;
                String description = range.getDescription();
                String startIp = range.getStartIp();
                String endIp = range.getEndIp();
                HashMap<String, String> mapRange = new HashMap<String, String>();
                mapRange.put("description", description);
                mapRange.put("start", startIp);
                mapRange.put("end", endIp);
                filters.add(mapRange);
            }
            FileOutputStream fos = null;
            try {
                File filtersFile = FileUtil.getUserFile("filters.config");
                fos = new FileOutputStream(filtersFile);
                fos.write(BEncoder.encode(map));
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadFilters() throws Exception {
        try {
            IpFilterImpl.class_mon.enter();
            new_ipRanges = new ArrayList<IpRangeImpl>(1024);
            fin = null;
            bin = null;
            try {
                filtersFile = FileUtil.getUserFile("filters.config");
                if (filtersFile.exists()) {
                    fin = new FileInputStream(filtersFile);
                    bin = new BufferedInputStream(fin, 8192);
                    map = BDecoder.decode(bin);
                    list = (List)map.get("ranges");
                    iter = list.listIterator();
                    while (iter.hasNext()) {
                        range = (Map)iter.next();
                        description = new String((byte[])range.get("description"));
                        startIp = new String((byte[])range.get("start"));
                        endIp = new String((byte[])range.get("end"));
                        ipRange = new IpRangeImpl(description, startIp, endIp, false);
                        new_ipRanges.add(ipRange);
                    }
                    bin.close();
                    fin.close();
                }
            }
            finally {
                this.all_ip_ranges = new_ipRanges;
                it = this.all_ip_ranges.iterator();
                if (true) ** GOTO lbl35
            }
            {
            }
            do {
                ((IpRange)it.next()).checkValid();
lbl35:
                // 2 sources

            } while (it.hasNext());
            this.markAsUpToDate();
        }
        finally {
            IpFilterImpl.class_mon.exit();
        }
    }

    protected boolean isInRange(IpRangeImpl range, String address) {
        return this.range_manager.isInRange(range, address);
    }

    public boolean isInRange(String ipAddress) {
        return this.isInRange(ipAddress, "");
    }

    public boolean isInRange(String ipAddress, String torrent_name) {
        if (this.isBanned(ipAddress)) {
            return true;
        }
        if (ipAddress.equals("127.0.0.1")) {
            return false;
        }
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Enabled", true)) {
            return false;
        }
        boolean allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
        IpRange match = (IpRange)this.range_manager.isInRange(ipAddress);
        if (match != null) {
            if (!allow) {
                try {
                    class_mon.enter();
                    this.ipsBlocked.add(new BlockedIpImpl(ipAddress, match, torrent_name));
                }
                finally {
                    class_mon.exit();
                }
                LGLogger.log(0, 0, 3, "Ip Blocked : " + ipAddress + ", in range : " + match);
                return true;
            }
            return false;
        }
        if (allow) {
            try {
                class_mon.enter();
                this.ipsBlocked.add(new BlockedIpImpl(ipAddress, null, torrent_name));
            }
            finally {
                class_mon.exit();
            }
            LGLogger.log(0, 0, 3, "Ip Blocked : " + ipAddress + ", not in any range");
            return true;
        }
        return false;
    }

    private boolean isBanned(String ipAddress) {
        try {
            class_mon.enter();
            boolean bl = this.bannedIps.get(ipAddress) != null;
            class_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public boolean getInRangeAddressesAreAllowed() {
        boolean allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
        return allow;
    }

    public void setInRangeAddressesAreAllowed(boolean b) {
        COConfigurationManager.setParameter("Ip Filter Allow", b);
    }

    public List getIpRanges() {
        try {
            class_mon.enter();
            ArrayList arrayList = new ArrayList(this.all_ip_ranges);
            class_mon.exit();
            return arrayList;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public IpRange[] getRanges() {
        try {
            class_mon.enter();
            IpRange[] res = new IpRange[this.all_ip_ranges.size()];
            this.all_ip_ranges.toArray(res);
            IpRange[] ipRangeArray = res;
            class_mon.exit();
            return ipRangeArray;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public IpRange createRange(boolean sessionOnly) {
        return new IpRangeImpl("", "", "", sessionOnly);
    }

    public void addRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(true);
            this.all_ip_ranges.add(range);
            range.checkValid();
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    public void removeRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(false);
            this.all_ip_ranges.remove(range);
            this.range_manager.removeRange(range);
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    public int getNbRanges() {
        return this.all_ip_ranges.size();
    }

    protected void setValidOrNot(IpRangeImpl range, boolean valid) {
        try {
            class_mon.enter();
            if (!range.getAddedToRangeList()) {
                class_mon.exit();
                return;
            }
        }
        finally {
            class_mon.exit();
        }
        if (valid) {
            this.range_manager.addRange(range.getStartIp(), range.getEndIp(), (Object)range);
        } else {
            this.range_manager.removeRange(range);
        }
    }

    public int getNbIpsBlocked() {
        return this.ipsBlocked.size();
    }

    public void ban(String ipAddress, String torrent_name) {
        try {
            class_mon.enter();
            if (this.bannedIps.get(ipAddress) == null) {
                this.bannedIps.put(ipAddress, new BannedIpImpl(ipAddress, torrent_name));
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public BannedIp[] getBannedIps() {
        try {
            class_mon.enter();
            BannedIp[] res = new BannedIp[this.bannedIps.size()];
            this.bannedIps.values().toArray(res);
            BannedIp[] bannedIpArray = res;
            class_mon.exit();
            return bannedIpArray;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public int getNbBannedIps() {
        return this.bannedIps.size();
    }

    public void clearBannedIps() {
        try {
            class_mon.enter();
            this.bannedIps.clear();
        }
        finally {
            class_mon.exit();
        }
    }

    public BlockedIp[] getBlockedIps() {
        try {
            class_mon.enter();
            BlockedIp[] res = new BlockedIp[this.ipsBlocked.size()];
            this.ipsBlocked.toArray(res);
            BlockedIp[] blockedIpArray = res;
            class_mon.exit();
            return blockedIpArray;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public void clearBlockedIPs() {
        try {
            class_mon.enter();
            this.ipsBlocked.clear();
        }
        finally {
            class_mon.exit();
        }
    }

    public boolean isEnabled() {
        return COConfigurationManager.getBooleanParameter("Ip Filter Enabled", true);
    }

    public void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter("Ip Filter Enabled", enabled);
    }

    public void markAsUpToDate() {
        this.last_update_time = SystemTime.getCurrentTime();
    }

    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    public long getTotalAddressesInRange() {
        return this.range_manager.getTotalSpan();
    }
}

