/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IPAddressRangeManager {
    protected Map entries = new HashMap();
    protected long total_span;
    protected boolean rebuild_required;
    protected long last_rebuild_time;
    protected entry[] merged_entries = new entry[0];
    protected AEMonitor this_mon = new AEMonitor("IPAddressRangeManager");

    public void addRange(String start, String end, Object user_data) {
        try {
            this.this_mon.enter();
            int s = this.addressToInt(start);
            int e = this.addressToInt(end);
            this.addRange(s, e, user_data);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void addRange(int start_int, int end_int, Object user_data) {
        try {
            this.this_mon.enter();
            entry old_entry = (entry)this.entries.get(user_data);
            if (old_entry != null) {
                if (old_entry.getStartInt() == start_int && old_entry.getEndInt() == end_int) {
                    this.this_mon.exit();
                    return;
                }
                old_entry.setStartInt(start_int);
                old_entry.setEndInt(end_int);
            } else {
                this.entries.put(user_data, new entry(start_int, end_int, user_data));
            }
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeRange(Object user_data) {
        try {
            this.this_mon.enter();
            this.entries.remove(user_data);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public Object isInRange(String ip) {
        try {
            Object res;
            this.this_mon.enter();
            long address_long = this.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            Object object = res = this.isInRange(address_long);
            this.this_mon.exit();
            return object;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInRange(Object user_data, String address) {
        try {
            try {
                entry e;
                this.this_mon.enter();
                long address_long = PRHelpers.addressToInt(address);
                if (address_long < 0L) {
                    address_long += 0x100000000L;
                }
                if ((e = (entry)this.entries.get(user_data)) == null) {
                    this.this_mon.exit();
                    return false;
                }
                boolean bl = address_long >= e.getStartLong() && address_long <= e.getEndLong();
                this.this_mon.exit();
                return bl;
            }
            catch (UnknownHostException e) {
                this.this_mon.exit();
                return false;
            }
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object isInRange(long address_long) {
        try {
            entry e;
            this.this_mon.enter();
            this.checkRebuild();
            if (this.merged_entries.length == 0) {
                Object var12_2 = null;
                this.this_mon.exit();
                return var12_2;
            }
            int bottom = 0;
            int top = this.merged_entries.length - 1;
            int current = -1;
            while (top >= 0 && bottom < this.merged_entries.length && bottom <= top) {
                current = (bottom + top) / 2;
                e = this.merged_entries[current];
                long this_start = e.getStartLong();
                long this_end = e.getMergedEndLong();
                if (address_long == this_start) break;
                if (address_long > this_start) {
                    if (address_long <= this_end) break;
                    bottom = current + 1;
                    continue;
                }
                if (address_long == this_end || address_long >= this_start) break;
                top = current - 1;
            }
            if (top >= 0 && bottom < this.merged_entries.length && bottom <= top) {
                e = this.merged_entries[current];
                if (address_long <= e.getEndLong()) {
                    Object object = e.getUserData();
                    this.this_mon.exit();
                    return object;
                }
                entry[] merged = e.getMergedEntries();
                if (merged == null) {
                    Debug.out("IPAddressRangeManager: inconsistent merged details - no entries");
                    Object var12_4 = null;
                    this.this_mon.exit();
                    return var12_4;
                }
                int i = 0;
                while (true) {
                    if (i >= merged.length) {
                        Debug.out("IPAddressRangeManager: inconsistent merged details - entry not found");
                        break;
                    }
                    entry me = merged[i];
                    if (me.getStartLong() <= address_long && me.getEndLong() >= address_long) {
                        Object object = me.getUserData();
                        this.this_mon.exit();
                        return object;
                    }
                    ++i;
                }
            }
            Object var12_6 = null;
            this.this_mon.exit();
            return var12_6;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected int addressToInt(String address) {
        try {
            return PRHelpers.addressToInt(address);
        }
        catch (UnknownHostException e) {
            return UnresolvableHostManager.getPseudoAddress(address);
        }
    }

    protected void checkRebuild() {
        try {
            long now;
            long secs_since_last_build;
            this.this_mon.enter();
            if (this.rebuild_required && (secs_since_last_build = ((now = SystemTime.getCurrentTime()) - this.last_rebuild_time) / 1000L) > (long)(this.entries.size() / 2000)) {
                this.last_rebuild_time = now;
                this.rebuild_required = false;
                this.rebuild();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void rebuild() {
        LGLogger.log("IPAddressRangeManager: rebuilding " + this.entries.size() + " entries starts");
        Collection col = this.entries.values();
        entry[] ents = new entry[col.size()];
        col.toArray(ents);
        int i = 0;
        while (i < ents.length) {
            ents[i].reset();
            ++i;
        }
        Arrays.sort(ents, new Comparator(){

            public int compare(Object o1, Object o2) {
                entry e1 = (entry)o1;
                entry e2 = (entry)o2;
                if (e1.getStartLong() < e2.getStartLong()) {
                    return -1;
                }
                if (e1.getStartLong() > e2.getStartLong()) {
                    return 1;
                }
                long l = e2.getEndLong() - e1.getEndLong();
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        ArrayList<entry> me = new ArrayList<entry>(ents.length);
        int i2 = 0;
        while (i2 < ents.length) {
            entry entry2 = ents[i2];
            if (!entry2.getMerged()) {
                me.add(entry2);
                int pos = i2 + 1;
                while (pos < ents.length) {
                    entry e2;
                    long end_pos = entry2.getMergedEndLong();
                    if ((e2 = ents[pos++]).getMerged()) continue;
                    if (end_pos < e2.getStartLong()) break;
                    e2.setMerged();
                    if (e2.getEndLong() <= end_pos) continue;
                    entry2.setMergedEndInt(e2.getEndInt());
                    entry2.addMergedEntry(e2);
                }
            }
            ++i2;
        }
        this.merged_entries = new entry[me.size()];
        me.toArray(this.merged_entries);
        this.total_span = 0L;
        i2 = 0;
        while (i2 < this.merged_entries.length) {
            entry e = this.merged_entries[i2];
            long span = e.getMergedEndLong() - e.getStartLong() + 1L;
            this.total_span += span;
            ++i2;
        }
        LGLogger.log("IPAddressRangeManager: rebuilding " + this.entries.size() + " entries ends");
    }

    protected long getTotalSpan() {
        this.checkRebuild();
        return this.total_span;
    }

    public static void main(String[] args) {
        IPAddressRangeManager manager = new IPAddressRangeManager();
        manager.addRange("3.1.1.1", "3.1.1.2", (Object)"1");
        manager.addRange("3.1.1.1", "3.1.1.3", (Object)"1");
        manager.addRange("1.1.1.1", "2.2.2.2", (Object)"2");
        manager.addRange("0.1.1.1", "2.2.2.2", (Object)"3");
        manager.addRange("1.1.1.1", "1.2.2.2", (Object)"4");
        manager.addRange("7.7.7.7", "7.7.8.7", (Object)"5");
        manager.addRange("8.8.8.8", "8.8.8.8", (Object)"6");
        manager.addRange("5.5.5.5", "6.6.6.9", (Object)"8");
        manager.addRange("6.6.6.6", "7.7.0.0", (Object)"9");
        manager.addRange("254.6.6.6", "254.7.0.0", (Object)"10");
        System.out.println("inRange -> " + manager.isInRange("254.6.6.8"));
        System.out.println("Total span = " + manager.getTotalSpan());
    }

    protected class entry {
        private int start;
        private int end;
        private Object user_data;
        private boolean merged;
        private int merged_end;
        private entry[] my_merged_entries;

        protected entry(int _start, int _end, Object _ud) {
            this.start = _start;
            this.end = _end;
            this.user_data = _ud;
        }

        protected int getStartInt() {
            return this.start;
        }

        protected long getStartLong() {
            return this.start < 0 ? (long)this.start + 0x100000000L : (long)this.start;
        }

        protected void setStartInt(int _start) {
            this.start = _start;
        }

        protected int getEndInt() {
            return this.end;
        }

        protected long getEndLong() {
            return this.end < 0 ? (long)this.end + 0x100000000L : (long)this.end;
        }

        protected void setEndInt(int _end) {
            this.end = _end;
        }

        protected void setMergedEndInt(int _merged_end) {
            this.merged_end = _merged_end;
        }

        protected long getMergedEndInt() {
            return this.merged_end;
        }

        protected long getMergedEndLong() {
            return this.merged_end < 0 ? (long)this.merged_end + 0x100000000L : (long)this.merged_end;
        }

        protected Object getUserData() {
            return this.user_data;
        }

        protected boolean getMerged() {
            return this.merged;
        }

        protected void setMerged() {
            this.merged = true;
        }

        protected void addMergedEntry(entry e2) {
            if (this.my_merged_entries == null) {
                this.my_merged_entries = new entry[]{e2};
            } else {
                entry[] x = new entry[this.my_merged_entries.length + 1];
                System.arraycopy(this.my_merged_entries, 0, x, 0, this.my_merged_entries.length);
                x[x.length - 1] = e2;
                this.my_merged_entries = x;
            }
        }

        protected entry[] getMergedEntries() {
            return this.my_merged_entries;
        }

        protected void reset() {
            this.merged = false;
            this.merged_end = this.end;
        }
    }
}

