/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.html.impl;

import java.util.ArrayList;
import org.gudy.azureus2.core3.html.HTMLTable;
import org.gudy.azureus2.core3.html.impl.HTMLTableImpl;

public class HTMLChunkImpl {
    String content;

    protected HTMLChunkImpl() {
    }

    protected HTMLChunkImpl(String _content) {
        this.content = _content;
    }

    protected void setContent(String str) {
        this.content = str;
    }

    public String[] getLinks() {
        int p2;
        int p1;
        int pos = 0;
        ArrayList<String> res = new ArrayList<String>();
        while ((p1 = this.content.indexOf("<", pos)) != -1 && (p2 = this.content.indexOf(">", ++p1)) != -1) {
            int hr_start;
            pos = p2;
            String tag = this.content.substring(p1, p2).trim();
            String lc_tag = tag.toLowerCase();
            if (!lc_tag.startsWith("a ") || (hr_start = lc_tag.indexOf("href")) == -1 || (hr_start = lc_tag.indexOf("=", hr_start)) == -1) continue;
            ++hr_start;
            while (hr_start < lc_tag.length() && Character.isWhitespace(lc_tag.charAt(hr_start))) {
                ++hr_start;
            }
            int hr_end = hr_start;
            while (hr_end < lc_tag.length() && !Character.isWhitespace(lc_tag.charAt(hr_end))) {
                ++hr_end;
            }
            String href = tag.substring(hr_start, hr_end).trim();
            if (href.startsWith("\"")) {
                href = href.substring(1, href.length() - 1);
            }
            res.add(href);
        }
        String[] res_array = new String[res.size()];
        res.toArray(res_array);
        return res_array;
    }

    public HTMLTable[] getTables() {
        String[] tables = this.getTagPairContent("table");
        HTMLTable[] res = new HTMLTable[tables.length];
        int i = 0;
        while (i < tables.length) {
            res[i] = new HTMLTableImpl(tables[i]);
            ++i;
        }
        return res;
    }

    public String[] getTags(String tag_name) {
        int p2;
        int p1;
        tag_name = tag_name.toLowerCase();
        String lc_content = this.content.toLowerCase();
        int pos = 0;
        ArrayList<String> res = new ArrayList<String>();
        while ((p1 = lc_content.indexOf("<" + tag_name, pos)) != -1 && (p2 = lc_content.indexOf(">", p1)) != -1) {
            res.add(this.content.substring(p1 + 1, p2));
            pos = p2 + 1;
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public String[] getTagPairContent(String tag_name) {
        tag_name = tag_name.toLowerCase();
        String lc_content = this.content.toLowerCase();
        int pos = 0;
        ArrayList<String> res = new ArrayList<String>();
        int level = 0;
        int start_pos = -1;
        while (true) {
            int start_tag_start = lc_content.indexOf("<" + tag_name, pos);
            int end_tag_start = lc_content.indexOf("</" + tag_name, pos);
            if (level == 0) {
                if (start_tag_start == -1) break;
                start_pos = start_tag_start;
                level = 1;
                pos = start_pos + 1;
                continue;
            }
            if (end_tag_start == -1) break;
            if (start_tag_start == -1 || end_tag_start < start_tag_start) {
                if (level == 1) {
                    String tag_contents = this.content.substring(start_pos + tag_name.length() + 1, end_tag_start);
                    res.add(tag_contents);
                }
                --level;
                pos = end_tag_start + 1;
                continue;
            }
            if (start_tag_start == -1) break;
            ++level;
            pos = start_tag_start + 1;
        }
        String[] res_array = new String[res.size()];
        res.toArray(res_array);
        return res_array;
    }

    public String getContent() {
        return this.content;
    }
}

