/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecepicker.impl;

import java.util.ArrayList;
import java.util.BitSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.PieceList;
import org.gudy.azureus2.core3.disk.impl.piecepicker.DMPiecePicker;

public class DMPiecePickerImpl
implements DMPiecePicker,
ParameterListener {
    protected DiskManagerHelper disk_manager;
    protected boolean firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece", false);
    protected boolean completionPriority = COConfigurationManager.getBooleanParameter("Prioritize Most Completed Files", false);
    protected int nbPieces;
    protected int[] pieceCompletion;
    protected BitSet[] priorityLists;

    public DMPiecePickerImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        this.nbPieces = this.disk_manager.getNumberOfPieces();
    }

    public void start() {
        COConfigurationManager.addParameterListener("Prioritize First Piece", this);
        this.pieceCompletion = new int[this.nbPieces];
        this.priorityLists = new BitSet[100];
    }

    public void stop() {
        COConfigurationManager.removeParameterListener("Prioritize First Piece", this);
    }

    public void parameterChanged(String parameterName) {
        this.firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece", false);
    }

    public void computePriorityIndicator() {
        DiskManagerPiece[] pieces = this.disk_manager.getPieces();
        int i = 0;
        while (i < this.pieceCompletion.length) {
            if (pieces[i].getDone()) {
                this.pieceCompletion[i] = -1;
            } else {
                PieceList pieceList = this.disk_manager.getPieceList(i);
                int completion = -1;
                int k = 0;
                while (k < pieceList.size()) {
                    DiskManagerFileInfoImpl fileInfo2 = pieceList.get(k).getFile();
                    if (!fileInfo2.isSkipped()) {
                        if (this.firstPiecePriority && i == fileInfo2.getFirstPieceNumber()) {
                            if (fileInfo2.isPriority()) {
                                completion = 99;
                            } else if (completion < 97) {
                                completion = 97;
                            }
                        } else if (fileInfo2.isPriority()) {
                            if (completion < 98) {
                                completion = 98;
                            }
                        } else if (this.completionPriority) {
                            int percent = 0;
                            if (fileInfo2.getLength() != 0L) {
                                percent = (int)(fileInfo2.getDownloaded() * 100L / fileInfo2.getLength());
                            }
                            if (percent < 100 && completion < percent) {
                                completion = percent;
                            }
                        } else if (completion < 0) {
                            completion = 0;
                        }
                    }
                    ++k;
                }
                this.pieceCompletion[i] = completion;
            }
            ++i;
        }
        i = 0;
        while (i < this.priorityLists.length) {
            BitSet list = this.priorityLists[i];
            if (list == null) {
                list = new BitSet(this.pieceCompletion.length);
            } else {
                list.clear();
            }
            this.priorityLists[i] = list;
            ++i;
        }
        int j = 0;
        while (j < this.pieceCompletion.length) {
            int priority = this.pieceCompletion[j];
            if (priority >= 0) {
                this.priorityLists[priority].set(j);
            }
            ++j;
        }
    }

    public int getPiecenumberToDownload(boolean[] _piecesRarest) {
        ArrayList<Integer> _pieces = new ArrayList<Integer>();
        int i = 99;
        while (i >= 0) {
            if (!this.priorityLists[i].isEmpty()) {
                int j = 0;
                while (j < this.nbPieces) {
                    if (_piecesRarest[j] && this.priorityLists[i].get(j)) {
                        _pieces.add(FlyWeightInteger.getInteger(j));
                    }
                    ++j;
                }
                if (_pieces.size() != 0) break;
            }
            --i;
        }
        if (_pieces.size() == 0) {
            return -1;
        }
        return (Integer)_pieces.get((int)(Math.random() * (double)_pieces.size()));
    }

    private static class FlyWeightInteger {
        private static Integer[] array = new Integer[1024];

        FlyWeightInteger() {
        }

        static final Integer getInteger(int value) {
            Integer tmp = null;
            if (value >= array.length) {
                Integer[] arrayNew = new Integer[value + 256];
                System.arraycopy(array, 0, arrayNew, 0, array.length);
                array = arrayNew;
            } else {
                tmp = array[value];
            }
            if (tmp == null) {
                FlyWeightInteger.array[value] = tmp = new Integer(value);
            }
            return tmp;
        }
    }
}

