/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.impl.device.UPnPServiceImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPDeviceImpl
implements UPnPDevice {
    protected UPnPRootDeviceImpl root_device;
    protected String device_type;
    protected String friendly_name;
    protected List devices = new ArrayList();
    protected List services = new ArrayList();

    protected UPnPDeviceImpl(UPnPRootDeviceImpl _root_device, String indent, SimpleXMLParserDocumentNode device_node) {
        SimpleXMLParserDocumentNode dev_list;
        this.root_device = _root_device;
        this.device_type = device_node.getChild("DeviceType").getValue().trim();
        this.friendly_name = device_node.getChild("FriendlyName").getValue().trim();
        boolean interested = this.device_type.equalsIgnoreCase("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        this.root_device.getUPnP().log(String.valueOf(indent) + this.friendly_name + (interested ? " *" : ""));
        SimpleXMLParserDocumentNode service_list = device_node.getChild("ServiceList");
        if (service_list != null) {
            SimpleXMLParserDocumentNode[] service_nodes = service_list.getChildren();
            int i = 0;
            while (i < service_nodes.length) {
                this.services.add(new UPnPServiceImpl(this, String.valueOf(indent) + "  ", service_nodes[i]));
                ++i;
            }
        }
        if ((dev_list = device_node.getChild("DeviceList")) != null) {
            SimpleXMLParserDocumentNode[] device_nodes = dev_list.getChildren();
            int i = 0;
            while (i < device_nodes.length) {
                this.devices.add(new UPnPDeviceImpl(this.root_device, String.valueOf(indent) + "  ", device_nodes[i]));
                ++i;
            }
        }
    }

    protected String getAbsoluteURL(String url) {
        return this.root_device.getAbsoluteURL(url);
    }

    public InetAddress getLocalAddress() {
        return this.root_device.getLocalAddress();
    }

    protected UPnPImpl getUPnP() {
        return (UPnPImpl)this.root_device.getUPnP();
    }

    public UPnPRootDevice getRootDevice() {
        return this.root_device;
    }

    public String getDeviceType() {
        return this.device_type;
    }

    public String getFriendlyName() {
        return this.friendly_name;
    }

    public UPnPDevice[] getSubDevices() {
        UPnPDevice[] res = new UPnPDevice[this.devices.size()];
        this.devices.toArray(res);
        return res;
    }

    public UPnPService[] getServices() {
        UPnPService[] res = new UPnPService[this.services.size()];
        this.services.toArray(res);
        return res;
    }
}

