/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.messages.ProtocolMessage;
import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTHave;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;

public class OutgoingBTHaveMessageAggregator {
    private final ArrayList pending_haves = new ArrayList();
    private final AEMonitor pending_haves_mon = new AEMonitor("OutgoingBTHaveMessageAggregator:PH");
    private boolean destroyed = false;
    private final OutgoingMessageQueue outgoing_message_q;
    private final OutgoingMessageQueue.MessageQueueListener added_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public void messageAdded(ProtocolMessage message) {
            if (message.getType() != 4) {
                OutgoingBTHaveMessageAggregator.this.sendPendingHaves();
            }
        }

        public void messageRemoved(ProtocolMessage message) {
        }

        public void messageSent(ProtocolMessage message) {
        }

        public void protocolBytesSent(int byte_count) {
        }

        public void dataBytesSent(int byte_count) {
        }
    };

    public OutgoingBTHaveMessageAggregator(OutgoingMessageQueue outgoing_message_q) {
        this.outgoing_message_q = outgoing_message_q;
        outgoing_message_q.registerQueueListener(this.added_message_listener);
    }

    public void queueHaveMessage(int piece_number, boolean force) {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.add(new Integer(piece_number));
            if (force) {
                this.sendPendingHaves();
            } else {
                int pending_bytes = this.pending_haves.size() * 9;
                if (pending_bytes >= NetworkManager.getSingleton().getTcpMssSize()) {
                    this.sendPendingHaves();
                }
            }
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }

    public void destroy() {
        try {
            this.pending_haves_mon.enter();
            this.pending_haves.clear();
            this.destroyed = true;
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }

    public void forceSendOfPending() {
        this.sendPendingHaves();
    }

    private void sendPendingHaves() {
        if (this.destroyed) {
            return;
        }
        try {
            this.pending_haves_mon.enter();
            int i = 0;
            while (i < this.pending_haves.size()) {
                Integer piece_num = (Integer)this.pending_haves.get(i);
                this.outgoing_message_q.addMessage(new BTHave(piece_num), true);
                ++i;
            }
            this.outgoing_message_q.doListenerNotifications();
            this.pending_haves.clear();
        }
        finally {
            this.pending_haves_mon.exit();
        }
    }
}

