/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.TransportDebugger;
import com.aelitis.azureus.core.networkmanager.TransportOwner;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.Debug;

public class Transport {
    private static boolean enable_efficient_write = System.getProperty("java.version").startsWith("1.5");
    private SocketChannel socket_channel;
    private boolean is_connected;
    private boolean is_ready_for_write;
    private boolean is_write_select_pending = false;
    private Throwable write_select_failure = null;
    private ConnectDisconnectManager.ConnectListener connect_request_key = null;
    private String description = "<disconnected>";
    private TransportDebugger transport_debugger;

    protected Transport(TransportOwner _owner) {
        this.socket_channel = null;
        this.is_connected = false;
        this.is_ready_for_write = false;
        this.transport_debugger = _owner.getDebugger();
    }

    protected Transport(TransportOwner _owner, SocketChannel channel) {
        this.socket_channel = channel;
        this.is_connected = true;
        this.is_ready_for_write = true;
        this.description = String.valueOf(channel.socket().getInetAddress().getHostAddress()) + ":" + channel.socket().getPort();
        this.transport_debugger = _owner.getDebugger();
    }

    protected SocketChannel getSocketChannel() {
        return this.socket_channel;
    }

    protected String getDescription() {
        return this.description;
    }

    protected boolean isReadyForWrite() {
        return this.is_ready_for_write;
    }

    protected long write(ByteBuffer[] buffers, int array_offset, int array_length) throws IOException {
        if (!this.is_ready_for_write) {
            return 0L;
        }
        try {
            if (this.write_select_failure != null) {
                throw new IOException("write_select_failure: " + this.write_select_failure.getMessage());
            }
            if (enable_efficient_write) {
                try {
                    long written;
                    long l = written = this.transport_debugger == null ? this.socket_channel.write(buffers, array_offset, array_length) : this.transport_debugger.write(this.socket_channel, buffers, array_offset, array_length);
                    if (written < 1L) {
                        this.requestWriteSelect();
                    }
                    return written;
                }
                catch (IOException e) {
                    if (e.getMessage().equals("A non-blocking socket operation could not be completed immediately")) {
                        enable_efficient_write = false;
                        Debug.out("ERROR: Multi-buffer socket write failed; switching to single-buffer mode. Upgrade to JRE 1.5 series to fix.");
                    }
                    throw e;
                }
            }
            long written_sofar = 0L;
            int i = array_offset;
            while (i < array_length) {
                int data_length = buffers[i].remaining();
                int written = this.transport_debugger == null ? this.socket_channel.write(buffers[i]) : this.transport_debugger.write(this.socket_channel, buffers[i]);
                written_sofar += (long)written;
                if (written < data_length) break;
                ++i;
            }
            if (written_sofar < 1L) {
                this.requestWriteSelect();
            }
            return written_sofar;
        }
        catch (IOException e) {
            this.is_ready_for_write = false;
            throw e;
        }
    }

    private void requestWriteSelect() {
        this.is_ready_for_write = false;
        this.is_write_select_pending = true;
        NetworkManager.getSingleton().getWriteController().getWriteSelector().register(this.socket_channel, new VirtualChannelSelector.VirtualSelectorListener(){

            public void selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                Transport.this.is_ready_for_write = true;
                Transport.this.is_write_select_pending = false;
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                Transport.this.is_ready_for_write = true;
                Transport.this.is_write_select_pending = false;
                Transport.this.write_select_failure = msg;
            }
        }, null);
    }

    protected void establishOutboundConnection(InetSocketAddress address, final ConnectListener listener) {
        ConnectDisconnectManager.ConnectListener connect_listener;
        if (this.is_connected) {
            System.out.println("transport already connected");
            listener.connectSuccess();
            return;
        }
        this.connect_request_key = connect_listener = new ConnectDisconnectManager.ConnectListener(){

            public void connectAttemptStarted() {
                listener.connectAttemptStarted();
            }

            public void connectSuccess(SocketChannel channel) {
                Transport.this.socket_channel = channel;
                Transport.this.is_connected = true;
                Transport.this.is_ready_for_write = true;
                Transport.this.connect_request_key = null;
                Transport.this.description = String.valueOf(channel.socket().getInetAddress().getHostAddress()) + ":" + channel.socket().getPort();
                listener.connectSuccess();
            }

            public void connectFailure(Throwable failure_msg) {
                Transport.this.socket_channel = null;
                Transport.this.is_connected = false;
                Transport.this.is_ready_for_write = false;
                Transport.this.connect_request_key = null;
                listener.connectFailure(failure_msg);
            }
        };
        NetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(address, connect_listener);
    }

    protected void close() {
        if (this.is_connected) {
            this.is_connected = false;
            if (this.is_write_select_pending) {
                NetworkManager.getSingleton().getWriteController().getWriteSelector().cancel(this.socket_channel);
                this.is_write_select_pending = false;
            }
            NetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.socket_channel);
        } else if (this.connect_request_key != null) {
            NetworkManager.getSingleton().getConnectDisconnectManager().cancelRequest(this.connect_request_key);
            this.connect_request_key = null;
        }
        this.is_ready_for_write = false;
        this.socket_channel = null;
    }

    protected interface ConnectListener {
        public void connectAttemptStarted();

        public void connectSuccess();

        public void connectFailure(Throwable var1);
    }
}

