/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.helpers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TorrentFolderWatcher {
    private GlobalManager global_manager;
    private boolean running = false;
    private final ArrayList to_delete = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TorrentFolderWatcher");
    private FilenameFilter filename_filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            String lc_name = name.toLowerCase();
            return lc_name.endsWith(".torrent") || lc_name.endsWith(".tor");
        }
    };
    private ParameterListener param_listener = new ParameterListener(){

        public void parameterChanged(String parameterName) {
            if (COConfigurationManager.getBooleanParameter("Watch Torrent Folder")) {
                if (!TorrentFolderWatcher.this.running) {
                    TorrentFolderWatcher.this.running = true;
                    TorrentFolderWatcher.this.watch_thread.setDaemon(true);
                    TorrentFolderWatcher.this.watch_thread.setPriority(1);
                    TorrentFolderWatcher.this.watch_thread.start();
                }
            } else {
                TorrentFolderWatcher.this.running = false;
            }
        }
    };
    private final Thread watch_thread = new AEThread("FolderWatcher"){

        public void runSupport() {
            while (TorrentFolderWatcher.this.running) {
                try {
                    Thread.sleep(COConfigurationManager.getIntParameter("Watch Torrent Folder Interval") * 60000);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                TorrentFolderWatcher.this.importAddedFiles();
            }
        }
    };

    public TorrentFolderWatcher(GlobalManager _global_manager) {
        this.global_manager = _global_manager;
        if (COConfigurationManager.getBooleanParameter("Watch Torrent Folder")) {
            this.running = true;
            this.watch_thread.setDaemon(true);
            this.watch_thread.setPriority(1);
            this.watch_thread.start();
        }
        COConfigurationManager.addParameterListener("Watch Torrent Folder", this.param_listener);
    }

    public void destroy() {
        this.running = false;
        this.global_manager = null;
        COConfigurationManager.removeParameterListener("Watch Torrent Folder", this.param_listener);
    }

    private void importAddedFiles() {
        try {
            this.this_mon.enter();
            if (!this.running) {
                this.this_mon.exit();
                return;
            }
            boolean save_torrents = COConfigurationManager.getBooleanParameter("Save Torrent Files");
            String torrent_save_path = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
            int start_state = COConfigurationManager.getBooleanParameter("Start Watched Torrents Stopped") ? 70 : 75;
            String folder_path = COConfigurationManager.getStringParameter("Watch Torrent Folder Path");
            String data_save_path = COConfigurationManager.getStringParameter("Default save path");
            boolean default_data_dir_enabled = COConfigurationManager.getBooleanParameter("Use default data dir") && data_save_path.length() > 0;
            File folder = null;
            if (folder_path != null && folder_path.length() > 0) {
                folder = new File(folder_path);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (!folder.isDirectory()) {
                    LGLogger.log(3, "ERROR: [Watch Torrent Folder Path] does not exist or is not a dir");
                    folder = null;
                }
            }
            if (folder == null) {
                LGLogger.log(3, "ERROR: [Watch Torrent Folder Path] not configured");
                this.this_mon.exit();
                return;
            }
            if (!default_data_dir_enabled) {
                LGLogger.log(3, "ERROR: [Use default data dir] not enabled");
                LGLogger.logUnrepeatableAlert(3, "'Save to default data dir' [Use default data dir] needs to be enabled for auto-.torrent-import to work.");
                this.this_mon.exit();
                return;
            }
            File f = new File(data_save_path);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (torrent_save_path.length() == 0 || torrent_save_path.equals(folder_path) || !new File(torrent_save_path).isDirectory()) {
                save_torrents = false;
            }
            int i = 0;
            while (i < this.to_delete.size()) {
                TOTorrent torrent = (TOTorrent)this.to_delete.get(i);
                try {
                    TorrentUtils.delete(torrent);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
            this.to_delete.clear();
            String[] currentFileList = folder.list(this.filename_filter);
            int i2 = 0;
            while (i2 < currentFileList.length) {
                File file = new File(folder, currentFileList[i2]);
                try {
                    TOTorrent torrent = TorrentUtils.readFromFile(file, false);
                    if (this.global_manager.getDownloadManager(torrent) != null) {
                        LGLogger.log(0, "INFO: " + file.getAbsolutePath() + " is already being downloaded");
                    } else {
                        if (!save_torrents) {
                            File imported = new File(folder, String.valueOf(file.getName()) + ".imported");
                            TorrentUtils.move(file, imported);
                            this.global_manager.addDownloadManager(imported.getAbsolutePath(), data_save_path, start_state);
                        } else {
                            this.global_manager.addDownloadManager(file.getAbsolutePath(), data_save_path, start_state);
                            this.to_delete.add(torrent);
                        }
                        LGLogger.log(0, "Auto-imported " + file.getAbsolutePath());
                    }
                }
                catch (Throwable e) {
                    Debug.out("Failed to auto-import torrent file '" + file.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(e));
                }
                ++i2;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

