/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheEntry;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class CacheFileWithCache
implements CacheFile {
    protected static Comparator comparator = new Comparator(){

        public int compare(Object _o1, Object _o2) {
            CacheEntry o1 = (CacheEntry)_o1;
            CacheEntry o2 = (CacheEntry)_o2;
            long offset1 = o1.getFilePosition();
            int length1 = o1.getLength();
            long offset2 = o2.getFilePosition();
            int length2 = o2.getLength();
            if (offset1 + (long)length1 > offset2 && offset2 + (long)length2 > offset1) {
                Debug.out("Overlapping cache entries - " + o1.getString() + "/" + o2.getString());
            }
            return offset1 - offset2 < 0L ? -1 : 1;
        }
    };
    protected static boolean TRACE = false;
    protected static final boolean TRACE_CACHE_CONTENTS = false;
    protected static final int READAHEAD_LOW_LIMIT = 65536;
    protected static final int READAHEAD_HIGH_LIMIT = 262144;
    protected static final int READAHEAD_HISTORY = 32;
    protected CacheFileManagerImpl manager;
    protected FMFile file;
    protected TOTorrentFile torrent_file;
    protected long file_offset_in_torrent;
    protected long[] read_history = new long[32];
    protected int read_history_next = 0;
    protected TreeSet cache = new TreeSet(comparator);
    protected int current_read_ahead_size = 0;
    protected static final int READ_AHEAD_STATS_WAIT_TICKS = 10;
    protected int read_ahead_stats_wait = 10;
    protected Average read_ahead_made_average = Average.getInstance(1000, 5);
    protected Average read_ahead_used_average = Average.getInstance(1000, 5);
    protected long read_ahead_bytes_made;
    protected long last_read_ahead_bytes_made;
    protected long read_ahead_bytes_used;
    protected long last_read_ahead_bytes_used;
    protected int piece_size = 0;
    protected int piece_offset = 0;
    protected int file_offset = 0;
    protected AEMonitor this_mon = new AEMonitor("CacheFile");

    static {
        TRACE = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.trace");
        if (TRACE) {
            System.out.println("**** Disk Cache tracing enabled ****");
        }
    }

    protected CacheFileWithCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        Arrays.fill(this.read_history, -1L);
        if (_torrent_file != null) {
            this.torrent_file = _torrent_file;
            TOTorrent torrent = this.torrent_file.getTorrent();
            this.piece_size = (int)torrent.getPieceLength();
            int i = 0;
            while (i < torrent.getFiles().length) {
                TOTorrentFile f = torrent.getFiles()[i];
                if (f == this.torrent_file) break;
                this.file_offset_in_torrent += f.getLength();
                ++i;
            }
            this.piece_offset = this.piece_size - (int)(this.file_offset_in_torrent % (long)this.piece_size);
            if (this.piece_offset == this.piece_size) {
                this.piece_offset = 0;
            }
            this.current_read_ahead_size = Math.min(65536, this.piece_size);
        }
    }

    protected void updateStats() {
        long made = this.read_ahead_bytes_made;
        long used = this.read_ahead_bytes_used;
        long made_diff = made - this.last_read_ahead_bytes_made;
        long used_diff = used - this.last_read_ahead_bytes_used;
        this.read_ahead_made_average.addValue(made_diff);
        this.read_ahead_used_average.addValue(used_diff);
        this.last_read_ahead_bytes_made = made;
        this.last_read_ahead_bytes_used = used;
        if (--this.read_ahead_stats_wait == 0) {
            this.read_ahead_stats_wait = 10;
            double made_average = this.read_ahead_made_average.getAverage();
            double used_average = this.read_ahead_used_average.getAverage();
            double ratio = used_average * 100.0 / made_average;
            if (ratio > 0.75) {
                this.current_read_ahead_size += 16384;
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, this.piece_size);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, 262144);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, (int)(this.manager.getCacheSize() / 16L));
            } else if (ratio < 0.5) {
                this.current_read_ahead_size -= 16384;
                this.current_read_ahead_size = Math.max(this.current_read_ahead_size, 65536);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readCache(DirectByteBuffer file_buffer, long file_position, boolean recursive) throws CacheFileManagerException {
        block51: {
            file_buffer_position = file_buffer.position((byte)3);
            file_buffer_limit = file_buffer.limit((byte)3);
            read_length = file_buffer_limit - file_buffer_position;
            if (!this.manager.isCacheEnabled()) break block51;
            if (CacheFileWithCache.TRACE) {
                LGLogger.log("readCache: " + this.getName() + ", " + file_position + " - " + (file_position + (long)read_length - 1L) + ":" + file_buffer_position + "/" + file_buffer_limit);
            }
            if (read_length == 0) {
                return;
            }
            writing_file_position = file_position;
            writing_left = read_length;
            ok = true;
            used_entries = 0;
            used_read_ahead = 0L;
            try {
                this.this_mon.enter();
                this.read_history[this.read_history_next++] = file_position + (long)read_length;
                if (this.read_history_next == 32) {
                    this.read_history_next = 0;
                }
                it = this.cache.iterator();
                while (ok && writing_left > 0 && it.hasNext()) {
                    entry = (CacheEntry)it.next();
                    entry_file_position = entry.getFilePosition();
                    entry_length = entry.getLength();
                    if (entry_file_position > writing_file_position) {
                        ok = false;
                        break;
                    }
                    if (entry_file_position + (long)entry_length <= writing_file_position) continue;
                    skip = (int)(writing_file_position - entry_file_position);
                    available = entry_length - skip;
                    if (available > writing_left) {
                        available = writing_left;
                    }
                    entry_buffer = entry.getBuffer();
                    entry_buffer_position = entry_buffer.position((byte)3);
                    entry_buffer_limit = entry_buffer.limit((byte)3);
                    try {
                        entry_buffer.limit((byte)3, entry_buffer_position + skip + available);
                        entry_buffer.position((byte)3, entry_buffer_position + skip);
                        if (CacheFileWithCache.TRACE) {
                            LGLogger.log("cacheRead: using " + entry.getString() + "[" + entry_buffer.position((byte)3) + "/" + entry_buffer.limit((byte)3) + "]" + "to write to [" + file_buffer.position((byte)3) + "/" + file_buffer.limit((byte)3) + "]");
                        }
                        ++used_entries;
                        file_buffer.put((byte)3, entry_buffer);
                        this.manager.cacheEntryUsed(entry);
                    }
                    finally {
                        entry_buffer.limit((byte)3, entry_buffer_limit);
                        entry_buffer.position((byte)3, entry_buffer_position);
                    }
                    writing_file_position += (long)available;
                    writing_left -= available;
                    if (entry.getType() != 1) continue;
                    used_read_ahead += (long)available;
                }
            }
            finally {
                if (ok) {
                    this.read_ahead_bytes_used += used_read_ahead;
                }
                this.this_mon.exit();
            }
            if (ok && writing_left == 0) {
                if (!recursive) {
                    this.manager.cacheBytesRead(read_length);
                }
                if (CacheFileWithCache.TRACE == false) return;
                LGLogger.log("cacheRead: cache use ok [entries = " + used_entries + "]");
                return;
            }
            if (CacheFileWithCache.TRACE) {
                LGLogger.log("cacheRead: cache use fails, reverting to plain read");
            }
            file_buffer.position((byte)3, file_buffer_position);
            i = 0;
            ** GOTO lbl81
        }
        try {
            this.getFMFile().read(file_buffer, file_position);
            this.manager.fileBytesRead(read_length);
            return;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
            return;
lbl81:
            // 1 sources

            if (true) ** GOTO lbl157
        }
        do {
            block50: {
                try {
                    v0 = do_read_ahead = i == 0 && recursive == false && this.manager.isReadCacheEnabled() != false && read_length < this.current_read_ahead_size && file_position + (long)this.current_read_ahead_size <= this.file.getLength();
                    if (do_read_ahead) {
                        do_read_ahead = false;
                        j = 0;
                        while (j < 32) {
                            if (this.read_history[j] == file_position) {
                                do_read_ahead = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    actual_read_ahead = this.current_read_ahead_size;
                    if (do_read_ahead) {
                        request_piece_offset = (int)((file_position - (long)(this.piece_offset + this.file_offset)) % (long)this.piece_size);
                        if (request_piece_offset < 0) {
                            request_piece_offset += this.piece_size;
                        }
                        if ((data_left = this.piece_size - request_piece_offset) < actual_read_ahead && (actual_read_ahead = data_left) <= read_length) {
                            do_read_ahead = false;
                        }
                    }
                    if (do_read_ahead) {
                        if (CacheFileWithCache.TRACE) {
                            LGLogger.log("\tperforming read-ahead");
                        }
                        cache_buffer = DirectByteBufferPool.getBuffer((byte)5, actual_read_ahead);
                        buffer_cached = false;
                        try {
                            entry = this.manager.allocateCacheSpace(1, this, cache_buffer, file_position, actual_read_ahead);
                            entry.setClean();
                            try {
                                this.this_mon.enter();
                                this.flushCache(file_position, actual_read_ahead, true, -1L, 0L, -1L);
                                this.getFMFile().read(cache_buffer, file_position);
                                this.read_ahead_bytes_made += (long)actual_read_ahead;
                                this.manager.fileBytesRead(actual_read_ahead);
                                cache_buffer.position((byte)3, 0);
                                this.cache.add(entry);
                                this.manager.addCacheSpace(entry);
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            buffer_cached = true;
                        }
                        finally {
                            if (!buffer_cached) {
                                cache_buffer.returnToPool();
                            }
                        }
                        this.readCache(file_buffer, file_position, true);
                        return;
                    }
                    if (CacheFileWithCache.TRACE) {
                        LGLogger.log("\tnot performing read-ahead");
                    }
                    try {
                        this.this_mon.enter();
                        this.flushCache(file_position, read_length, true, -1L, 0L, -1L);
                        this.getFMFile().read(file_buffer, file_position);
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    this.manager.fileBytesRead(read_length);
                    return;
                }
                catch (CacheFileManagerException e) {
                    if (i == 1) {
                        throw e;
                    }
                }
                catch (FMFileManagerException e) {
                    if (i != 1) break block50;
                    this.manager.rethrow(e);
                }
            }
            ++i;
lbl157:
            // 2 sources

        } while (i < 2);
    }

    protected void writeCache(DirectByteBuffer file_buffer, long file_position, boolean buffer_handed_over) throws CacheFileManagerException {
        block21: {
            boolean buffer_cached = false;
            boolean failed = false;
            try {
                try {
                    int file_buffer_position = file_buffer.position((byte)3);
                    int file_buffer_limit = file_buffer.limit((byte)3);
                    int write_length = file_buffer_limit - file_buffer_position;
                    if (write_length == 0) {
                        if (buffer_handed_over && !failed && !buffer_cached) {
                            file_buffer.returnToPool();
                        }
                        return;
                    }
                    if (this.manager.isWriteCacheEnabled()) {
                        if (TRACE) {
                            LGLogger.log("writeCache: " + this.getName() + ", " + file_position + " - " + (file_position + (long)write_length - 1L) + ":" + file_buffer_position + "/" + file_buffer_limit);
                        }
                        if (!buffer_handed_over && write_length < this.piece_size) {
                            if (TRACE) {
                                LGLogger.log("    making copy of non-handedover buffer");
                            }
                            DirectByteBuffer cache_buffer = DirectByteBufferPool.getBuffer((byte)10, write_length);
                            cache_buffer.put((byte)3, file_buffer);
                            cache_buffer.position((byte)3, 0);
                            file_buffer = cache_buffer;
                            file_buffer_position = 0;
                            file_buffer_limit = write_length;
                            buffer_handed_over = true;
                        }
                        if (buffer_handed_over) {
                            CacheEntry entry2 = this.manager.allocateCacheSpace(0, this, file_buffer, file_position, write_length);
                            try {
                                this.this_mon.enter();
                                this.flushCache(file_position, write_length, true, -1L, 0L, -1L);
                                this.cache.add(entry2);
                                this.manager.addCacheSpace(entry2);
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            this.manager.cacheBytesWritten(write_length);
                            buffer_cached = true;
                            break block21;
                        }
                        try {
                            this.this_mon.enter();
                            this.flushCache(file_position, write_length, true, -1L, 0L, -1L);
                            this.getFMFile().write(file_buffer, file_position);
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        this.manager.fileBytesWritten(write_length);
                        break block21;
                    }
                    this.getFMFile().write(file_buffer, file_position);
                    this.manager.fileBytesWritten(write_length);
                }
                catch (CacheFileManagerException e) {
                    failed = true;
                    throw e;
                }
                catch (FMFileManagerException e) {
                    failed = true;
                    this.manager.rethrow(e);
                }
            }
            finally {
                if (buffer_handed_over && !failed && !buffer_cached) {
                    file_buffer.returnToPool();
                }
            }
        }
    }

    protected void flushCache(long file_position, long length, boolean release_entries, long minimum_to_release, long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.cache.size() == 0) {
                this.this_mon.exit();
                return;
            }
            Iterator it = this.cache.iterator();
            Throwable last_failure = null;
            long entry_total_released = 0L;
            ArrayList<CacheEntry> multi_block_entries = new ArrayList<CacheEntry>();
            long multi_block_start = -1L;
            long multi_block_next = -1L;
            while (it.hasNext()) {
                int entry_length;
                CacheEntry entry2 = (CacheEntry)it.next();
                long entry_file_position = entry2.getFilePosition();
                if (entry_file_position + (long)(entry_length = entry2.getLength()) <= file_position) continue;
                if (length != -1L && file_position + length <= entry_file_position) break;
                boolean dirty = entry2.isDirty();
                try {
                    try {
                        if (!dirty || oldest_dirty_time != 0L && entry2.getLastUsed() >= oldest_dirty_time) continue;
                        if (multi_block_start == -1L) {
                            multi_block_start = entry_file_position;
                            multi_block_next = entry_file_position + (long)entry_length;
                            multi_block_entries.add(entry2);
                            continue;
                        }
                        if (multi_block_next == entry_file_position) {
                            multi_block_next = entry_file_position + (long)entry_length;
                            multi_block_entries.add(entry2);
                            continue;
                        }
                        boolean skip_chunk = false;
                        if (min_chunk_size != -1L) {
                            if (release_entries) {
                                Debug.out("CacheFile: can't use min chunk with release option");
                            } else {
                                skip_chunk = multi_block_next - multi_block_start < min_chunk_size;
                            }
                        }
                        ArrayList<CacheEntry> f_multi_block_entries = multi_block_entries;
                        long f_multi_block_start = multi_block_start;
                        long f_multi_block_next = multi_block_next;
                        multi_block_start = entry_file_position;
                        multi_block_next = entry_file_position + (long)entry_length;
                        multi_block_entries = new ArrayList();
                        multi_block_entries.add(entry2);
                        if (skip_chunk) {
                            if (!TRACE) continue;
                            LGLogger.log("flushCache: skipping " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "] as too small");
                            continue;
                        }
                        this.multiBlockFlush(f_multi_block_entries, f_multi_block_start, f_multi_block_next, release_entries);
                    }
                    catch (Throwable e) {
                        Debug.out("cacheFlush fails: " + e.getMessage());
                        last_failure = e;
                    }
                }
                finally {
                    if (release_entries) {
                        it.remove();
                        if (!dirty) {
                            this.manager.releaseCacheSpace(entry2);
                        }
                        if (minimum_to_release != -1L && (entry_total_released += (long)entry2.getLength()) > minimum_to_release) break;
                    }
                }
            }
            if (multi_block_start != -1L) {
                boolean skip_chunk = false;
                if (min_chunk_size != -1L) {
                    if (release_entries) {
                        Debug.out("CacheFile: can't use min chunk with release option");
                    } else {
                        boolean bl = skip_chunk = multi_block_next - multi_block_start < min_chunk_size;
                    }
                }
                if (skip_chunk) {
                    if (TRACE) {
                        LGLogger.log("flushCache: skipping " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "] as too small");
                    }
                } else {
                    this.multiBlockFlush(multi_block_entries, multi_block_start, multi_block_next, release_entries);
                }
            }
            if (last_failure != null) {
                if (last_failure instanceof CacheFileManagerException) {
                    throw (CacheFileManagerException)last_failure;
                }
                throw new CacheFileManagerException("cache flush failed", last_failure);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void multiBlockFlush(List multi_block_entries, long multi_block_start, long multi_block_next, boolean release_entries) throws CacheFileManagerException {
        write_ok = false;
        try {
            try {
                if (CacheFileWithCache.TRACE) {
                    LGLogger.log("multiBlockFlush: writing " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "," + release_entries + "]");
                }
                buffers = new DirectByteBuffer[multi_block_entries.size()];
                expected_per_entry_write = 0L;
                i = 0;
                while (i < buffers.length) {
                    entry = (CacheEntry)multi_block_entries.get(i);
                    buffer = entry.getBuffer();
                    if (buffer.limit((byte)3) - buffer.position((byte)3) != entry.getLength()) {
                        throw new CacheFileManagerException("flush: inconsistent entry length, position wrong");
                    }
                    expected_per_entry_write += (long)entry.getLength();
                    buffers[i] = buffer;
                    ++i;
                }
                expected_overall_write = multi_block_next - multi_block_start;
                if (expected_per_entry_write != expected_overall_write) {
                    throw new CacheFileManagerException("flush: inconsistent write length, entrys = " + expected_per_entry_write + " overall = " + expected_overall_write);
                }
                this.getFMFile().write(buffers, multi_block_start);
                this.manager.fileBytesWritten(expected_overall_write);
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                throw new CacheFileManagerException("flush fails", e);
            }
        }
        finally {
            i = 0;
            ** while (i < multi_block_entries.size())
        }
lbl-1000:
        // 1 sources

        {
            entry = (CacheEntry)multi_block_entries.get(i);
            if (release_entries) {
                this.manager.releaseCacheSpace(entry);
            } else {
                entry.resetBufferPosition();
                if (write_ok) {
                    entry.setClean();
                }
            }
            ++i;
            continue;
        }
lbl39:
        // 1 sources

    }

    protected void flushCache(long file_start_position, boolean release_entries, long minumum_to_release) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                LGLogger.log("flushCache: " + this.getName() + ", rel = " + release_entries + ", min = " + minumum_to_release);
            }
            this.flushCache(file_start_position, -1L, release_entries, minumum_to_release, 0L, -1L);
        }
    }

    protected void flushCache(boolean release_entries, long minumum_to_release) throws CacheFileManagerException {
        this.flushCache(0L, release_entries, minumum_to_release);
    }

    protected void flushOldDirtyData(long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                LGLogger.log("flushOldDirtyData: " + this.getName());
            }
            this.flushCache(0L, -1L, false, -1L, oldest_dirty_time, min_chunk_size);
        }
    }

    protected void flushOldDirtyData(long oldest_dirty_time) throws CacheFileManagerException {
        this.flushOldDirtyData(oldest_dirty_time, -1L);
    }

    protected long getBytesInCache(long offset, long length) {
        try {
            this.this_mon.enter();
            long result = 0L;
            Iterator it = this.cache.iterator();
            long start_pos = offset;
            long end_pos = offset + length;
            while (it.hasNext()) {
                int entry_length;
                CacheEntry entry2 = (CacheEntry)it.next();
                long this_start = entry2.getFilePosition();
                long this_end = this_start + (long)(entry_length = entry2.getLength());
                if (this_end <= start_pos) continue;
                if (end_pos <= this_start) break;
                long bit_start = start_pos < this_start ? this_start : start_pos;
                long bit_end = end_pos >= this_end ? this_end : end_pos;
                result += bit_end - bit_start;
            }
            long l = result;
            this.this_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected String getName() {
        return this.file.getFile().toString();
    }

    protected FMFile getFMFile() {
        return this.file;
    }

    protected TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public File getFile() {
        return this.file.getFile();
    }

    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            this.flushCache(true, -1L);
            this.file.moveFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            if (this.getAccessMode() != mode) {
                this.flushCache(false, -1L);
            }
            this.file.setAccessMode(mode == 1 ? 1 : 2);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public int getAccessMode() {
        return this.file.getAccessMode() == 1 ? 1 : 2;
    }

    public void ensureOpen() throws CacheFileManagerException {
        try {
            this.file.ensureOpen();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.file.getSize();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
            return 0L;
        }
    }

    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.flushCache(true, -1L);
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(e);
        }
    }

    public void read(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.readCache(buffer, position, false);
    }

    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.writeCache(buffer, position, false);
    }

    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.writeCache(buffer, position, true);
    }

    public void flushCache() throws CacheFileManagerException {
        this.flushCache(false, -1L);
    }

    public void clearCache() throws CacheFileManagerException {
        this.flushCache(true, -1L);
    }

    public void close() throws CacheFileManagerException {
        boolean fm_file_closed = false;
        try {
            try {
                this.flushCache(true, -1L);
                this.file.close();
                fm_file_closed = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(e);
            }
        }
        finally {
            if (!fm_file_closed) {
                try {
                    this.file.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.manager.closeFile(this);
        }
    }

    public void setFileOffset(int _file_offset) {
        this.file_offset = _file_offset;
    }
}

