/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientstats;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class StreamDecoder {
    private String HANDSHAKE;
    private ByteBuffer handshake_buffer;
    private boolean handshaking = true;
    private ByteBuffer payload_length_buffer;
    private boolean reading_payload_length = true;
    private ByteBuffer payload_buffer;

    public StreamDecoder(String handshake_key) {
        this.HANDSHAKE = handshake_key;
        this.handshake_buffer = ByteBuffer.allocate(1 + this.HANDSHAKE.getBytes().length);
    }

    public ByteBuffer decode(SocketChannel channel) throws IOException {
        if (this.handshaking) {
            if (channel.read(this.handshake_buffer) < 0) {
                throw new IOException("end of stream");
            }
            if (!this.handshake_buffer.hasRemaining()) {
                this.handshake_buffer.flip();
                if (this.handshake_buffer.get() != (byte)this.HANDSHAKE.length()) {
                    throw new IOException("decode: invalid handshake length");
                }
                String payload = new String(this.handshake_buffer.array(), 1, this.handshake_buffer.limit() - 1);
                if (!payload.equals(this.HANDSHAKE)) {
                    throw new IOException("decode: invalid handshake key");
                }
                this.HANDSHAKE = null;
                this.handshake_buffer = null;
                this.payload_length_buffer = ByteBuffer.allocate(4);
                this.handshaking = false;
            }
        }
        if (!this.handshaking) {
            if (this.reading_payload_length) {
                if (channel.read(this.payload_length_buffer) < 0) {
                    throw new IOException("end of stream");
                }
                if (!this.payload_length_buffer.hasRemaining()) {
                    this.payload_length_buffer.flip();
                    int size = this.payload_length_buffer.getInt();
                    if (size < 0 || size > 262144) {
                        throw new IOException("decode: invalid payload size: " + size);
                    }
                    this.payload_buffer = ByteBuffer.allocate(size);
                    this.payload_length_buffer = null;
                    this.reading_payload_length = false;
                }
            }
            if (!this.reading_payload_length) {
                if (channel.read(this.payload_buffer) < 0) {
                    throw new IOException("end of stream");
                }
                if (!this.payload_buffer.hasRemaining()) {
                    this.payload_buffer.flip();
                    return this.payload_buffer;
                }
            }
        }
        return null;
    }
}

