/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    int modelHandle;
    int checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int lastDataIndex = -1;
    int ignoreTextCell;
    int ignorePixbufCell;
    TableItem[] items;
    TableColumn[] columns;
    ImageList imageList;
    boolean firstCustomDraw;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    TableItem _getItem(int index) {
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, index, false);
        return this.items[index];
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int textCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        if (cell == this.ignoreTextCell) {
            return 0;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 5;
            customDraw = this.firstCustomDraw;
        } else {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null && this.columns[i].handle == tree_column) {
                    modelIndex = this.columns[i].modelIndex;
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if (modelIndex == -1) {
            return 0;
        }
        boolean setData = this.setCellData(tree_model, iter);
        int[] ptr = new int[1];
        if (setData) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 1), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.text, (int)ptr[0], (int)0);
                OS.g_free((int)ptr[0]);
            }
            ptr = new int[1];
        }
        if (customDraw) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 2), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.foreground_gdk, (int)ptr[0], (int)0);
            }
            ptr = new int[1];
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 3), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.background_gdk, (int)ptr[0], (int)0);
            }
            ptr = new int[1];
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 4), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.font_desc, (int)ptr[0], (int)0);
            }
        }
        if (setData) {
            this.ignoreTextCell = cell;
            this.setScrollWidth(tree_column, iter);
            this.ignoreTextCell = 0;
        }
        return 0;
    }

    int pixbufCellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        if (cell == this.ignorePixbufCell) {
            return 0;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 5;
            customDraw = this.firstCustomDraw;
        } else {
            int i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null && this.columns[i].handle == tree_column) {
                    modelIndex = this.columns[i].modelIndex;
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if (modelIndex == -1) {
            return 0;
        }
        boolean setData = this.setCellData(tree_model, iter);
        int[] ptr = new int[1];
        if (setData) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)modelIndex, (int[])ptr, (int)-1);
            OS.g_object_set((int)cell, (byte[])OS.pixbuf, (int)ptr[0], (int)0);
            ptr = new int[1];
        }
        if (customDraw) {
            OS.gtk_tree_model_get((int)tree_model, (int)iter, (int)(modelIndex + 3), (int[])ptr, (int)-1);
            if (ptr[0] != 0) {
                OS.g_object_set((int)cell, (byte[])OS.cell_background_gdk, (int)ptr[0], (int)0);
            }
        }
        if (setData) {
            this.ignorePixbufCell = cell;
            this.setScrollWidth(tree_column, iter);
            this.ignorePixbufCell = 0;
        }
        return 0;
    }

    int calculateWidth(int column, int iter) {
        OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.modelHandle, (int)iter, (boolean)false, (boolean)false);
        int[] width = new int[1];
        OS.gtk_tree_view_column_cell_get_size((int)column, null, null, null, (int[])width, null);
        return width[0];
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int i = start;
            while (i <= end) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.clear();
                }
                ++i;
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            TableItem item = this.items[indices[i]];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new((int)this.display.gtk_fixed_get_type(), (int)0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.scrolledHandle = OS.gtk_scrolled_window_new((int)0, (int)0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv((int)types.length, (int[])types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model((int)this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref((int)this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.scrolledHandle);
        OS.gtk_container_add((int)this.scrolledHandle, (int)this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_set_mode((int)selectionHandle, (int)mode);
        OS.gtk_tree_view_set_headers_visible((int)this.handle, (boolean)false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy((int)this.scrolledHandle, (int)hsp, (int)vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type((int)this.scrolledHandle, (int)3);
        }
        if ((this.style & 0x10000000) != 0 && OS.gtk_major_version() * 100 + OS.gtk_minor_version() * 10 + OS.gtk_micro_version() >= 232) {
            OS.g_object_set((int)this.handle, (byte[])OS.fixed_height_mode, (boolean)true, (int)0);
        }
    }

    void createColumn(TableColumn column, int index) {
        int columnHandle;
        int modelIndex = 5;
        if (this.columnCount != 0) {
            int modelLength = OS.gtk_tree_model_get_n_columns((int)this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            int i = 0;
            while (i < this.columnCount) {
                int columnIndex = this.columns[i].modelIndex;
                usedColumns[columnIndex + 4] = true;
                usedColumns[columnIndex + 3] = true;
                usedColumns[columnIndex + 2] = true;
                usedColumns[columnIndex + 1] = true;
                usedColumns[columnIndex] = true;
                ++i;
            }
            while (modelIndex < modelLength) {
                if (!usedColumns[modelIndex]) break;
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                int oldModel = this.modelHandle;
                int[] types = this.getColumnTypes(this.columnCount + 5);
                int newModel = OS.gtk_list_store_newv((int)types.length, (int[])types);
                if (newModel == 0) {
                    this.error(2);
                }
                int[] ptr = new int[1];
                int i2 = 0;
                while (i2 < this.itemCount) {
                    int newItem = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
                    if (newItem == 0) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append((int)newModel, (int)newItem);
                    TableItem item = this.items[i2];
                    if (item != null) {
                        int oldItem = item.handle;
                        int j = 0;
                        while (j < modelLength) {
                            OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)j, (int[])ptr, (int)-1);
                            OS.gtk_list_store_set((int)newModel, (int)newItem, (int)j, (int)ptr[0], (int)-1);
                            if (types[j] == OS.G_TYPE_STRING()) {
                                OS.g_free((int)ptr[0]);
                            }
                            ++j;
                        }
                        OS.gtk_list_store_remove((int)oldModel, (int)oldItem);
                        OS.g_free((int)oldItem);
                        item.handle = newItem;
                    } else {
                        OS.g_free((int)newItem);
                    }
                    ++i2;
                }
                OS.gtk_tree_view_set_model((int)this.handle, (int)newModel);
                OS.g_object_unref((int)oldModel);
                this.modelHandle = newModel;
            }
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TableColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing((int)columnHandle, (int)1);
        } else {
            OS.gtk_tree_view_column_set_sizing((int)columnHandle, (int)2);
            OS.gtk_tree_view_column_set_fixed_width((int)columnHandle, (int)10);
        }
        OS.gtk_tree_view_column_set_resizable((int)columnHandle, (boolean)true);
        OS.gtk_tree_view_column_set_clickable((int)columnHandle, (boolean)true);
        OS.gtk_tree_view_insert_column((int)this.handle, (int)columnHandle, (int)index);
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
    }

    void createRenderers(int columnHandle, int modelIndex, boolean check, int columnStyle) {
        int textRenderer;
        int pixbufRenderer;
        OS.gtk_tree_view_column_clear((int)columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)this.checkRenderer, (boolean)false);
            OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)this.checkRenderer, (String)"active", (int)0);
            OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)this.checkRenderer, (String)"cell-background-gdk", (int)3);
            if (OS.gtk_major_version() > 2 || OS.gtk_major_version() == 2 && OS.gtk_minor_version() >= 2) {
                OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)this.checkRenderer, (String)"inconsistent", (int)1);
            }
        }
        if ((pixbufRenderer = OS.gtk_cell_renderer_pixbuf_new()) == 0) {
            this.error(2);
        }
        if ((textRenderer = OS.gtk_cell_renderer_text_new()) == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set((int)pixbufRenderer, (byte[])OS.mode, (int)1, (int)0);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set((int)textRenderer, (byte[])OS.xalign, (float)1.0f, (int)0);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)pixbufRenderer, (boolean)false);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)textRenderer, (boolean)true);
            OS.gtk_tree_view_column_set_alignment((int)columnHandle, (float)1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set((int)textRenderer, (byte[])OS.xalign, (float)0.5f, (int)0);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)pixbufRenderer, (boolean)false);
            OS.gtk_tree_view_column_pack_end((int)columnHandle, (int)textRenderer, (boolean)true);
            OS.gtk_tree_view_column_set_alignment((int)columnHandle, (float)0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)pixbufRenderer, (boolean)false);
            OS.gtk_tree_view_column_pack_start((int)columnHandle, (int)textRenderer, (boolean)true);
            OS.gtk_tree_view_column_set_alignment((int)columnHandle, (float)0.0f);
        }
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)pixbufRenderer, (String)"pixbuf", (int)modelIndex);
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)pixbufRenderer, (String)"cell-background-gdk", (int)3);
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (String)"text", (int)(modelIndex + 1));
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (String)"foreground-gdk", (int)2);
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (String)"background-gdk", (int)3);
        OS.gtk_tree_view_column_add_attribute((int)columnHandle, (int)textRenderer, (String)"font-desc", (int)4);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw) {
            OS.gtk_tree_view_column_set_cell_data_func((int)columnHandle, (int)textRenderer, (int)this.display.textCellDataProc, (int)this.handle, (int)0);
            OS.gtk_tree_view_column_set_cell_data_func((int)columnHandle, (int)pixbufRenderer, (int)this.display.pixbufCellDataProc, (int)this.handle, (int)0);
        }
    }

    void createItem(TableColumn column, int index) {
        int imageHandle;
        int labelHandle;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            column.handle = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
            OS.gtk_tree_view_column_set_sizing((int)column.handle, (int)2);
            OS.gtk_tree_view_column_set_fixed_width((int)column.handle, (int)10);
            column.modelIndex = 5;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        int boxHandle = OS.gtk_hbox_new((boolean)false, (int)3);
        if (boxHandle == 0) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)boxHandle, (int)imageHandle);
        OS.gtk_container_add((int)boxHandle, (int)labelHandle);
        OS.gtk_widget_show((int)boxHandle);
        OS.gtk_widget_show((int)labelHandle);
        column.boxHandle = boxHandle;
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        OS.gtk_tree_view_column_set_widget((int)column.handle, (int)boxHandle);
        int widget = OS.gtk_widget_get_parent((int)boxHandle);
        while (widget != this.handle) {
            if (OS.GTK_IS_BUTTON((int)widget)) {
                column.buttonHandle = widget;
                break;
            }
            widget = OS.gtk_widget_get_parent((int)widget);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        column.setFontDescription(this.getFontDescription());
    }

    void createItem(TableItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int length = this.drawCount == 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.handle = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        if (item.handle == 0) {
            this.error(2);
        }
        if (index == this.itemCount) {
            OS.gtk_list_store_append((int)this.modelHandle, (int)item.handle);
        } else {
            OS.gtk_list_store_insert((int)this.modelHandle, (int)item.handle, (int)index);
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection((int)this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_unselect_iter((int)selection, (int)this._getItem((int)index).handle);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int index = start;
        while (index <= end) {
            if (index >= 0 && index < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter((int)selection, (int)this._getItem((int)index).handle);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter((int)selection, (int)this._getItem((int)index).handle);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void deselectAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_unselect_all((int)selection);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    void destroyItem(TableColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == this.columnCount) {
            return;
        }
        int columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        column.deregister();
        OS.gtk_tree_view_remove_column((int)this.handle, (int)columnHandle);
        if (this.columnCount == 0) {
            int oldModel = this.modelHandle;
            int[] types = this.getColumnTypes(1);
            int newModel = OS.gtk_list_store_newv((int)types.length, (int[])types);
            if (newModel == 0) {
                this.error(2);
            }
            int[] ptr = new int[1];
            int i = 0;
            while (i < this.itemCount) {
                int newItem = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
                if (newItem == 0) {
                    this.error(2);
                }
                OS.gtk_list_store_append((int)newModel, (int)newItem);
                TableItem item = this.items[i];
                if (item != null) {
                    int oldItem = item.handle;
                    int j = 0;
                    while (j < 5) {
                        OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)j, (int[])ptr, (int)-1);
                        OS.gtk_list_store_set((int)newModel, (int)newItem, (int)j, (int)ptr[0], (int)-1);
                        ++j;
                    }
                    OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)column.modelIndex, (int[])ptr, (int)-1);
                    OS.gtk_list_store_set((int)newModel, (int)newItem, (int)5, (int)ptr[0], (int)-1);
                    OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)(column.modelIndex + 1), (int[])ptr, (int)-1);
                    OS.gtk_list_store_set((int)newModel, (int)newItem, (int)6, (int)ptr[0], (int)-1);
                    OS.g_free((int)ptr[0]);
                    OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)(column.modelIndex + 2), (int[])ptr, (int)-1);
                    OS.gtk_list_store_set((int)newModel, (int)newItem, (int)7, (int)ptr[0], (int)-1);
                    OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)(column.modelIndex + 3), (int[])ptr, (int)-1);
                    OS.gtk_list_store_set((int)newModel, (int)newItem, (int)8, (int)ptr[0], (int)-1);
                    OS.gtk_tree_model_get((int)oldModel, (int)oldItem, (int)(column.modelIndex + 4), (int[])ptr, (int)-1);
                    OS.gtk_list_store_set((int)newModel, (int)newItem, (int)9, (int)ptr[0], (int)-1);
                    OS.gtk_list_store_remove((int)oldModel, (int)oldItem);
                    OS.g_free((int)oldItem);
                    item.handle = newItem;
                } else {
                    OS.g_free((int)newItem);
                }
                ++i;
            }
            OS.gtk_tree_view_set_model((int)this.handle, (int)newModel);
            OS.g_object_unref((int)oldModel);
            this.modelHandle = newModel;
            this.createColumn(null, 0);
        } else {
            int i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    int iter = item.handle;
                    int modelIndex = column.modelIndex;
                    OS.gtk_list_store_set((int)this.modelHandle, (int)iter, (int)modelIndex, (int)0, (int)-1);
                    OS.gtk_list_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 1), (int)0, (int)-1);
                    OS.gtk_list_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 2), (int)0, (int)-1);
                    OS.gtk_list_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 3), (int)0, (int)-1);
                    OS.gtk_list_store_set((int)this.modelHandle, (int)iter, (int)(modelIndex + 4), (int)0, (int)-1);
                }
                ++i;
            }
            if (index == 0) {
                TableColumn checkColumn = this.columns[0];
                this.createRenderers(checkColumn.handle, checkColumn.modelIndex, true, checkColumn.style);
            }
        }
        column.labelHandle = 0;
        column.buttonHandle = 0;
        column.handle = 0;
        column.imageHandle = 0;
        column.boxHandle = 0;
    }

    void destroyItem(TableItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        int itemHandle = item.handle;
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_list_store_remove((int)this.modelHandle, (int)itemHandle);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.g_free((int)itemHandle);
        item.handle = 0;
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        this.lastDataIndex = -1;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(8);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    int[] getColumnTypes(int n) {
        int[] types = new int[n * 5 + 5];
        types[0] = OS.G_TYPE_BOOLEAN();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.GDK_TYPE_COLOR();
        types[3] = OS.GDK_TYPE_COLOR();
        types[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int i = 5;
        while (i < types.length) {
            types[i + 0] = OS.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = OS.GDK_TYPE_COLOR();
            types[i + 3] = OS.GDK_TYPE_COLOR();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            i += 5;
        }
        return types;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    TableItem getFocusItem() {
        int[] path = new int[1];
        OS.gtk_tree_view_get_cursor((int)this.handle, (int[])path, null);
        if (path[0] == 0) {
            return null;
        }
        TableItem item = null;
        int indices = OS.gtk_tree_path_get_indices((int)path[0]);
        if (indices != 0) {
            int[] index = new int[]{-1};
            OS.memmove((int[])index, (int)indices, (int)4);
            item = this._getItem(index[0]);
        }
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible((int)this.handle)) {
            return 0;
        }
        OS.gtk_widget_realize((int)this.handle);
        int fixedWindow = OS.GTK_WIDGET_WINDOW((int)this.fixedHandle);
        int binWindow = OS.gtk_tree_view_get_bin_window((int)this.handle);
        int[] binY = new int[1];
        OS.gdk_window_get_origin((int)binWindow, null, (int[])binY);
        int[] fixedY = new int[1];
        OS.gdk_window_get_origin((int)fixedWindow, null, (int[])fixedY);
        return binY[0] - fixedY[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible((int)this.handle);
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point pt) {
        this.checkWidget();
        int[] path = new int[1];
        int clientX = pt.x - this.getBorderWidth();
        int clientY = pt.y - this.getHeaderHeight();
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)clientX, (int)clientY, (int[])path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        int indices = OS.gtk_tree_path_get_indices((int)path[0]);
        TableItem item = null;
        if (indices != 0) {
            int[] index = new int[1];
            OS.memmove((int[])index, (int)indices, (int)4);
            item = this._getItem(index[0]);
        }
        OS.gtk_tree_path_free((int)path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            int column = OS.gtk_tree_view_get_column((int)this.handle, (int)0);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size((int)column, null, null, null, (int[])w, (int[])h);
            return h[0];
        }
        int height = 0;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first((int)this.modelHandle, (int)iter);
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            int column = OS.gtk_tree_view_get_column((int)this.handle, (int)i);
            OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.modelHandle, (int)iter, (boolean)false, (boolean)false);
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size((int)column, null, null, null, (int[])w, (int[])h);
            height = Math.max(height, h[0]);
            ++i;
        }
        OS.g_free((int)iter);
        return height;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint((int)this.handle);
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        this.display.treeSelectionLength = 0;
        this.display.treeSelection = new int[this.itemCount];
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
        TableItem[] result = new TableItem[this.display.treeSelectionLength];
        int i = 0;
        while (i < result.length) {
            result[i] = this._getItem(this.display.treeSelection[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        this.display.treeSelectionLength = 0;
        this.display.treeSelection = null;
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
        return this.display.treeSelectionLength;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        this.display.treeSelectionLength = 0;
        this.display.treeSelection = new int[this.itemCount];
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
        if (this.display.treeSelectionLength == 0) {
            return -1;
        }
        return this.display.treeSelection[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        this.display.treeSelectionLength = 0;
        this.display.treeSelection = new int[this.itemCount];
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.gtk_tree_selection_selected_foreach((int)selection, (int)this.display.treeSelectionProc, (int)this.handle);
        if (this.display.treeSelectionLength == this.display.treeSelection.length) {
            return this.display.treeSelection;
        }
        int[] result = new int[this.display.treeSelectionLength];
        System.arraycopy(this.display.treeSelection, 0, result, 0, this.display.treeSelectionLength);
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_widget_realize((int)this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)1, (int)1, (int[])path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0) {
            return 0;
        }
        int indices = OS.gtk_tree_path_get_indices((int)path[0]);
        int[] index = new int[1];
        if (indices != 0) {
            OS.memmove((int[])index, (int)indices, (int)4);
        }
        OS.gtk_tree_path_free((int)path[0]);
        return index[0];
    }

    int gtk_button_press_event(int widget, int event) {
        int selection;
        int[] path;
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window((int)this.handle)) {
            return 0;
        }
        int border = this.getBorderWidth();
        int headerHeight = this.getHeaderHeight();
        gdkEvent.x += (double)border;
        gdkEvent.y += (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        int result = super.gtk_button_press_event(widget, event);
        gdkEvent.x -= (double)border;
        gdkEvent.y -= (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        if (result != 0) {
            return result;
        }
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y), (int[])(path = new int[1]), null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection((int)this.handle);
            if (OS.gtk_tree_selection_path_is_selected((int)selection, (int)path[0])) {
                result = 1;
            }
            OS.gtk_tree_path_free((int)path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos((int)this.handle, (int)((int)gdkEvent.x), (int)((int)gdkEvent.y), (int[])(path = new int[1]), null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection((int)this.handle);
            OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_tree_view_set_cursor((int)this.handle, (int)path[0], (int)0, (boolean)false);
            OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_tree_path_free((int)path[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS((int)this.handle)) {
            OS.gtk_widget_grab_focus((int)this.handle);
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window((int)this.handle)) {
            return 0;
        }
        int border = this.getBorderWidth();
        int headerHeight = this.getHeaderHeight();
        gdkEvent.x += (double)border;
        gdkEvent.y += (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        int result = super.gtk_button_release_event(widget, event);
        gdkEvent.x -= (double)border;
        gdkEvent.y -= (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        return result;
    }

    int gtk_changed(int widget) {
        TableItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.postEvent(13, event);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int eventPtr) {
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove((GdkEventKey)keyEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.item = this.getFocusItem();
                this.postEvent(14, event);
            }
        }
        return result;
    }

    int gtk_motion_notify_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (gdkEvent.window != OS.gtk_tree_view_get_bin_window((int)this.handle)) {
            return 0;
        }
        int border = this.getBorderWidth();
        int headerHeight = this.getHeaderHeight();
        gdkEvent.x += (double)border;
        gdkEvent.y += (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        int result = super.gtk_motion_notify_event(widget, event);
        gdkEvent.x -= (double)border;
        gdkEvent.y -= (double)headerHeight;
        OS.memmove((int)event, (GdkEventButton)gdkEvent, (int)GdkEventButton.sizeof);
        return result;
    }

    int gtk_row_activated(int tree, int path, int column) {
        TableItem item = null;
        int indices = OS.gtk_tree_path_get_indices((int)path);
        if (indices != 0) {
            int[] index = new int[]{-1};
            OS.memmove((int[])index, (int)indices, (int)4);
            item = this._getItem(index[0]);
        }
        Event event = new Event();
        event.item = item;
        this.postEvent(14, event);
        return 0;
    }

    int gtk_toggled(int renderer, int pathStr) {
        int path = OS.gtk_tree_path_new_from_string((int)pathStr);
        if (path == 0) {
            return 0;
        }
        int indices = OS.gtk_tree_path_get_indices((int)path);
        if (indices != 0) {
            int[] index = new int[1];
            OS.memmove((int[])index, (int)indices, (int)4);
            TableItem item = this._getItem(index[0]);
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.postEvent(13, event);
        }
        OS.gtk_tree_path_free((int)path);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_connect((int)selection, (byte[])OS.changed, (int)this.display.windowProc2, (int)4);
        OS.g_signal_connect((int)this.handle, (byte[])OS.row_activated, (int)this.display.windowProc4, (int)31);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect((int)this.checkRenderer, (byte[])OS.toggled, (int)this.display.windowProc3, (int)41);
        }
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = this.itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        byte[] buffer = Converter.wcsToMbcs(null, Integer.toString(index), true);
        int path = OS.gtk_tree_path_new_from_string((byte[])buffer);
        boolean answer = OS.gtk_tree_selection_path_is_selected((int)selection, (int)path);
        OS.gtk_tree_path_free((int)path);
        return answer;
    }

    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int paintWindow() {
        OS.gtk_widget_realize((int)this.handle);
        return OS.gtk_tree_view_get_bin_window((int)this.handle);
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            if (!column.isDisposed()) {
                column.releaseResources();
            }
            ++i;
        }
        this.columns = null;
        i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref((int)this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref((int)this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
            this.imageList = null;
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection((int)this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index > this.itemCount) {
            this.error(15);
        }
        TableItem item = this.items[index];
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        if (item != null && !item.isDisposed()) {
            OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_list_store_remove((int)this.modelHandle, (int)item.handle);
            OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            item.releaseResources();
        } else {
            int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child((int)this.modelHandle, (int)iter, (int)0, (int)index);
            OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_list_store_remove((int)this.modelHandle, (int)iter);
            OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_free((int)iter);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child((int)this.modelHandle, (int)iter, (int)0, (int)start);
        int index = start;
        while (index <= end) {
            TableItem item = this.items[index];
            OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_list_store_remove((int)this.modelHandle, (int)iter);
            OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++index;
        }
        OS.g_free((int)iter);
        System.arraycopy(this.items, index, this.items, start, this.itemCount - index);
        int i = this.itemCount - (index - start);
        while (i < this.itemCount) {
            this.items[i] = null;
            ++i;
        }
        this.itemCount -= index - start;
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        int last = -1;
        int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                TableItem item = this.items[index];
                if (item != null && !item.isDisposed()) {
                    OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
                    OS.gtk_list_store_remove((int)this.modelHandle, (int)item.handle);
                    OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
                    item.releaseResources();
                } else {
                    OS.gtk_tree_model_iter_nth_child((int)this.modelHandle, (int)iter, (int)0, (int)index);
                    OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
                    OS.gtk_list_store_remove((int)this.modelHandle, (int)iter);
                    OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
                }
                System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
                this.items[this.itemCount] = null;
                last = index;
            }
            ++i;
        }
        OS.g_free((int)iter);
    }

    public void removeAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int oldModel = this.modelHandle;
        int[] types = this.getColumnTypes(Math.max(1, this.columnCount));
        int newModel = OS.gtk_list_store_newv((int)types.length, (int[])types);
        if (newModel == 0) {
            this.error(2);
        }
        OS.gtk_tree_view_set_model((int)this.handle, (int)newModel);
        OS.g_object_unref((int)oldModel);
        this.modelHandle = newModel;
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int index = this.itemCount - 1;
        while (index >= 0) {
            TableItem item = this.items[index];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            --index;
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        this.resetCustomDraw();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        int i = 0;
        while (i < end) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (customDraw) {
                int column = OS.gtk_tree_view_get_column((int)this.handle, (int)i);
                int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
                int length = OS.g_list_length((int)list);
                int renderer = OS.g_list_nth_data((int)list, (int)(length - 1));
                OS.g_list_free((int)list);
                OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)renderer, (int)0, (int)0, (int)0);
                if (this.columnCount != 0) {
                    this.columns[i].customDraw = false;
                }
            }
            ++i;
        }
        this.firstCustomDraw = false;
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        TableItem item = this._getItem(index);
        OS.gtk_tree_selection_select_iter((int)selection, (int)item.handle);
        if ((this.style & 4) != 0) {
            int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
            OS.gtk_tree_view_set_cursor((int)this.handle, (int)path, (int)0, (boolean)false);
            OS.gtk_tree_path_free((int)path);
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int index = start;
        while (index <= end) {
            TableItem item = this._getItem(index);
            OS.gtk_tree_selection_select_iter((int)selection, (int)item.handle);
            if ((this.style & 4) != 0) {
                int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
                OS.gtk_tree_view_set_cursor((int)this.handle, (int)path, (int)0, (boolean)false);
                OS.gtk_tree_path_free((int)path);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                TableItem item = this._getItem(index);
                OS.gtk_tree_selection_select_iter((int)selection, (int)item.handle);
                if ((this.style & 4) != 0) {
                    int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)item.handle);
                    OS.gtk_tree_view_set_cursor((int)this.handle, (int)path, (int)0, (boolean)false);
                    OS.gtk_tree_path_free((int)path);
                    break;
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection((int)this.handle);
        OS.g_signal_handlers_block_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
        OS.gtk_tree_selection_select_all((int)selection);
        OS.g_signal_handlers_unblock_matched((int)selection, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base((int)this.handle, (int)0, (GdkColor)color);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize((int)this.handle);
        return result;
    }

    boolean setCellData(int tree_model, int iter) {
        if ((this.style & 0x10000000) != 0) {
            int[] index = new int[1];
            int path = OS.gtk_tree_model_get_path((int)tree_model, (int)iter);
            OS.memmove((int[])index, (int)OS.gtk_tree_path_get_indices((int)path), (int)4);
            OS.gtk_tree_path_free((int)path);
            if (this.lastDataIndex != index[0]) {
                this.lastDataIndex = this.lastIndexOf = index[0];
                TableItem item = this._getItem(index[0]);
                if (!item.cached) {
                    Event event = new Event();
                    event.item = item;
                    int mask = 17;
                    int signal_id = OS.g_signal_lookup((byte[])OS.row_changed, (int)OS.gtk_tree_model_get_type());
                    OS.g_signal_handlers_block_matched((int)tree_model, (int)mask, (int)signal_id, (int)0, (int)0, (int)0, (int)this.handle);
                    this.sendEvent(36, event);
                    if (this.isDisposed()) {
                        return false;
                    }
                    OS.g_signal_handlers_unblock_matched((int)tree_model, (int)mask, (int)signal_id, (int)0, (int)0, (int)0, (int)this.handle);
                    item.cached = true;
                    return true;
                }
            }
        }
        return false;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        TableColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                columns[i].setFontDescription(font);
            }
            ++i;
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible((int)this.handle, (boolean)show);
    }

    public void setItemCount(int count) {
        boolean isVirtual;
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        this.remove(count, this.itemCount - 1);
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
        this.items = newItems;
        if (isVirtual) {
            int iter = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            if (iter == 0) {
                this.error(2);
            }
            int i = this.itemCount;
            while (i < count) {
                OS.gtk_list_store_append((int)this.modelHandle, (int)iter);
                ++i;
            }
            OS.g_free((int)iter);
            this.itemCount = count;
        } else {
            int i = this.itemCount;
            while (i < count) {
                this.items[i] = new TableItem(this, 0, i, true);
                ++i;
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint((int)this.handle, (boolean)show);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int length = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
            this.items = newItems;
        }
    }

    void setScrollWidth(int column, int iter) {
        int itemWidth;
        if (this.columnCount != 0) {
            return;
        }
        int width = OS.gtk_tree_view_column_get_width((int)column);
        if (width < (itemWidth = this.calculateWidth(column, iter))) {
            OS.gtk_tree_view_column_set_fixed_width((int)column, (int)itemWidth);
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        this.select(start, end);
        this.showSelection();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        this.showSelection();
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int index = this.indexOf(items[i]);
            if (index != -1) {
                this.select(index);
            }
            --i;
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)this._getItem((int)index).handle);
        OS.gtk_tree_view_scroll_to_cell((int)this.handle, (int)path, (int)0, (boolean)true, (float)0.0f, (float)0.0f);
        OS.gtk_tree_path_free((int)path);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        OS.gtk_widget_realize((int)this.handle);
        GdkRectangle cellRect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area((int)this.handle, (int)0, (int)column.handle, (GdkRectangle)cellRect);
        GdkRectangle visibleRect = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect((int)this.handle, (GdkRectangle)visibleRect);
        if (cellRect.x < visibleRect.x) {
            OS.gtk_tree_view_scroll_to_point((int)this.handle, (int)cellRect.x, (int)-1);
        } else {
            int width = Math.min(visibleRect.width, cellRect.width);
            if (cellRect.x + width > visibleRect.x + visibleRect.width) {
                int tree_x = cellRect.x + width - visibleRect.width;
                OS.gtk_tree_view_scroll_to_point((int)this.handle, (int)tree_x, (int)-1);
            }
        }
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        this.showItem(item.handle);
    }

    void showItem(int iter) {
        int path = OS.gtk_tree_model_get_path((int)this.modelHandle, (int)iter);
        OS.gtk_tree_view_scroll_to_cell((int)this.handle, (int)path, (int)0, (boolean)false, (float)0.0f, (float)0.0f);
        OS.gtk_tree_path_free((int)path);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] selection = this.getSelection();
        if (selection.length == 0) {
            return;
        }
        TableItem item = selection[0];
        this.showItem(item.handle);
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        int indices;
        if (selection != null && (indices = OS.gtk_tree_path_get_indices((int)path)) != 0) {
            int[] index = new int[1];
            OS.memmove((int[])index, (int)indices, (int)4);
            selection[length] = index[0];
        }
        return 0;
    }
}

