/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.PromptDialog;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIMemory;
import org.eclipse.swt.internal.mozilla.nsIPromptService;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWindowWatcher;
import org.eclipse.swt.widgets.MessageBox;

class PromptService {
    XPCOMObject supports;
    XPCOMObject promptService;
    int refCount = 0;

    public PromptService() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] args) {
                return PromptService.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return PromptService.this.AddRef();
            }

            public int method2(int[] args) {
                return PromptService.this.Release();
            }
        };
        int[] nArray2 = new int[12];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 5;
        nArray2[5] = 4;
        nArray2[6] = 6;
        nArray2[7] = 10;
        nArray2[8] = 7;
        nArray2[9] = 8;
        nArray2[10] = 7;
        nArray2[11] = 7;
        this.promptService = new XPCOMObject(nArray2){

            public int method0(int[] args) {
                return PromptService.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return PromptService.this.AddRef();
            }

            public int method2(int[] args) {
                return PromptService.this.Release();
            }

            public int method3(int[] args) {
                return PromptService.this.Alert(args[0], args[1], args[2]);
            }

            public int method4(int[] args) {
                return PromptService.this.AlertCheck(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method5(int[] args) {
                return PromptService.this.Confirm(args[0], args[1], args[2], args[3]);
            }

            public int method6(int[] args) {
                return PromptService.this.ConfirmCheck(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public int method7(int[] args) {
                return PromptService.this.ConfirmEx(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
            }

            public int method8(int[] args) {
                return PromptService.this.Prompt(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public int method9(int[] args) {
                return PromptService.this.PromptUsernameAndPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }

            public int method10(int[] args) {
                return PromptService.this.PromptPassword(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            public int method11(int[] args) {
                return PromptService.this.Select(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.promptService != null) {
            this.promptService.dispose();
            this.promptService = null;
        }
    }

    int getAddress() {
        return this.promptService.getAddress();
    }

    int queryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove((nsID)guid, (int)riid, (int)16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.supports.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIPromptService.NS_IPROMPTSERVICE_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.promptService.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove((int)ppvObject, (int[])new int[1], (int)4);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser(int aDOMWindow) {
        int[] result = new int[1];
        int rc = XPCOM.NS_GetServiceManager((int[])result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0;
        byte[] buffer = "@mozilla.org/embedcomp/window-watcher;1".getBytes();
        byte[] aContractID = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
        rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        serviceManager.Release();
        nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
        result[0] = 0;
        rc = windowWatcher.GetChromeForWindow(aDOMWindow, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        windowWatcher.Release();
        nsIWebBrowserChrome webBrowserChrome = new nsIWebBrowserChrome(result[0]);
        result[0] = 0;
        rc = webBrowserChrome.QueryInterface(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        webBrowserChrome.Release();
        nsIEmbeddingSiteWindow embeddingSiteWindow = new nsIEmbeddingSiteWindow(result[0]);
        result[0] = 0;
        rc = embeddingSiteWindow.GetSiteWindow(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        embeddingSiteWindow.Release();
        return Browser.findBrowser(result[0]);
    }

    String getLabel(int buttonFlag, int index, int buttonTitle) {
        String label = null;
        int flag = (buttonFlag & 255 * index) / index;
        switch (flag) {
            case 2: {
                label = SWT.getMessage("SWT_Cancel");
                break;
            }
            case 4: {
                label = SWT.getMessage("SWT_No");
                break;
            }
            case 1: {
                label = SWT.getMessage("SWT_OK");
                break;
            }
            case 5: {
                label = SWT.getMessage("SWT_Save");
                break;
            }
            case 3: {
                label = SWT.getMessage("SWT_Yes");
                break;
            }
            case 127: {
                int length = XPCOM.strlen_PRUnichar((int)buttonTitle);
                char[] dest = new char[length];
                XPCOM.memmove((char[])dest, (int)buttonTitle, (int)(length * 2));
                label = new String(dest);
            }
        }
        return label;
    }

    public int Alert(int parent, int dialogTitle, int text) {
        Browser browser = this.getBrowser(parent);
        int length = XPCOM.strlen_PRUnichar((int)dialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove((char[])dest, (int)dialogTitle, (int)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar((int)text);
        dest = new char[length];
        XPCOM.memmove((char[])dest, (int)text, (int)(length * 2));
        String textLabel = new String(dest);
        MessageBox messageBox = new MessageBox(browser.getShell(), 32);
        messageBox.setText(titleLabel);
        messageBox.setMessage(textLabel);
        messageBox.open();
        return 0;
    }

    public int AlertCheck(int parent, int dialogTitle, int text, int checkMsg, int checkValue) {
        return -2147467263;
    }

    public int Confirm(int parent, int dialogTitle, int text, int _retval) {
        Browser browser = this.getBrowser(parent);
        int length = XPCOM.strlen_PRUnichar((int)dialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove((char[])dest, (int)dialogTitle, (int)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar((int)text);
        dest = new char[length];
        XPCOM.memmove((char[])dest, (int)text, (int)(length * 2));
        String textLabel = new String(dest);
        MessageBox messageBox = new MessageBox(browser.getShell(), 288);
        messageBox.setText(titleLabel);
        messageBox.setMessage(textLabel);
        int id = messageBox.open();
        int[] result = new int[]{id == 32 ? 1 : 0};
        XPCOM.memmove((int)_retval, (int[])result, (int)4);
        return 0;
    }

    public int ConfirmCheck(int parent, int dialogTitle, int text, int checkMsg, int checkValue, int _retval) {
        return -2147467263;
    }

    public int ConfirmEx(int parent, int dialogTitle, int text, int buttonFlags, int button0Title, int button1Title, int button2Title, int checkMsg, int checkValue, int _retval) {
        Browser browser = this.getBrowser(parent);
        int length = XPCOM.strlen_PRUnichar((int)dialogTitle);
        char[] dest = new char[length];
        XPCOM.memmove((char[])dest, (int)dialogTitle, (int)(length * 2));
        String titleLabel = new String(dest);
        length = XPCOM.strlen_PRUnichar((int)text);
        dest = new char[length];
        XPCOM.memmove((char[])dest, (int)text, (int)(length * 2));
        String textLabel = new String(dest);
        String checkLabel = null;
        if (checkMsg != 0) {
            length = XPCOM.strlen_PRUnichar((int)checkMsg);
            dest = new char[length];
            XPCOM.memmove((char[])dest, (int)checkMsg, (int)(length * 2));
            checkLabel = new String(dest);
        }
        String button1Label = this.getLabel(buttonFlags, 1, button0Title);
        String button2Label = this.getLabel(buttonFlags, 256, button0Title);
        String button3Label = this.getLabel(buttonFlags, 65536, button0Title);
        PromptDialog dialog = new PromptDialog(browser.getShell());
        int[] check = new int[1];
        int[] result = new int[1];
        if (checkValue != 0) {
            XPCOM.memmove((int[])check, (int)checkValue, (int)4);
        }
        dialog.confirmEx(titleLabel, textLabel, checkLabel, button1Label, button2Label, button3Label, check, result);
        if (checkValue != 0) {
            XPCOM.memmove((int)checkValue, (int[])check, (int)4);
        }
        XPCOM.memmove((int)_retval, (int[])result, (int)4);
        return 0;
    }

    public int Prompt(int parent, int dialogTitle, int text, int value, int checkMsg, int checkValue, int _retval) {
        return -2147467263;
    }

    public int PromptUsernameAndPassword(int parent, int dialogTitle, int text, int username, int password, int checkMsg, int checkValue, int _retval) {
        char[] dest;
        int length;
        Browser browser = this.getBrowser(parent);
        String titleLabel = null;
        String checkLabel = null;
        String[] userLabel = new String[1];
        String[] passLabel = new String[1];
        if (dialogTitle != 0) {
            length = XPCOM.strlen_PRUnichar((int)dialogTitle);
            dest = new char[length];
            XPCOM.memmove((char[])dest, (int)dialogTitle, (int)(length * 2));
            titleLabel = new String(dest);
        } else {
            titleLabel = SWT.getMessage("SWT_Prompt");
        }
        length = XPCOM.strlen_PRUnichar((int)text);
        dest = new char[length];
        XPCOM.memmove((char[])dest, (int)text, (int)(length * 2));
        String textLabel = new String(dest);
        int[] userAddr = new int[1];
        XPCOM.memmove((int[])userAddr, (int)username, (int)4);
        if (userAddr[0] != 0) {
            length = XPCOM.strlen_PRUnichar((int)userAddr[0]);
            dest = new char[length];
            XPCOM.memmove((char[])dest, (int)userAddr[0], (int)(length * 2));
            userLabel[0] = new String(dest);
        }
        int[] passAddr = new int[1];
        XPCOM.memmove((int[])passAddr, (int)password, (int)4);
        if (passAddr[0] != 0) {
            length = XPCOM.strlen_PRUnichar((int)passAddr[0]);
            dest = new char[length];
            XPCOM.memmove((char[])dest, (int)passAddr[0], (int)(length * 2));
            passLabel[0] = new String(dest);
        }
        if (checkMsg != 0) {
            length = XPCOM.strlen_PRUnichar((int)checkMsg);
            dest = new char[length];
            XPCOM.memmove((char[])dest, (int)checkMsg, (int)(length * 2));
            checkLabel = new String(dest);
        }
        PromptDialog dialog = new PromptDialog(browser.getShell());
        int[] check = new int[1];
        int[] result = new int[1];
        if (checkValue != 0) {
            XPCOM.memmove((int[])check, (int)checkValue, (int)4);
        }
        dialog.promptUsernameAndPassword(titleLabel, textLabel, checkLabel, userLabel, passLabel, check, result);
        XPCOM.memmove((int)_retval, (int[])result, (int)4);
        if (result[0] == 1) {
            nsIMemory memory;
            byte[] aContractID;
            byte[] tmp;
            nsIServiceManager serviceManager;
            int rc;
            int ptr;
            int size;
            char[] buffer;
            int cnt;
            if (userLabel[0] != null) {
                cnt = userLabel[0].length();
                buffer = new char[cnt + 1];
                userLabel[0].getChars(0, cnt, buffer, 0);
                size = buffer.length * 2;
                ptr = XPCOM.PR_Malloc((int)size);
                XPCOM.memmove((int)ptr, (char[])buffer, (int)size);
                XPCOM.memmove((int)username, (int[])new int[]{ptr}, (int)4);
                if (userAddr[0] != 0) {
                    result[0] = 0;
                    rc = XPCOM.NS_GetServiceManager((int[])result);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result[0] == 0) {
                        SWT.error(-2147467262);
                    }
                    serviceManager = new nsIServiceManager(result[0]);
                    result[0] = 0;
                    tmp = "@mozilla.org/xpcom/memory-service;1".getBytes();
                    aContractID = new byte[tmp.length + 1];
                    System.arraycopy(tmp, 0, aContractID, 0, tmp.length);
                    rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result[0] == 0) {
                        SWT.error(-2147467262);
                    }
                    serviceManager.Release();
                    memory = new nsIMemory(result[0]);
                    result[0] = 0;
                    memory.Free(userAddr[0]);
                    memory.Release();
                }
            }
            if (passLabel[0] != null) {
                cnt = passLabel[0].length();
                buffer = new char[cnt + 1];
                passLabel[0].getChars(0, cnt, buffer, 0);
                size = buffer.length * 2;
                ptr = XPCOM.PR_Malloc((int)size);
                XPCOM.memmove((int)ptr, (char[])buffer, (int)size);
                XPCOM.memmove((int)password, (int[])new int[]{ptr}, (int)4);
                if (passAddr[0] != 0) {
                    result[0] = 0;
                    rc = XPCOM.NS_GetServiceManager((int[])result);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result[0] == 0) {
                        SWT.error(-2147467262);
                    }
                    serviceManager = new nsIServiceManager(result[0]);
                    result[0] = 0;
                    tmp = "@mozilla.org/xpcom/memory-service;1".getBytes();
                    aContractID = new byte[tmp.length + 1];
                    System.arraycopy(tmp, 0, aContractID, 0, tmp.length);
                    rc = serviceManager.GetServiceByContractID(aContractID, nsIMemory.NS_IMEMORY_IID, result);
                    if (rc != 0) {
                        SWT.error(rc);
                    }
                    if (result[0] == 0) {
                        SWT.error(-2147467262);
                    }
                    serviceManager.Release();
                    memory = new nsIMemory(result[0]);
                    result[0] = 0;
                    memory.Free(passAddr[0]);
                    memory.Release();
                }
            }
        }
        if (checkValue != 0) {
            XPCOM.memmove((int)checkValue, (int[])check, (int)4);
        }
        return 0;
    }

    public int PromptPassword(int parent, int dialogTitle, int text, int password, int checkMsg, int checkValue, int _retval) {
        return -2147467263;
    }

    public int Select(int parent, int dialogTitle, int text, int count, int selectList, int outSelection, int _retval) {
        return -2147467263;
    }
}

