/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Locale;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

/**
 * Used to map locale information to URI space, to find the relevant bundle.
 *
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version CVS $Revision: 1.1 $ $Date: 2002/01/02 19:04:56 $ $Author: neeme $
 */
public class ConfigurableBundleInfo extends BundleInfo implements Configurable {

    public ConfigurableBundleInfo() {
        this(null, null, null);
    }

    public ConfigurableBundleInfo(String name, Locale locale) {
        configure(name, locale, null);
    }

    public ConfigurableBundleInfo(String name, Locale locale, String ext) {
        configure(name, locale, ext);
    }

    public void configure(String name, Locale locale, String ext) {
        setName(name);
        setLocale(locale);
        setExtensionParameter(ext);
    }

    public void configure(String name, Locale locale) {
        configure(name, locale, null);
    }

    public void configure(Locale locale) {
        configure(null, locale);
    }

    public void configure(Configuration conf) {
        Locale locale = null;
        try {
            Configuration localeConf = conf.getChild("locale");
            locale = new Locale(localeConf.getAttribute("language"), localeConf.getAttribute("country"));
            locale = new Locale(localeConf.getAttribute("language"), localeConf.getAttribute("country"),
                                localeConf.getAttribute("variant"));
        }
        catch (ConfigurationException e) {
            // ignore
        }

        String bundleName = null;
        try {
            bundleName = conf.getAttribute("name");
        }
        catch (ConfigurationException e) {
            // ignore
        }

        String ext = null;
        try {
            ext = conf.getAttribute("ext");
        }
        catch (ConfigurationException e) {
            // ignore
        }
        configure(bundleName, locale, ext);
    }

}
