import java.util.*;
import org.apache.avalon.excalibur.collections.ArrayStack;

public class StackTest
{
 public static void main(String[] args)
 {
  int lInitialSize = Integer.parseInt(args[0]);
  int lIterations = Integer.parseInt(args[1]);
  ArrayList lArrayList = new ArrayList(lInitialSize + 1);
  LinkedList lLinkedList = new LinkedList();
  Stack lStack = new Stack();
  ArrayStack lArrayStack = new ArrayStack();
  long lBegin, lEnd;

  for (int i = 0; i < lInitialSize; i++)
  {
   lArrayList.add(new Integer(i));
   lLinkedList.add(new Integer(i));
   lStack.push(new Integer(i));
   lArrayStack.push(new Integer(i));
  }

  lBegin = System.currentTimeMillis();
  for (int i = 0; i < lIterations; i++)
  {
   lArrayList.add(new Integer(i));  // Add to the tail
   lArrayList.remove(lInitialSize);  // Remove from the tail
  }
  lEnd = System.currentTimeMillis();
  System.out.println("Time: " + (lEnd - lBegin));

  lBegin = System.currentTimeMillis();
  for (int i = 0; i < lIterations; i++)
  {
   lLinkedList.addLast(new Integer(i));  // Add to the tail
   lLinkedList.removeLast();  // Remove from the tail
  }
  lEnd = System.currentTimeMillis();
  System.out.println("Time: " + (lEnd - lBegin));

  lBegin = System.currentTimeMillis();
  for (int i = 0; i < lIterations; i++)
  {
   lStack.push( new Integer(i) );  // Add to the head
   lStack.pop();  // Remove from the tail
  }
  lEnd = System.currentTimeMillis();
  System.out.println("Time: " + (lEnd - lBegin));

  lBegin = System.currentTimeMillis();
  for (int i = 0; i < lIterations; i++)
  {
   lArrayStack.push( new Integer(i) );  // Add to the head
   lArrayStack.pop();  // Remove from the tail
  }
  lEnd = System.currentTimeMillis();
  System.out.println("Time: " + (lEnd - lBegin));
 }
}
