/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.util.Vector;

public class ConditionInfo {
    private String type;
    private String[] args;

    public ConditionInfo(String type, String[] args) {
        this.type = type;
        this.args = args;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
    }

    public ConditionInfo(String encodedCondition) {
        if (encodedCondition == null) {
            throw new NullPointerException("missing encoded permission");
        }
        if (encodedCondition.length() == 0) {
            throw new IllegalArgumentException("empty encoded permission");
        }
        try {
            int end;
            char[] encoded = encodedCondition.toCharArray();
            if (encoded[0] != '[') {
                throw new IllegalArgumentException("first character not open bracket");
            }
            int begin = end = 1;
            while (encoded[end] != ' ' && encoded[end] != ')') {
                ++end;
            }
            if (end == begin) {
                throw new IllegalArgumentException("expecting type");
            }
            this.type = new String(encoded, begin, end - begin);
            Vector<String> args = new Vector<String>();
            while (encoded[end] == ' ') {
                if (encoded[++end] != '\"') {
                    throw new IllegalArgumentException("expecting quoted name");
                }
                begin = ++end;
                while (encoded[end] != '\"') {
                    if (encoded[end] == '\\') {
                        ++end;
                    }
                    ++end;
                }
                args.add(ConditionInfo.decodeString(encoded, begin, end));
                ++end;
            }
            this.args = args.toArray(new String[0]);
            if (encoded[end] != ']' || end + 1 != encoded.length) {
                throw new IllegalArgumentException("last character not close bracket");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    public final String getEncoded() {
        StringBuffer output = new StringBuffer();
        output.append('[');
        output.append(this.type);
        int i = 0;
        while (i < this.args.length) {
            output.append(" \"");
            ConditionInfo.encodeString(this.args[i], output);
            output.append('\"');
            ++i;
        }
        output.append(']');
        return output.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String[] getArgs() {
        return this.args;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionInfo)) {
            return false;
        }
        ConditionInfo other = (ConditionInfo)obj;
        if (!this.type.equals(other.type) || this.args.length != other.args.length) {
            return false;
        }
        int i = 0;
        while (i < this.args.length) {
            if (!this.args[i].equals(other.args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        int i = 0;
        while (i < this.args.length) {
            hash ^= this.args[i].hashCode();
            ++i;
        }
        return hash;
    }

    private static void encodeString(String str, StringBuffer output) {
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    output.append('\\');
                    output.append(c);
                    break;
                }
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\n': {
                    output.append("\\n");
                    break;
                }
                default: {
                    output.append(c);
                }
            }
            ++i;
        }
    }

    private static String decodeString(char[] str, int begin, int end) {
        StringBuffer output = new StringBuffer(end - begin);
        int i = begin;
        while (i < end) {
            int c = str[i];
            if (c == 92 && ++i < end) {
                c = str[i];
                if (c == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                }
            }
            output.append((char)c);
            ++i;
        }
        return output.toString();
    }
}

