/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.jdom.DOMFactory;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMMethod;
import org.aspectj.org.eclipse.jdt.core.jdom.IDOMNode;
import org.aspectj.org.eclipse.jdt.internal.core.CreateTypeMemberOperation;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;

public class CreateMethodOperation
extends CreateTypeMemberOperation {
    protected String[] fParameterTypes;

    public CreateMethodOperation(IType parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected String[] convertDOMMethodTypesToSignatures() {
        String[] domParameterTypes;
        if (this.fParameterTypes == null && this.isDOMNodeNull() && (domParameterTypes = ((IDOMMethod)this.fDOMNode).getParameterTypes()) != null) {
            this.fParameterTypes = new String[domParameterTypes.length];
            int i = 0;
            while (i < this.fParameterTypes.length) {
                this.fParameterTypes[i] = Signature.createTypeSignature(domParameterTypes[i].toCharArray(), false);
                ++i;
            }
        }
        return this.fParameterTypes;
    }

    protected IDOMNode generateElementDOM() throws JavaModelException {
        if (this.fDOMNode == null) {
            this.fDOMNode = new DOMFactory().createMethod(this.fSource);
            if (this.fDOMNode == null) {
                this.fDOMNode = this.generateSyntaxIncorrectDOM();
                if (this.fDOMNode == null) {
                    throw new JavaModelException(new JavaModelStatus(984));
                }
            }
            if (this.fAlteredName != null && this.isDOMNodeNull()) {
                this.fDOMNode.setName(this.fAlteredName);
            }
        }
        if (!(this.fDOMNode instanceof IDOMMethod)) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return this.fDOMNode;
    }

    protected IJavaElement generateResultHandle() {
        String[] types = this.convertDOMMethodTypesToSignatures();
        String name = this.computeName();
        return this.getType().getMethod(name, types);
    }

    private String computeName() {
        String name = ((IDOMMethod)this.fDOMNode).isConstructor() ? this.fDOMNode.getParent().getName() : this.getDOMNodeName();
        return name;
    }

    private String getDOMNodeName() {
        return this.fDOMNode.getName();
    }

    public String getMainTaskName() {
        return Util.bind("operation.createMethodProgress");
    }

    protected IJavaModelStatus verifyNameCollision() {
        if (this.isDOMNodeNull()) {
            String[] types;
            IType type = this.getType();
            String name = this.getDOMNodeName();
            if (name == null) {
                name = type.getElementName();
            }
            if (type.getMethod(name, types = this.convertDOMMethodTypesToSignatures()).exists()) {
                return new JavaModelStatus(977, Util.bind("status.nameCollision", name));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    private boolean isDOMNodeNull() {
        return this.fDOMNode != null;
    }
}

