/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.aspectj.internal.tools.ant.taskdefs.Header;
import org.aspectj.internal.tools.ant.taskdefs.HeaderInfo;

public class Checklics
extends MatchingTask {
    public static final String MPL_TAG = "mpl";
    public static final String APACHE_TAG = "apache";
    public static final String CPL_IBM_PARC_TAG = "cpl-ibm|parc";
    public static final String CPL_IBM_TAG = "cpl-ibm";
    public static final String MPL_XEROX_PARC_TAG = "mpl-parc|xerox";
    public static final String MPL_ONLY_TAG = "mpl-only";
    public static final String MPL_PARC_TAG = "mpl-parc";
    public static final String PARC_COPYRIGHT_TAG = "parc-copy";
    public static final String CPL_IBM_PARC_XEROX_TAG = "cpl-ibm|parc|xerox";
    public static final String CPL_IBM_PARC_XEROX_OTHERS_TAG = "cpl-ibm|parc|xerox|others";
    public static final String EPL_CPL_IBM_PARC_XEROX_OTHERS_TAG = "epl-cpl-ibm|parc|xerox|others";
    public static final String DEFAULT = "epl-cpl-ibm|parc|xerox|others";
    static final Map LICENSES;
    private Path sourcepath;
    private License license;
    private boolean list;
    private String streamTag;
    private boolean failOnError;
    private boolean getYears;
    private boolean replaceHeaders;
    private int failed;
    private int passed;
    private boolean printDirectories;

    public static void main(String[] args) {
        switch (args.length) {
            case 1: {
                Checklics.runDirect(args[0], null, false);
                break;
            }
            case 2: {
                Checklics.runDirect(args[0], args[1], false);
                break;
            }
            default: {
                String options = "{replace-headers|get-years|list|{licenseTag}}";
                System.err.println("java {me} sourcepath " + options);
            }
        }
    }

    public static int runDirect(String sourcepath, String license, boolean failonerror) {
        if (null == sourcepath || 1 > sourcepath.length()) {
            throw new IllegalArgumentException("bad sourcepath: " + sourcepath);
        }
        Checklics me = new Checklics();
        Project p = new Project();
        p.setName("direct interface to Checklics");
        p.setBasedir(".");
        me.setProject(p);
        me.setFailOnError(failonerror);
        me.setSourcepath(new Path(p, sourcepath));
        if (null != license) {
            if ("replace-headers".equals(license)) {
                me.setReplaceheaders(true);
            } else if ("get-years".equals(license)) {
                me.setGetYears(true);
            } else if ("list".equals(license)) {
                me.setList(true);
            } else {
                me.setLicense(license);
            }
        }
        me.execute();
        return me.failed;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public void setPrintDirectories(boolean print) {
        this.printDirectories = print;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setLicense(String tl) {
        License input = (License)LICENSES.get(tl);
        if (null == input) {
            throw new BuildException("no license known for " + tl);
        }
        this.license = input;
    }

    public void setSourcepath(Path path) {
        if (this.sourcepath == null) {
            this.sourcepath = path;
        } else {
            this.sourcepath.append(path);
        }
    }

    public Path createSourcepath() {
        return this.sourcepath == null ? (this.sourcepath = new Path(((ProjectComponent)this).project)) : this.sourcepath.createPath();
    }

    public void setSourcepathRef(Reference id) {
        this.createSourcepath().setRefid(id);
    }

    public void setOutputStream(String out) {
        this.streamTag = out;
    }

    public void setReplaceheaders(boolean replaceHeaders) {
        this.replaceHeaders = replaceHeaders;
    }

    public void setGetYears(boolean getYears) {
        this.getYears = getYears;
    }

    public void execute() throws BuildException {
        if (this.list) {
            this.list();
        } else if (this.replaceHeaders) {
            this.replaceHeaders();
        } else if (this.getYears) {
            this.getYears();
        } else {
            this.checkLicenses();
        }
    }

    private PrintStream getOut() {
        return "err".equals(this.streamTag) ? System.err : System.out;
    }

    private void visitAll(FileVisitor visitor) {
        String[] dirs = this.sourcepath.list();
        for (int i = 0; i < dirs.length; ++i) {
            File dir = ((ProjectComponent)this).project.resolveFile(dirs[i]);
            String[] files = this.getDirectoryScanner(dir).getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                File file = new File(dir, files[j]);
                String path = file.getPath();
                if (!path.endsWith(".java")) continue;
                visitor.visit(file);
            }
        }
    }

    private void replaceHeaders() {
        class YearVisitor
        implements FileVisitor {
            YearVisitor() {
            }

            public void visit(File file) {
                HeaderInfo info = Header.checkFile(file);
                if (!Header.replaceHeader(file, info)) {
                    throw new BuildException("failed to replace header for " + file + " using " + info);
                }
            }
        }
        this.visitAll(new YearVisitor());
    }

    private void getYears() {
        PrintStream out = this.getOut();
        class YearVisitor
        implements FileVisitor {
            private final /* synthetic */ PrintStream val$out;

            YearVisitor(PrintStream printStream) {
                this.val$out = printStream;
            }

            public void visit(File file) {
                HeaderInfo info = Header.checkFile(file);
                this.val$out.println(info.toString());
            }
        }
        this.visitAll(new YearVisitor(out));
    }

    private void checkLicenses() throws BuildException {
        License license;
        if (null == this.license) {
            this.setLicense("epl-cpl-ibm|parc|xerox|others");
        }
        if (null == (license = this.license)) {
            throw new BuildException("no license");
        }
        PrintStream out = this.getOut();
        class Visitor
        implements FileVisitor {
            int failed = 0;
            int passed = 0;
            private final /* synthetic */ License val$license;
            private final /* synthetic */ PrintStream val$out;

            Visitor(License license, PrintStream printStream) {
                this.val$license = license;
                this.val$out = printStream;
            }

            public void visit(File file) {
                if (this.val$license.checkFile(file)) {
                    ++this.passed;
                } else {
                    ++this.failed;
                    String path = file.getPath();
                    if (!this.val$license.foundLicense()) {
                        this.val$out.println(this.val$license.tag + "   LICENSE FAIL: " + path);
                    }
                    if (!this.val$license.foundCopyright()) {
                        this.val$out.println(this.val$license.tag + " COPYRIGHT FAIL: " + path);
                    }
                }
            }
        }
        Visitor visitor = new Visitor(license, out);
        this.visitAll(visitor);
        this.failed = visitor.failed;
        this.passed = visitor.passed;
        if (0 < visitor.failed) {
            this.getOut().println("Total passed: " + visitor.passed + (visitor.failed == 0 ? "" : " failed: " + visitor.failed));
            if (this.failOnError) {
                throw new BuildException(this.failed + " files failed license check");
            }
        }
    }

    private void list() {
        Iterator enu = LICENSES.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("known license keys:");
        boolean first = true;
        while (enu.hasNext()) {
            sb.append((first ? " " : ", ") + enu.next());
            if (!first) continue;
            first = false;
        }
        this.getOut().println(sb.toString());
    }

    static {
        String CONTRIBUTORS = "Contributors";
        String XEROX = "Xerox";
        String PARC = "Palo Alto Research Center";
        String APACHE = "The Apache Software Foundation";
        String IBM = "IBM";
        String IBM_LONG = "International Business Machines";
        String LIC_APL = "Apache Software Foundation (http://www.apache.org/)";
        String LIC_MPL = "http://aspectj.org/MPL/";
        String LIC_CPL = "Eclipse Public License";
        String LIC_ECPL = " Public License";
        License APL = new License(APACHE_TAG, "Apache Software Foundation (http://www.apache.org/)", "The Apache Software Foundation");
        License MPL = new License(MPL_TAG, "http://aspectj.org/MPL/", "Xerox");
        License MPL_XEROX_PARC = new License("epl-cpl-ibm|parc|xerox|others", "http://aspectj.org/MPL/", "Xerox", "Palo Alto Research Center");
        License CPL_IBM_PARC = new License(CPL_IBM_PARC_TAG, "Eclipse Public License", new String[]{"International Business Machines", "IBM", "Palo Alto Research Center"});
        License CPL_IBM_PARC_XEROX = new License(CPL_IBM_PARC_XEROX_TAG, "Eclipse Public License", new String[]{"International Business Machines", "IBM", "Palo Alto Research Center", "Xerox"});
        License CPL_IBM_PARC_XEROX_OTHERS = new License(CPL_IBM_PARC_XEROX_OTHERS_TAG, "Eclipse Public License", new String[]{"International Business Machines", "IBM", "Palo Alto Research Center", "Xerox", "Contributors"});
        License EPL_CPL_IBM_PARC_XEROX_OTHERS = new License("epl-cpl-ibm|parc|xerox|others", " Public License", new String[]{"International Business Machines", "IBM", "Palo Alto Research Center", "Xerox", "Contributors"});
        License CPL_IBM = new License(CPL_IBM_TAG, "Eclipse Public License", "IBM", "International Business Machines");
        License MPL_ONLY = new License(MPL_ONLY_TAG, "http://aspectj.org/MPL/");
        License MPL_PARC = new License(MPL_PARC_TAG, "http://aspectj.org/MPL/", "Palo Alto Research Center");
        License PARC_COPYRIGHT = new License(PARC_COPYRIGHT_TAG, null, "Palo Alto Research Center");
        LICENSES = new Hashtable();
        LICENSES.put(APL.tag, APL);
        LICENSES.put(MPL.tag, MPL);
        LICENSES.put(MPL_PARC.tag, MPL_PARC);
        LICENSES.put(MPL_XEROX_PARC.tag, MPL_XEROX_PARC);
        LICENSES.put(CPL_IBM_PARC.tag, CPL_IBM_PARC);
        LICENSES.put(MPL_ONLY.tag, MPL_ONLY);
        LICENSES.put(CPL_IBM.tag, CPL_IBM);
        LICENSES.put(PARC_COPYRIGHT.tag, PARC_COPYRIGHT);
        LICENSES.put(CPL_IBM_PARC_XEROX.tag, CPL_IBM_PARC_XEROX);
        LICENSES.put(CPL_IBM_PARC_XEROX_OTHERS.tag, CPL_IBM_PARC_XEROX_OTHERS);
        LICENSES.put(EPL_CPL_IBM_PARC_XEROX_OTHERS.tag, EPL_CPL_IBM_PARC_XEROX_OTHERS);
    }

    public static class License {
        static final String[] YEARS = new String[]{"2002 ", "2003 ", "2004 ", "2005", "2006", "2007", "2001 ", "2000 ", "1999 "};
        public final String tag;
        public final String license;
        private final String[] copyright;
        private boolean gotLicense;
        private boolean gotCopyright;

        License(String tag, String license) {
            this(tag, license, (String[])null);
        }

        License(String tag, String license, String copyright) {
            this(tag, license, new String[]{copyright});
        }

        License(String tag, String license, String copyright, String altCopyright) {
            this(tag, license, new String[]{copyright, altCopyright});
        }

        License(String tag, String license, String[] copyright) {
            this.tag = tag;
            if (null == tag || 0 == tag.length()) {
                throw new IllegalArgumentException("null tag");
            }
            this.license = license;
            this.copyright = copyright;
        }

        public final boolean gotValidFile() {
            return this.foundLicense() && this.foundCopyright();
        }

        public final boolean foundLicense() {
            return null == this.license || this.gotLicense;
        }

        public final boolean foundCopyright() {
            return null == this.copyright || this.gotCopyright;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkFile(File file) {
            this.clear();
            BufferedReader input = null;
            int lineNum = 0;
            try {
                String line;
                input = new BufferedReader(new FileReader(file));
                while (!this.gotValidFile() && (line = input.readLine()) != null) {
                    ++lineNum;
                    this.checkLine(line);
                }
            }
            catch (IOException e) {
                System.err.println("reading line " + lineNum + " of " + file);
                e.printStackTrace(System.err);
            }
            finally {
                if (null != input) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
            return this.gotValidFile();
        }

        public String toString() {
            return this.tag;
        }

        private void checkLine(String line) {
            if (null == line || 0 == line.length()) {
                return;
            }
            if (!this.gotLicense && null != this.license && -1 != line.indexOf(this.license)) {
                this.gotLicense = true;
            }
            if (!this.gotCopyright && null != this.copyright) {
                for (int j = 0; !this.gotCopyright && j < YEARS.length; ++j) {
                    int loc = line.indexOf(YEARS[j]);
                    if (-1 == loc) continue;
                    String afterLoc = line.substring(loc += YEARS[j].length()).trim();
                    for (int i = 0; !this.gotCopyright && i < this.copyright.length; ++i) {
                        if (0 != afterLoc.indexOf(this.copyright[i])) continue;
                        this.gotCopyright = true;
                    }
                }
            }
        }

        private void clear() {
            if (this.gotLicense) {
                this.gotLicense = false;
            }
            if (this.gotCopyright) {
                this.gotCopyright = false;
            }
        }
    }

    static interface FileVisitor {
        public void visit(File var1);
    }
}

