/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_ILNO.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_isLongnameOption
su(bsystem): cmdline
ty(pe): L
sy(nopsis): 
sh(ort description): identify a longname option
he(ader files): 
lo(ng description): Check if the current found syntactically correct
	longname option is semantically correct, meaning if it is found
	in the longname array of the current cfg stack.
pr(erequistes): 
va(lue): NULL: if not \item else: pointer to entry into longname array
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_ilno.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_ILNO.C 1.4 2001/02/27 01:28:03 ska Exp ska $";
#endif

struct Cfg_LongOptions *cfg_isLongnameOption(
	struct Cfg_LongOptions * const options
	, const char * const name)
{	struct Cfg_LongOptions *act;

	DBG_ENTER("cfg_isLongnameOption", Suppl_cmdline)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	if((act = options) != 0)
		for(;act->shortname; sInc(act))
			if(cfgEqName(act->longname, name)) {	/* found */
				DBG_RETURN_VALUES(("longname associted to: %d", act->shortname) )
				DBG_LEAVE( act)
			}

	DBG_RETURN_VALUES(("No longname option") )
	DBG_LEAVE(0)
}
