/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.custom;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.widgets.Table;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Dimension;
import swingwt.awt.FlowLayout;
import swingwt.awt.Toolkit;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.FocusListener;
import swingwt.awt.event.ItemEvent;
import swingwt.awt.event.ItemListener;
import swingwt.awt.event.KeyAdapter;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwt.awt.event.MouseAdapter;
import swingwt.awt.event.MouseEvent;
import swingwtx.custom.JLookupPopup;
import swingwtx.swing.JButton;
import swingwtx.swing.JFrame;
import swingwtx.swing.JList;
import swingwtx.swing.JPanel;
import swingwtx.swing.JTextField;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.PopupMenuEvent;
import swingwtx.swing.event.PopupMenuListener;

public class JLookupPopup
extends JPanel {
    protected Vector items = new Vector();
    protected Vector popupListeners = new Vector();
    protected Vector itemListeners = new Vector();
    protected JTextField text = new JTextField();
    protected JButton button = new JButton("...");
    protected int selectedIndex = -1;
    protected static final int CANCELED = 0;
    protected static final int INVISIBLE = 1;
    protected static final int VISIBLE = 2;

    public JLookupPopup() {
        this.setLayout(new BorderLayout());
        this.text.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 0x1000002) {
                    JLookupPopup.this.nextItem();
                    e.consume();
                } else if (e.getKeyCode() == 0x1000001) {
                    JLookupPopup.this.previousItem();
                    e.consume();
                } else if (e.getKeyChar() == ' ') {
                    JLookupPopup.this.buttonPressed();
                    e.consume();
                } else {
                    JLookupPopup.this.alphaSearchItem(e.getKeyChar());
                    e.consume();
                }
            }
        });
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JLookupPopup.this.buttonPressed();
            }
        });
        this.add((Component)this.text, "Center");
        this.add((Component)this.button, "East");
    }

    public void addFocusListener(FocusListener l) {
        this.text.addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.text.removeFocusListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.text.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.text.removeKeyListener(l);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.popupListeners.add(l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.popupListeners.remove(l);
    }

    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    public void processPopupMenuEvent(int id) {
        Iterator i = this.popupListeners.iterator();
        PopupMenuEvent e = new PopupMenuEvent(this);
        while (i.hasNext()) {
            PopupMenuListener l = (PopupMenuListener)i.next();
            switch (id) {
                case 0: {
                    l.popupMenuCanceled(e);
                    break;
                }
                case 1: {
                    l.popupMenuWillBecomeInvisible(e);
                    break;
                }
                case 2: {
                    l.popupMenuWillBecomeVisible(e);
                }
            }
        }
    }

    public void processItemEvent(ItemEvent e) {
        Iterator i = this.itemListeners.iterator();
        while (i.hasNext()) {
            ItemListener l = (ItemListener)i.next();
            l.itemStateChanged(e);
        }
    }

    public void addItem(Object item) {
        this.items.add(item);
        if (this.items.size() == 1) {
            this.setSelectedIndex(0);
        }
    }

    public void removeItem(Object item) {
        this.items.remove(item);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int i) {
        this.selectedIndex = i;
        this.text.setText(this.items.get(i).toString());
    }

    public void setSelectedItem(Object o) {
        this.text.setText(o.toString());
        this.selectedIndex = this.items.indexOf(o);
    }

    public Object getSelectedItem() {
        return this.items.get(this.selectedIndex);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public Object getItemAt(int index) {
        return this.items.get(index);
    }

    public void removeAllItems() {
        this.items.removeAllElements();
        this.text.setText("");
        this.selectedIndex = -1;
    }

    public void setEnabled(boolean b) {
        this.text.setEnabled(b);
        this.button.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public String getToolTipText() {
        return this.text.getToolTipText();
    }

    public void setToolTipText(String tip) {
        this.text.setToolTipText(tip);
    }

    public void setMaximumRowCount(int i) {
    }

    protected void buttonPressed() {
        new LookupPopup(this);
    }

    protected void previousItem() {
        if (this.items.size() == 0) {
            return;
        }
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        if (this.getSelectedIndex() > 0) {
            this.setSelectedIndex(this.getSelectedIndex() - 1);
        }
    }

    protected void nextItem() {
        if (this.items.size() == 0) {
            return;
        }
        if (this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        if (this.getSelectedIndex() < this.items.size() - 1) {
            this.setSelectedIndex(this.getSelectedIndex() + 1);
        }
    }

    protected void alphaSearchItem(char cs) {
        int currentlySelected = this.getSelectedIndex();
        String curChar = "";
        if (currentlySelected != -1) {
            curChar = this.getSelectedItem().toString().substring(0, 1).toLowerCase();
        }
        boolean foundMatch = false;
        for (int i = 0; i < this.items.size(); ++i) {
            String s = this.items.get(i).toString();
            if (!s.substring(0, 1).toLowerCase().equals(new String(new char[]{cs}).toLowerCase())) continue;
            if (curChar.equals(new String(new char[]{cs}).toLowerCase())) {
                i = currentlySelected + 1;
            }
            if (i >= this.items.size()) break;
            if (!this.items.get(i).toString().substring(0, 1).toLowerCase().equals(new String(new char[]{cs}).toLowerCase())) break;
            this.setSelectedIndex(i);
            break;
        }
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    public void grabFocus() {
        this.text.grabFocus();
    }

    public JTextField getJTextField() {
        return this.text;
    }

    private class LookupPopup
    extends JFrame {
        private JLookupPopup popup = null;
        private JList lst = null;

        public LookupPopup(JLookupPopup selector) {
            this.popup = selector;
            SwingUtilities.invokeSync(new Runnable(this, JLookupPopup.this){
                private final /* synthetic */ JLookupPopup val$this$0;
                private final /* synthetic */ LookupPopup this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void run() {
                    LookupPopup.access$002(this.this$1, new JList(LookupPopup.access$100((LookupPopup)this.this$1).items));
                    LookupPopup.access$000(this.this$1).addMouseListener(new MouseAdapter(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 2) {
                                3.access$200(this.this$2).btnOkPressed();
                            }
                        }
                    });
                    JButton btnOk = new JButton("Ok");
                    btnOk.setMnemonic('o');
                    btnOk.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void actionPerformed(ActionEvent e) {
                            3.access$200(this.this$2).btnOkPressed();
                        }
                    });
                    JButton btnCancel = new JButton("Cancel");
                    btnCancel.setMnemonic('c');
                    btnCancel.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void actionPerformed(ActionEvent e) {
                            3.access$200(this.this$2).btnCancelPressed();
                        }
                    });
                    JPanel pnlButtons = new JPanel();
                    pnlButtons.setLayout(new FlowLayout());
                    pnlButtons.add(btnOk);
                    pnlButtons.add(btnCancel);
                    this.this$1.getContentPane().setLayout(new BorderLayout());
                    this.this$1.getContentPane().add((Component)LookupPopup.access$000(this.this$1), "Center");
                    this.this$1.getContentPane().add((Component)pnlButtons, "South");
                }

                static /* synthetic */ LookupPopup access$200(3 x0) {
                    return x0.this$1;
                }
            });
            int mouseX = SwingWTUtils.getDisplay().getCursorLocation().x;
            int mouseY = SwingWTUtils.getDisplay().getCursorLocation().y;
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (mouseX > screen.width - 400) {
                mouseX = screen.width - 400;
            }
            if (mouseY > screen.height - 400) {
                mouseY = screen.height - 400;
            }
            this.setSize(400, 400);
            this.setLocation(mouseX, mouseY);
            this.setTitle("Select");
            this.show();
            SwingUtilities.invokeIn(new Runnable(this){
                private final /* synthetic */ LookupPopup this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    LookupPopup.access$000(this.this$1).grabFocus();
                    if (LookupPopup.access$100(this.this$1).getSelectedIndex() != -1) {
                        LookupPopup.access$000(this.this$1).setSelectedIndex(LookupPopup.access$100(this.this$1).getSelectedIndex());
                    }
                    ((Table)LookupPopup.access$000(this.this$1).getSWTPeer()).showSelection();
                    LookupPopup.access$100(this.this$1).processPopupMenuEvent(2);
                }
            }, 100);
        }

        protected void btnOkPressed() {
            this.popup.processItemEvent(new ItemEvent(this.popup, 1, this.popup.getSelectedItem(), 0));
            this.popup.setSelectedIndex(this.lst.getSelectedIndex());
            this.dispose();
            this.popup.processItemEvent(new ItemEvent(this.popup, 0, this.popup.getSelectedItem(), 0));
            this.popup.processPopupMenuEvent(1);
        }

        protected void btnCancelPressed() {
            this.popup.processPopupMenuEvent(0);
            this.dispose();
            this.popup.processPopupMenuEvent(1);
        }

        static /* synthetic */ JList access$002(LookupPopup x0, JList x1) {
            x0.lst = x1;
            return x0.lst;
        }

        static /* synthetic */ JLookupPopup access$100(LookupPopup x0) {
            return x0.popup;
        }

        static /* synthetic */ JList access$000(LookupPopup x0) {
            return x0.lst;
        }
    }
}

