/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.widgets;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

class ImageBorder
extends AbstractBorder {
    private Insets imgInsets;
    private Image image;
    private Dimension imageSize;

    public ImageBorder(Image image) {
        this.setImage(image);
    }

    public Insets getInsets(IFigure figure) {
        return this.imgInsets;
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getPreferredSize(IFigure f) {
        return this.imageSize;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        if (this.image == null) {
            return;
        }
        Rectangle rect = AbstractBorder.getPaintRectangle(figure, insets);
        int x = rect.x;
        int y = rect.y + (rect.height - this.imageSize.height) / 2;
        graphics.drawImage(this.getImage(), x, y);
    }

    public void setImage(Image img) {
        this.image = img;
        this.imageSize = new Dimension(this.image);
        this.imgInsets = new Insets();
        this.imgInsets.left = this.imageSize.width;
    }
}

