/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFragmentBox;

public class TextFlow
extends InlineFlow {
    static final String ELLIPSIS = "...";
    private String text;

    public TextFlow() {
        this(new String());
    }

    public TextFlow(String s) {
        this.text = s;
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new ParagraphTextLayout(this);
    }

    public String getText() {
        return this.text;
    }

    public boolean isTextTruncated() {
        int i = 0;
        while (i < this.fragments.size()) {
            if (((TextFragmentBox)this.fragments.get((int)i)).truncated) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void paintFigure(Graphics g) {
        int i = 0;
        while (i < this.fragments.size()) {
            TextFragmentBox frag = (TextFragmentBox)this.fragments.get(i);
            String draw = !frag.truncated ? this.text.substring(frag.offset, frag.offset + frag.length) : String.valueOf(this.text.substring(frag.offset, frag.offset + frag.length)) + ELLIPSIS;
            if (!this.isEnabled()) {
                g.setForegroundColor(ColorConstants.buttonLightest);
                g.drawString(draw, frag.x + 1, frag.y + 1);
                g.setForegroundColor(ColorConstants.buttonDarker);
                g.drawString(draw, frag.x, frag.y);
                g.restoreState();
            } else {
                g.drawString(draw, frag.x, frag.y);
            }
            ++i;
        }
    }

    public void setText(String s) {
        this.text = s;
        this.revalidate();
        this.repaint();
    }
}

