/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class PrinterGraphics
extends ScaledGraphics {
    Map imageCache = new HashMap();
    Printer printer;

    public PrinterGraphics(Graphics g, Printer p) {
        super(g);
        this.printer = p;
    }

    Font createFont(FontData data) {
        return new Font((Device)this.printer, data);
    }

    private Image printerImage(Image image) {
        Image result = (Image)this.imageCache.get(image);
        if (result != null) {
            return result;
        }
        result = new Image((Device)this.printer, image.getImageData());
        this.imageCache.put(image, result);
        return result;
    }

    public void drawImage(Image srcImage, int x, int y) {
        super.drawImage(this.printerImage(srcImage), x, y);
    }

    public void drawImage(Image srcImage, int sx, int sy, int sw, int sh, int tx, int ty, int tw, int th) {
        super.drawImage(this.printerImage(srcImage), sx, sy, sw, sh, tx, ty, tw, th);
    }

    int zoomFontHeight(int height) {
        return (int)((double)height * this.zoom * (double)Display.getCurrent().getDPI().y / (double)this.printer.getDPI().y + 1.0E-7);
    }

    int zoomLineWidth(int w) {
        return (int)((double)w * this.zoom);
    }
}

