/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.presentations;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PresentationUtil {
    private static Control dragControl;
    private static Point anchor;
    private static final int HYSTERESIS = 10;
    private static final String LISTENER_ID;
    private static Event dragEvent;
    private static Listener dragListener;
    private static Listener moveListener;
    private static Listener clickListener;
    private static Listener mouseDownListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.presentations.PresentationUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LISTENER_ID = String.valueOf(clazz.getName()) + ".dragListener";
        dragListener = new Listener(){

            public void handleEvent(Event event) {
                dragEvent = event;
            }
        };
        moveListener = new Listener(){

            public void handleEvent(Event event) {
                PresentationUtil.handleMouseMove(event);
            }
        };
        clickListener = new Listener(){

            public void handleEvent(Event e) {
                PresentationUtil.handleMouseClick(e);
            }
        };
        mouseDownListener = new Listener(){

            public void handleEvent(Event event) {
                dragControl = (Control)event.widget;
                anchor = PresentationUtil.getEventLoc(event);
            }
        };
    }

    private static boolean hasMovedEnough(Event event) {
        return Geometry.distanceSquared((Point)PresentationUtil.getEventLoc(event), (Point)anchor) >= 100;
    }

    private static Point getEventLoc(Event event) {
        Control ctrl = (Control)event.widget;
        return ctrl.toDisplay(new Point(event.x, event.y));
    }

    private static void handleMouseClick(Event event) {
        PresentationUtil.cancelDrag();
    }

    private static void handleMouseMove(Event e) {
        if (dragControl != null && dragEvent != null && PresentationUtil.hasMovedEnough(e)) {
            Control c = dragControl;
            Listener l = (Listener)c.getData(LISTENER_ID);
            Event de = dragEvent;
            PresentationUtil.cancelDrag();
            if (l != null) {
                l.handleEvent(de);
            }
        }
    }

    private static void cancelDrag() {
        if (dragControl != null) {
            dragControl = null;
        }
        dragEvent = null;
    }

    public static void addDragListener(Control control, Listener externalDragListener) {
        control.addListener(29, dragListener);
        control.addListener(4, clickListener);
        control.addListener(8, clickListener);
        control.addListener(3, mouseDownListener);
        control.addListener(5, moveListener);
        control.setData(LISTENER_ID, (Object)externalDragListener);
    }

    public static void removeDragListener(Control control, Listener externalDragListener) {
        control.removeListener(29, dragListener);
        control.removeListener(4, clickListener);
        control.removeListener(8, clickListener);
        control.removeListener(3, mouseDownListener);
        control.removeListener(5, moveListener);
        control.setData(LISTENER_ID, null);
    }
}

